/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import forestry.api.mail.EnumPostage;
import forestry.api.mail.ILetter;
import forestry.api.mail.IMailAddress;
import forestry.api.mail.IPostOffice;
import forestry.api.mail.IPostalCarrier;
import forestry.api.mail.IPostalState;
import forestry.api.mail.IStamps;
import forestry.api.mail.ITradeStation;
import forestry.api.mail.PostManager;
import forestry.mail.EnumDeliveryState;
import forestry.mail.MailAddress;
import forestry.mail.items.EnumStampDefinition;
import forestry.plugins.PluginMail;
import java.io.File;
import java.util.LinkedHashMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class PostOffice
extends WorldSavedData
implements IPostOffice {
    public static final String SAVE_NAME = "ForestryMail";
    private final int[] collectedPostage = new int[EnumPostage.values().length];
    private LinkedHashMap<IMailAddress, ITradeStation> activeTradeStations;

    public PostOffice() {
        super(SAVE_NAME);
    }

    public PostOffice(String s) {
        super(s);
    }

    public void setWorld(World world) {
        this.refreshActiveTradeStations(world);
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        for (int i = 0; i < this.collectedPostage.length; ++i) {
            if (!nbttagcompound.hasKey("CPS" + i)) continue;
            this.collectedPostage[i] = nbttagcompound.getInteger("CPS" + i);
        }
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        for (int i = 0; i < this.collectedPostage.length; ++i) {
            nbttagcompound.setInteger("CPS" + i, this.collectedPostage[i]);
        }
    }

    public LinkedHashMap<IMailAddress, ITradeStation> getActiveTradeStations(World world) {
        return this.activeTradeStations;
    }

    private void refreshActiveTradeStations(World world) {
        this.activeTradeStations = new LinkedHashMap();
        if (world == null || world.getSaveHandler() == null) {
            return;
        }
        File worldSave = world.getSaveHandler().getMapFileFromName("dummy");
        if (worldSave == null) {
            return;
        }
        File file = worldSave.getParentFile();
        if (!file.exists() || !file.isDirectory()) {
            return;
        }
        for (String str : file.list()) {
            MailAddress address;
            ITradeStation trade;
            if (!str.startsWith("TradePO_") || !str.endsWith(".dat") || (trade = PostManager.postRegistry.getTradeStation(world, address = new MailAddress(str.replace("TradePO_", "").replace(".dat", "")))) == null) continue;
            this.registerTradeStation(trade);
        }
    }

    @Override
    public void registerTradeStation(ITradeStation trade) {
        if (!this.activeTradeStations.containsKey(trade.getAddress())) {
            this.activeTradeStations.put(trade.getAddress(), trade);
        }
    }

    @Override
    public void deregisterTradeStation(ITradeStation trade) {
        this.activeTradeStations.remove(trade.getAddress());
    }

    @Override
    public ItemStack getAnyStamp(int max) {
        return this.getAnyStamp(EnumPostage.values(), max);
    }

    @Override
    public ItemStack getAnyStamp(EnumPostage postage, int max) {
        return this.getAnyStamp(new EnumPostage[]{postage}, max);
    }

    @Override
    public ItemStack getAnyStamp(EnumPostage[] postages, int max) {
        for (EnumPostage postage : postages) {
            int collected = Math.min(max, this.collectedPostage[postage.ordinal()]);
            int n = postage.ordinal();
            this.collectedPostage[n] = this.collectedPostage[n] - collected;
            if (collected <= 0) continue;
            EnumStampDefinition stampDefinition = EnumStampDefinition.getFromPostage(postage);
            return PluginMail.items.stamps.get(stampDefinition, collected);
        }
        return null;
    }

    @Override
    public IPostalState lodgeLetter(World world, ItemStack itemstack, boolean doLodge) {
        IMailAddress address;
        IPostalCarrier carrier;
        ILetter letter = PostManager.postRegistry.getLetter(itemstack);
        if (letter.isProcessed()) {
            return EnumDeliveryState.ALREADY_MAILED;
        }
        if (!letter.isPostPaid()) {
            return EnumDeliveryState.NOT_POSTPAID;
        }
        if (!letter.isMailable()) {
            return EnumDeliveryState.NOT_MAILABLE;
        }
        IPostalState state = EnumDeliveryState.NOT_MAILABLE;
        IMailAddress[] iMailAddressArray = letter.getRecipients();
        int n = iMailAddressArray.length;
        for (int i = 0; i < n && ((carrier = PostManager.postRegistry.getCarrier((address = iMailAddressArray[i]).getType())) == null || (state = carrier.deliverLetter(world, this, address, itemstack, doLodge)).isOk()); ++i) {
        }
        if (!state.isOk()) {
            return state;
        }
        this.collectPostage(letter.getPostage());
        this.markDirty();
        return EnumDeliveryState.OK;
    }

    @Override
    public void collectPostage(ItemStack[] stamps) {
        for (ItemStack stamp : stamps) {
            if (stamp == null || !(stamp.getItem() instanceof IStamps)) continue;
            EnumPostage postage = ((IStamps)stamp.getItem()).getPostage(stamp);
            int n = postage.ordinal();
            this.collectedPostage[n] = this.collectedPostage[n] + stamp.stackSize;
        }
    }
}

