/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import forestry.api.core.INBTTagable;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IStreamable;
import forestry.factory.recipes.MemorizedRecipe;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class RecipeMemory
implements INBTTagable,
IStreamable {
    public static final int capacity = 9;
    private static final List<Class<? extends Item>> memoryBlacklist = new ArrayList<Class<? extends Item>>();
    private LinkedList<MemorizedRecipe> memorizedRecipes = new LinkedList();
    private long lastUpdate;

    private static boolean isValid(MemorizedRecipe recipe) {
        if (recipe == null) {
            return false;
        }
        ItemStack recipeOutput = recipe.getRecipeOutput();
        if (recipeOutput == null) {
            return false;
        }
        Item item = recipeOutput.getItem();
        return item != null && !memoryBlacklist.contains(item.getClass());
    }

    public void validate(World world) {
        LinkedList<MemorizedRecipe> validRecipes = new LinkedList<MemorizedRecipe>();
        for (MemorizedRecipe recipe : this.memorizedRecipes) {
            if (recipe == null) continue;
            recipe.calculateRecipeOutput(world);
            if (!RecipeMemory.isValid(recipe)) continue;
            validRecipes.add(recipe);
        }
        this.memorizedRecipes = validRecipes;
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public void memorizeRecipe(long worldTime, MemorizedRecipe recipe) {
        MemorizedRecipe memory;
        if (!RecipeMemory.isValid(recipe)) {
            return;
        }
        this.lastUpdate = worldTime;
        recipe.updateLastUse(this.lastUpdate);
        if (recipe.hasRecipeConflict()) {
            recipe.removeRecipeConflicts();
        }
        if ((memory = this.getExistingMemorizedRecipe(recipe.getRecipeOutput())) != null) {
            this.updateExistingRecipe(memory, recipe);
            return;
        }
        if (this.memorizedRecipes.size() < 9) {
            this.memorizedRecipes.add(recipe);
        } else {
            MemorizedRecipe oldest = this.getOldestUnlockedRecipe();
            if (oldest != null) {
                this.memorizedRecipes.remove(oldest);
                this.memorizedRecipes.add(recipe);
            }
        }
    }

    private void updateExistingRecipe(MemorizedRecipe existingRecipe, MemorizedRecipe updatedRecipe) {
        if (existingRecipe.isLocked() != updatedRecipe.isLocked()) {
            updatedRecipe.toggleLock();
        }
        int index = this.memorizedRecipes.indexOf(existingRecipe);
        this.memorizedRecipes.set(index, updatedRecipe);
    }

    private MemorizedRecipe getOldestUnlockedRecipe() {
        MemorizedRecipe oldest = null;
        for (MemorizedRecipe existing : this.memorizedRecipes) {
            if (oldest != null && oldest.getLastUsed() < existing.getLastUsed() || existing.isLocked()) continue;
            oldest = existing;
        }
        return oldest;
    }

    public MemorizedRecipe getRecipe(int recipeIndex) {
        if (recipeIndex < 0 || recipeIndex >= this.memorizedRecipes.size()) {
            return null;
        }
        return this.memorizedRecipes.get(recipeIndex);
    }

    public ItemStack getRecipeDisplayOutput(int recipeIndex) {
        MemorizedRecipe recipe = this.getRecipe(recipeIndex);
        if (recipe == null) {
            return null;
        }
        return recipe.getRecipeOutput();
    }

    public boolean isLocked(int recipeIndex) {
        MemorizedRecipe recipe = this.getRecipe(recipeIndex);
        if (recipe == null) {
            return false;
        }
        return recipe.isLocked();
    }

    public void toggleLock(long worldTime, int recipeIndex) {
        this.lastUpdate = worldTime;
        if (this.memorizedRecipes.size() > recipeIndex) {
            this.memorizedRecipes.get(recipeIndex).toggleLock();
        }
    }

    private MemorizedRecipe getExistingMemorizedRecipe(ItemStack craftingRecipeOutput) {
        for (MemorizedRecipe memorizedRecipe : this.memorizedRecipes) {
            if (!memorizedRecipe.hasRecipeOutput(craftingRecipeOutput)) continue;
            return memorizedRecipe;
        }
        return null;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.memorizedRecipes = new LinkedList();
        if (!nbttagcompound.hasKey("RecipeMemory")) {
            return;
        }
        NBTTagList nbttaglist = nbttagcompound.getTagList("RecipeMemory", 10);
        for (int j = 0; j < nbttaglist.tagCount(); ++j) {
            NBTTagCompound recipeNbt = nbttaglist.getCompoundTagAt(j);
            MemorizedRecipe recipe = new MemorizedRecipe();
            recipe.readFromNBT(recipeNbt);
            this.memorizedRecipes.add(recipe);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        NBTTagList nbttaglist = new NBTTagList();
        for (MemorizedRecipe recipe : this.memorizedRecipes) {
            if (recipe == null) continue;
            NBTTagCompound recipeNbt = new NBTTagCompound();
            recipe.writeToNBT(recipeNbt);
            nbttaglist.appendTag((NBTBase)recipeNbt);
        }
        nbttagcompound.setTag("RecipeMemory", (NBTBase)nbttaglist);
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        data.writeStreamables(this.memorizedRecipes);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        data.readStreamables(this.memorizedRecipes, MemorizedRecipe.class);
    }

    static {
        memoryBlacklist.add(ItemMap.class);
    }
}

