/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import forestry.core.fluids.FluidHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class BottlerRecipe {
    public final FluidStack input;
    public final ItemStack empty;
    public final ItemStack filled;

    private BottlerRecipe(ItemStack empty, FluidStack input, ItemStack filled) {
        this.input = input;
        if (empty.getItem() instanceof IFluidContainerItem) {
            FluidStack emptyFluid = FluidHelper.getFluidStackInContainer(empty);
            if (emptyFluid != null) {
                this.input.amount -= emptyFluid.amount;
            }
            if (this.input.amount > 1000) {
                this.input.amount = 1000;
            }
        }
        this.empty = empty;
        this.filled = filled;
    }

    public boolean matches(ItemStack emptyCan, FluidStack resource) {
        if (emptyCan == null || resource == null || !emptyCan.isItemEqual(this.empty)) {
            return false;
        }
        if (this.empty.getItem() instanceof IFluidContainerItem) {
            return true;
        }
        return resource.containsFluid(this.input);
    }

    public static BottlerRecipe getRecipe(FluidStack res, ItemStack empty) {
        if (res == null || empty == null) {
            return null;
        }
        ItemStack filled = FluidHelper.getFilledContainer(res.getFluid(), empty);
        if (filled == null) {
            return null;
        }
        FluidStack input = FluidHelper.getFluidStackInContainer(filled);
        if (input == null) {
            return null;
        }
        return new BottlerRecipe(empty, input, filled);
    }
}

