/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.core.gui.GuiForestry;
import forestry.core.gui.tooltips.IToolTipProvider;
import forestry.core.gui.tooltips.ToolTip;
import forestry.core.gui.tooltips.ToolTipLine;
import java.awt.Color;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.opengl.GL11;

public class GuiUtil {
    public static void drawItemStack(GuiForestry gui, ItemStack stack, int xPos, int yPos) {
        GL11.glPushAttrib((int)8192);
        RenderHelper.enableGUIStandardItemLighting();
        RenderItem itemRender = GuiForestry.getItemRenderer();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
        gui.setZLevel(100.0f);
        itemRender.zLevel = 100.0f;
        FontRenderer font = null;
        if (stack != null) {
            font = stack.getItem().getFontRenderer(stack);
        }
        if (font == null) {
            font = gui.getFontRenderer();
        }
        itemRender.renderItemAndEffectIntoGUI(font, gui.mc.getTextureManager(), stack, xPos, yPos);
        itemRender.renderItemOverlayIntoGUI(font, gui.mc.getTextureManager(), stack, xPos, yPos);
        gui.setZLevel(0.0f);
        itemRender.zLevel = 0.0f;
        RenderHelper.disableStandardItemLighting();
        GL11.glPopAttrib();
    }

    public static void drawToolTips(GuiForestry gui, ToolTip toolTips, int mouseX, int mouseY) {
        int y;
        if (toolTips == null) {
            return;
        }
        if (toolTips.isEmpty()) {
            return;
        }
        RenderItem itemRender = GuiForestry.getItemRenderer();
        FontRenderer fontRendererObj = gui.getFontRenderer();
        int left = gui.getGuiLeft();
        int top = gui.getGuiTop();
        int length = 0;
        int height = 0;
        Iterator iterator = toolTips.iterator();
        while (iterator.hasNext()) {
            ToolTipLine tip = (ToolTipLine)iterator.next();
            y = fontRendererObj.getStringWidth(tip.toString());
            height += 10 + tip.getSpacing();
            if (y <= length) continue;
            length = y;
        }
        int x = mouseX - left + 12;
        y = mouseY - top - 12;
        gui.setZLevel(300.0f);
        itemRender.zLevel = 300.0f;
        Color backgroundColor = new Color(16, 0, 16, 240);
        int backgroundColorInt = backgroundColor.getRGB();
        gui.drawGradientRect(x - 3, y - 4, x + length + 2, y - 3, backgroundColorInt, backgroundColorInt);
        gui.drawGradientRect(x - 3, y + height + 1, x + length + 2, y + height + 2, backgroundColorInt, backgroundColorInt);
        gui.drawGradientRect(x - 3, y - 3, x + length + 2, y + height + 1, backgroundColorInt, backgroundColorInt);
        gui.drawGradientRect(x - 4, y - 3, x - 3, y + height + 1, backgroundColorInt, backgroundColorInt);
        gui.drawGradientRect(x + length + 2, y - 3, x + length + 3, y + height + 1, backgroundColorInt, backgroundColorInt);
        Color borderColorTop = new Color(80, 0, 255, 80);
        int borderColorTopInt = borderColorTop.getRGB();
        Color borderColorBottom = new Color((borderColorTopInt & 0xFEFEFE) >> 1 | borderColorTopInt & 0xFF000000, true);
        int borderColorBottomInt = borderColorBottom.getRGB();
        gui.drawGradientRect(x - 3, y - 3 + 1, x - 3 + 1, y + height, borderColorTopInt, borderColorBottomInt);
        gui.drawGradientRect(x + length + 1, y - 3 + 1, x + length + 2, y + height, borderColorTopInt, borderColorBottomInt);
        gui.drawGradientRect(x - 3, y - 3, x + length + 2, y - 3 + 1, borderColorTopInt, borderColorTopInt);
        gui.drawGradientRect(x - 3, y + height, x + length + 2, y + height + 1, borderColorBottomInt, borderColorBottomInt);
        boolean firstLine = true;
        Iterator iterator2 = toolTips.iterator();
        while (iterator2.hasNext()) {
            ToolTipLine tip = (ToolTipLine)iterator2.next();
            String line = firstLine ? tip.toString() : EnumChatFormatting.GRAY + tip.toString();
            fontRendererObj.drawStringWithShadow(line, x, y, -1);
            y += 10 + tip.getSpacing();
            firstLine = false;
        }
        gui.setZLevel(0.0f);
        itemRender.zLevel = 0.0f;
    }

    public static void drawToolTips(GuiForestry gui, Collection<?> objects, int mouseX, int mouseY) {
        for (Object obj : objects) {
            ToolTip tips;
            IToolTipProvider provider;
            if (!(obj instanceof IToolTipProvider) || !(provider = (IToolTipProvider)obj).isToolTipVisible() || (tips = provider.getToolTip(mouseX - gui.getGuiLeft(), mouseY - gui.getGuiTop())) == null) continue;
            boolean mouseOver = provider.isMouseOver(mouseX - gui.getGuiLeft(), mouseY - gui.getGuiTop());
            tips.onTick(mouseOver);
            if (!mouseOver || !tips.isReady()) continue;
            tips.refresh();
            GuiUtil.drawToolTips(gui, tips, mouseX, mouseY);
        }
    }
}

