/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.proxy;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import forestry.apiculture.entities.EntityFXBee;
import forestry.apiculture.render.ParticleRenderer;
import forestry.apiculture.render.RenderCandleBlock;
import forestry.apiculture.render.TextureHabitatLocator;
import forestry.core.config.Config;
import forestry.core.entities.EntityFXHoneydust;
import forestry.core.entities.EntityFXIgnition;
import forestry.core.entities.EntityFXSnow;
import forestry.core.proxy.Proxies;
import forestry.core.proxy.ProxyRender;
import forestry.core.render.ForestryResource;
import forestry.core.render.IBlockRenderer;
import forestry.core.render.RenderBlock;
import forestry.core.render.RenderEscritoire;
import forestry.core.render.RenderMachine;
import forestry.core.render.RenderMill;
import forestry.core.render.RenderNaturalistChest;
import forestry.core.render.SpriteSheet;
import forestry.core.render.TextureManager;
import forestry.core.render.TileRendererIndex;
import forestry.core.tiles.MachineDefinition;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityExplodeFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.particle.EntitySpellParticleFX;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class ProxyRenderClient
extends ProxyRender {
    private int byBlockModelId;
    private int candleRenderId;

    @Override
    public void init() {
        this.byBlockModelId = RenderingRegistry.getNextAvailableRenderId();
        this.candleRenderId = RenderingRegistry.getNextAvailableRenderId();
        RenderBlock renderHandler = new RenderBlock();
        RenderingRegistry.registerBlockHandler((int)this.byBlockModelId, (ISimpleBlockRenderingHandler)renderHandler);
        RenderingRegistry.registerBlockHandler((int)this.candleRenderId, (ISimpleBlockRenderingHandler)new RenderCandleBlock());
    }

    @Override
    public int getCandleRenderId() {
        return this.candleRenderId;
    }

    @Override
    public int getByBlockModelRenderId() {
        return this.byBlockModelId;
    }

    @Override
    public boolean fancyGraphicsEnabled() {
        return Proxies.common.getClientInstance().gameSettings.fancyGraphics;
    }

    @Override
    public boolean hasRendering() {
        return true;
    }

    @Override
    public void registerTESR(MachineDefinition definition) {
        RenderBlock.byBlockRenderer.put(new TileRendererIndex(definition.getBlock(), definition.getMeta()), definition.renderer);
        ClientRegistry.bindTileEntitySpecialRenderer(definition.teClass, (TileEntitySpecialRenderer)((TileEntitySpecialRenderer)definition.renderer));
    }

    @Override
    public IBlockRenderer getRenderDefaultMachine(String gfxBase) {
        if (gfxBase == null) {
            return null;
        }
        return new RenderMachine(gfxBase);
    }

    @Override
    public IBlockRenderer getRenderMill(String gfxBase) {
        return new RenderMill(gfxBase);
    }

    @Override
    public IBlockRenderer getRenderMill(String gfxBase, byte charges) {
        return new RenderMill(gfxBase, charges);
    }

    @Override
    public IBlockRenderer getRenderEscritoire() {
        return new RenderEscritoire();
    }

    @Override
    public IBlockRenderer getRenderChest(String textureName) {
        return new RenderNaturalistChest(textureName);
    }

    @Override
    public void registerVillagerSkin(int villagerId, String texturePath) {
        VillagerRegistry.instance().registerVillagerSkin(villagerId, (ResourceLocation)new ForestryResource(texturePath));
    }

    @Override
    public void setHabitatLocatorTexture(Entity player, ChunkCoordinates coordinates) {
        TextureHabitatLocator.getInstance().setTargetCoordinates(coordinates);
    }

    @Override
    public IResourceManager getSelectedTexturePack() {
        return Proxies.common.getClientInstance().getResourceManager();
    }

    @Override
    public void bindTexture(ResourceLocation location) {
        Proxies.common.getClientInstance().getTextureManager().bindTexture(location);
    }

    @Override
    public void bindTexture(SpriteSheet spriteSheet) {
        this.bindTexture(spriteSheet.getLocation());
    }

    public static boolean shouldSpawnParticle(World world) {
        if (!Config.enableParticleFX) {
            return false;
        }
        Minecraft mc = FMLClientHandler.instance().getClient();
        int particleSetting = mc.gameSettings.particleSetting;
        if (particleSetting == 2) {
            return world.rand.nextInt(10) == 0;
        }
        if (particleSetting == 1) {
            return world.rand.nextInt(3) != 0;
        }
        return true;
    }

    @Override
    public void addBeeHiveFX(String icon, World world, double d1, double d2, double d3, int color) {
        if (!ProxyRenderClient.shouldSpawnParticle(world)) {
            return;
        }
        EntityFXBee fx = new EntityFXBee(world, d1, d2, d3, color);
        fx.setParticleIcon(TextureManager.getInstance().getDefault(icon));
        ParticleRenderer.getInstance().addEffect(fx);
    }

    @Override
    public void addEntitySwarmFX(World world, double d1, double d2, double d3) {
        if (!ProxyRenderClient.shouldSpawnParticle(world)) {
            return;
        }
        Proxies.common.getClientInstance().effectRenderer.addEffect((EntityFX)new EntityFXHoneydust(world, d1, d2, d3, 0.0f, 0.0f, 0.0f));
    }

    @Override
    public void addEntityExplodeFX(World world, double d1, double d2, double d3) {
        if (!ProxyRenderClient.shouldSpawnParticle(world)) {
            return;
        }
        Proxies.common.getClientInstance().effectRenderer.addEffect((EntityFX)new EntityExplodeFX(world, d1, d2, d3, 0.0, 0.0, 0.0));
    }

    @Override
    public void addEntitySnowFX(World world, double d1, double d2, double d3) {
        if (!ProxyRenderClient.shouldSpawnParticle(world)) {
            return;
        }
        Proxies.common.getClientInstance().effectRenderer.addEffect((EntityFX)new EntityFXSnow(world, d1 + world.rand.nextGaussian(), d2, d3 + world.rand.nextGaussian()));
    }

    @Override
    public void addEntityIgnitionFX(World world, double d1, double d2, double d3) {
        if (!ProxyRenderClient.shouldSpawnParticle(world)) {
            return;
        }
        Proxies.common.getClientInstance().effectRenderer.addEffect((EntityFX)new EntityFXIgnition(world, d1, d2, d3));
    }

    @Override
    public void addEntityPotionFX(World world, double d1, double d2, double d3, int color) {
        if (!ProxyRenderClient.shouldSpawnParticle(world)) {
            return;
        }
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        EntitySpellParticleFX entityfx = new EntitySpellParticleFX(world, d1, d2, d3, 0.0, 0.0, 0.0);
        entityfx.setRBGColorF(red, green, blue);
        Proxies.common.getClientInstance().effectRenderer.addEffect((EntityFX)entityfx);
    }
}

