/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.apiculture.blocks.BlockCandle;
import forestry.core.items.ItemBlockForestry;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public class ItemBlockCandle
extends ItemBlockForestry {
    public ItemBlockCandle(Block block) {
        super(block);
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemStack(ItemStack stack, int pass) {
        NBTTagCompound tag;
        int value = 0xFFFFFF;
        if (pass == 1 && stack.hasTagCompound() && (tag = stack.getTagCompound()).hasKey("colour")) {
            value = tag.getInteger("colour");
        }
        return value;
    }

    @Override
    public String getUnlocalizedName(ItemStack itemStack) {
        String value = this.getBlock().getUnlocalizedName();
        if (itemStack.hasTagCompound() && itemStack.getTagCompound().hasKey("colour")) {
            value = value + ".dyed";
        }
        value = BlockCandle.isLit(itemStack) ? value + ".lit" : value + ".stump";
        return value;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamageForRenderPass(int meta, int pass) {
        return this.getBlock().getIcon(meta != 0 ? 8 : 0, pass);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean requiresMultipleRenderPasses() {
        return true;
    }

    public int getRenderPasses(int metadata) {
        return 2;
    }
}

