/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.vect.Vect;
import forestry.farming.logic.CropBlock;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class FarmableGenericSapling
implements IFarmable {
    protected final Block sapling;
    private final int saplingMeta;
    private final ItemStack[] windfall;

    public FarmableGenericSapling(Block sapling, int saplingMeta, ItemStack ... windfall) {
        this.sapling = sapling;
        this.saplingMeta = saplingMeta;
        this.windfall = windfall;
    }

    @Override
    public boolean isSaplingAt(World world, int x, int y, int z) {
        if (world.isAirBlock(x, y, z)) {
            return false;
        }
        if (world.getBlock(x, y, z) == this.sapling) {
            return true;
        }
        if (this.saplingMeta >= 0) {
            return world.getBlockMetadata(x, y, z) == this.saplingMeta;
        }
        return true;
    }

    @Override
    public ICrop getCropAt(World world, int x, int y, int z) {
        Block block = world.getBlock(x, y, z);
        if (!block.isWood((IBlockAccess)world, x, y, z)) {
            return null;
        }
        return new CropBlock(world, block, world.getBlockMetadata(x, y, z), new Vect(x, y, z));
    }

    @Override
    public boolean isGermling(ItemStack itemstack) {
        if (!ItemStackUtil.equals(this.sapling, itemstack)) {
            return false;
        }
        if (this.saplingMeta >= 0) {
            return itemstack.getItemDamage() == this.saplingMeta;
        }
        return true;
    }

    @Override
    public boolean isWindfall(ItemStack itemstack) {
        for (ItemStack drop : this.windfall) {
            if (!drop.isItemEqual(itemstack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean plantSaplingAt(EntityPlayer player, ItemStack germling, World world, int x, int y, int z) {
        return germling.copy().tryPlaceItemIntoWorld(player, world, x, y - 1, z, 1, 0.0f, 0.0f, 0.0f);
    }
}

