/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.gui;

import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleFlowers;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IAlleleTolerance;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.EnumButterflyChromosome;
import forestry.api.lepidopterology.IAlleleButterflySpecies;
import forestry.api.lepidopterology.IButterfly;
import forestry.core.genetics.GenericRatings;
import forestry.core.genetics.alleles.AlleleBoolean;
import forestry.core.gui.ContainerAlyzer;
import forestry.core.gui.GuiAlyzer;
import forestry.core.utils.StringUtil;
import forestry.lepidopterology.genetics.ButterflyGenome;
import forestry.lepidopterology.inventory.ItemInventoryFlutterlyzer;
import forestry.plugins.PluginLepidopterology;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class GuiFlutterlyzer
extends GuiAlyzer {
    public GuiFlutterlyzer(EntityPlayer player, ItemInventoryFlutterlyzer inventory) {
        super(ButterflyManager.butterflyRoot, player, new ContainerAlyzer(inventory, player), inventory, "gui.flutterlyzer");
        ArrayList<ItemStack> butterflyList = new ArrayList<ItemStack>();
        PluginLepidopterology.items.butterflyGE.addCreativeItems(butterflyList, false);
        for (ItemStack butterflyStack : butterflyList) {
            IAlleleButterflySpecies species = ButterflyGenome.getSpecies(butterflyStack);
            if (species == null) continue;
            this.iconStacks.put(species.getUID(), butterflyStack);
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float var1, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(var1, mouseX, mouseY);
        int page = 0;
        IButterfly butterfly = null;
        for (int k = 1; k < 7; ++k) {
            if (k == 5 || this.inventory.getStackInSlot(k) == null || (butterfly = ButterflyManager.butterflyRoot.getMember(this.inventory.getStackInSlot(k))) == null || !butterfly.isAnalyzed()) continue;
            page = k;
            break;
        }
        switch (page) {
            case 1: {
                this.drawAnalyticsPage1(butterfly);
                break;
            }
            case 2: {
                this.drawAnalyticsPage2(butterfly);
                break;
            }
            case 3: {
                this.drawAnalyticsPage3(butterfly);
                break;
            }
            case 4: {
                this.drawAnalyticsPageMutations(butterfly);
                break;
            }
            case 6: {
                this.drawAnalyticsPageClassification(butterfly);
                break;
            }
            default: {
                this.drawAnalyticsOverview();
            }
        }
    }

    private void drawAnalyticsPage1(IButterfly butterfly) {
        this.textLayout.startPage(12, 90, 155);
        this.textLayout.drawLine(StringUtil.localize("gui.active"), 90);
        this.textLayout.drawLine(StringUtil.localize("gui.inactive"), 155);
        this.textLayout.newLine();
        this.textLayout.newLine();
        this.drawSpeciesRow(StringUtil.localize("gui.species"), butterfly, EnumButterflyChromosome.SPECIES, null, null);
        this.textLayout.newLine();
        this.drawRow(StringUtil.localize("gui.size"), butterfly.getGenome().getActiveAllele(EnumButterflyChromosome.SIZE).getName(), butterfly.getGenome().getInactiveAllele(EnumButterflyChromosome.SIZE).getName(), butterfly, EnumButterflyChromosome.SPEED);
        this.textLayout.newLine();
        this.drawRow(StringUtil.localize("gui.lifespan"), butterfly.getGenome().getActiveAllele(EnumButterflyChromosome.LIFESPAN).getName(), butterfly.getGenome().getInactiveAllele(EnumButterflyChromosome.LIFESPAN).getName(), butterfly, EnumButterflyChromosome.LIFESPAN);
        this.textLayout.newLine();
        this.drawRow(StringUtil.localize("gui.speed"), butterfly.getGenome().getActiveAllele(EnumButterflyChromosome.SPEED).getName(), butterfly.getGenome().getInactiveAllele(EnumButterflyChromosome.SPEED).getName(), butterfly, EnumButterflyChromosome.SPEED);
        this.textLayout.newLine();
        this.drawRow(StringUtil.localize("gui.metabolism"), GenericRatings.rateMetabolism(butterfly.getGenome().getMetabolism()), GenericRatings.rateMetabolism(((IAlleleInteger)butterfly.getGenome().getInactiveAllele(EnumButterflyChromosome.METABOLISM)).getValue()), butterfly, EnumButterflyChromosome.METABOLISM);
        this.textLayout.newLine();
        this.textLayout.drawLine(StringUtil.localize("gui.fertility"), 12);
        this.drawFertilityInfo(butterfly.getGenome().getFertility(), 90, this.getColorCoding(butterfly.getGenome().getActiveAllele(EnumButterflyChromosome.FERTILITY).isDominant()), 8);
        this.drawFertilityInfo(((IAlleleInteger)butterfly.getGenome().getInactiveAllele(EnumButterflyChromosome.FERTILITY)).getValue(), 155, this.getColorCoding(butterfly.getGenome().getInactiveAllele(EnumButterflyChromosome.FERTILITY).isDominant()), 8);
        this.textLayout.newLine();
        this.drawRow(StringUtil.localize("gui.flowers"), butterfly.getGenome().getFlowerProvider().getDescription(), ((IAlleleFlowers)butterfly.getGenome().getInactiveAllele(EnumButterflyChromosome.FLOWER_PROVIDER)).getProvider().getDescription(), butterfly, EnumButterflyChromosome.FLOWER_PROVIDER);
        this.textLayout.newLine();
        this.drawRow(StringUtil.localize("gui.effect"), butterfly.getGenome().getEffect().getName(), butterfly.getGenome().getInactiveAllele(EnumButterflyChromosome.EFFECT).getName(), butterfly, EnumButterflyChromosome.EFFECT);
        this.textLayout.newLine();
        this.textLayout.endPage();
    }

    private void drawAnalyticsPage2(IButterfly butterfly) {
        String nocturnal1;
        String diurnal1;
        String nocturnal0;
        String diurnal0;
        this.textLayout.startPage(12, 90, 155);
        this.textLayout.drawLine(StringUtil.localize("gui.active"), 90);
        this.textLayout.drawLine(StringUtil.localize("gui.inactive"), 155);
        this.textLayout.newLine();
        this.textLayout.newLine();
        this.drawRow(StringUtil.localize("gui.climate"), AlleleManager.climateHelper.toDisplay(butterfly.getGenome().getPrimary().getTemperature()), AlleleManager.climateHelper.toDisplay(butterfly.getGenome().getPrimary().getTemperature()), butterfly, EnumButterflyChromosome.SPECIES);
        this.textLayout.newLine();
        IAlleleTolerance tempToleranceActive = (IAlleleTolerance)butterfly.getGenome().getActiveAllele(EnumButterflyChromosome.TEMPERATURE_TOLERANCE);
        IAlleleTolerance tempToleranceInactive = (IAlleleTolerance)butterfly.getGenome().getInactiveAllele(EnumButterflyChromosome.TEMPERATURE_TOLERANCE);
        this.textLayout.drawLine("  " + StringUtil.localize("gui.tolerance"), 12);
        this.drawToleranceInfo(tempToleranceActive, 90);
        this.drawToleranceInfo(tempToleranceInactive, 155);
        this.textLayout.newLine();
        this.drawRow(StringUtil.localize("gui.humidity"), AlleleManager.climateHelper.toDisplay(butterfly.getGenome().getPrimary().getHumidity()), AlleleManager.climateHelper.toDisplay(butterfly.getGenome().getPrimary().getHumidity()), butterfly, EnumButterflyChromosome.SPECIES);
        this.textLayout.newLine();
        IAlleleTolerance humidToleranceActive = (IAlleleTolerance)butterfly.getGenome().getActiveAllele(EnumButterflyChromosome.HUMIDITY_TOLERANCE);
        IAlleleTolerance humidToleranceInactive = (IAlleleTolerance)butterfly.getGenome().getInactiveAllele(EnumButterflyChromosome.HUMIDITY_TOLERANCE);
        this.textLayout.drawLine("  " + StringUtil.localize("gui.tolerance"), 12);
        this.drawToleranceInfo(humidToleranceActive, 90);
        this.drawToleranceInfo(humidToleranceInactive, 155);
        this.textLayout.newLine();
        this.textLayout.newLine();
        String yes = StringUtil.localize("yes");
        String no = StringUtil.localize("no");
        if (butterfly.getGenome().getNocturnal()) {
            nocturnal0 = diurnal0 = yes;
        } else {
            nocturnal0 = butterfly.getGenome().getPrimary().isNocturnal() ? yes : no;
            String string = diurnal0 = !butterfly.getGenome().getPrimary().isNocturnal() ? yes : no;
        }
        if (((AlleleBoolean)butterfly.getGenome().getInactiveAllele(EnumButterflyChromosome.NOCTURNAL)).getValue()) {
            nocturnal1 = diurnal1 = yes;
        } else {
            nocturnal1 = butterfly.getGenome().getSecondary().isNocturnal() ? yes : no;
            diurnal1 = !butterfly.getGenome().getSecondary().isNocturnal() ? yes : no;
        }
        this.textLayout.drawLine(StringUtil.localize("gui.diurnal"), 12);
        this.textLayout.drawLine(diurnal0, 90, this.getColorCoding(false));
        this.textLayout.drawLine(diurnal1, 155, this.getColorCoding(false));
        this.textLayout.newLine();
        this.textLayout.drawLine(StringUtil.localize("gui.nocturnal"), 12);
        this.textLayout.drawLine(nocturnal0, 90, this.getColorCoding(false));
        this.textLayout.drawLine(nocturnal1, 155, this.getColorCoding(false));
        this.textLayout.newLine();
        String primary = StringUtil.readableBoolean(butterfly.getGenome().getTolerantFlyer(), yes, no);
        String secondary = StringUtil.readableBoolean(((AlleleBoolean)butterfly.getGenome().getInactiveAllele(EnumButterflyChromosome.TOLERANT_FLYER)).getValue(), yes, no);
        this.drawRow(StringUtil.localize("gui.flyer"), primary, secondary, butterfly, EnumButterflyChromosome.TOLERANT_FLYER);
        this.textLayout.newLine();
        primary = StringUtil.readableBoolean(butterfly.getGenome().getFireResist(), yes, no);
        secondary = StringUtil.readableBoolean(((AlleleBoolean)butterfly.getGenome().getInactiveAllele(EnumButterflyChromosome.FIRE_RESIST)).getValue(), yes, no);
        this.drawRow(StringUtil.localize("gui.fireresist"), primary, secondary, butterfly, EnumButterflyChromosome.FIRE_RESIST);
        this.textLayout.endPage();
    }

    private void drawAnalyticsPage3(IButterfly butterfly) {
        this.textLayout.startPage(12, 90, 155);
        this.textLayout.drawLine(StringUtil.localize("gui.loot.butterfly") + ":", 12);
        this.textLayout.newLine();
        int x = 12;
        for (ItemStack stack : butterfly.getGenome().getPrimary().getButterflyLoot().keySet()) {
            itemRender.renderItemIntoGUI(this.fontRendererObj, this.mc.renderEngine, stack, this.guiLeft + x, this.guiTop + this.textLayout.getLineY());
            if ((x += 18) <= 148) continue;
            x = 12;
            this.textLayout.newLine();
        }
        this.textLayout.newLine();
        this.textLayout.newLine();
        this.textLayout.drawLine(StringUtil.localize("gui.loot.caterpillar") + ":", 12);
        this.textLayout.newLine();
        x = 12;
        for (ItemStack stack : butterfly.getGenome().getPrimary().getCaterpillarLoot().keySet()) {
            itemRender.renderItemIntoGUI(this.fontRendererObj, this.mc.renderEngine, stack, this.guiLeft + x, this.guiTop + this.textLayout.getLineY());
            if ((x += 18) <= 148) continue;
            x = 12;
            this.textLayout.newLine();
        }
        this.textLayout.endPage();
    }
}

