/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gui;

import com.google.common.collect.LinkedListMultimap;
import forestry.apiculture.gui.ContainerHabitatLocator;
import forestry.apiculture.gui.widgets.HabitatSlot;
import forestry.apiculture.inventory.ItemInventoryHabitatLocator;
import forestry.core.gui.GuiForestry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StatCollector;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import org.lwjgl.opengl.GL11;

public class GuiHabitatLocator
extends GuiForestry<ContainerHabitatLocator, ItemInventoryHabitatLocator> {
    private static final LinkedListMultimap<String, BiomeDictionary.Type> habitats = LinkedListMultimap.create();
    private final List<HabitatSlot> habitatSlots = new ArrayList<HabitatSlot>(habitats.size());
    private int startX;
    private int startY;

    public GuiHabitatLocator(EntityPlayer player, ItemInventoryHabitatLocator item) {
        super("textures/gui/biomefinder.png", new ContainerHabitatLocator(player, item), item);
        this.xSize = 176;
        this.ySize = 184;
        int slot = 0;
        for (String habitatName : habitats.keySet()) {
            int y;
            int x;
            if (slot > 5) {
                x = 18 + (slot - 6) * 20;
                y = 50;
            } else {
                x = 18 + slot * 20;
                y = 32;
            }
            List biomes = habitats.get((Object)habitatName);
            HabitatSlot habitatSlot = new HabitatSlot(this.widgetManager, x, y, habitatName, biomes);
            this.habitatSlots.add(habitatSlot);
            this.widgetManager.add(habitatSlot);
            ++slot;
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float var1, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(var1, mouseX, mouseY);
        String str = StatCollector.translateToLocal((String)"item.for.habitatLocator.name").toUpperCase();
        this.fontRendererObj.drawString(str, this.startX + 8 + this.textLayout.getCenteredOffset(str, 138), this.startY + 16, this.fontColor.get("gui.screen"));
        EnumSet<BiomeDictionary.Type> activeBiomeTypes = EnumSet.noneOf(BiomeDictionary.Type.class);
        for (BiomeGenBase biome : ((ItemInventoryHabitatLocator)this.inventory).getBiomesToSearch()) {
            Collections.addAll(activeBiomeTypes, BiomeDictionary.getTypesForBiome((BiomeGenBase)biome));
        }
        for (HabitatSlot habitatSlot : this.habitatSlots) {
            habitatSlot.setActive(activeBiomeTypes);
        }
        for (HabitatSlot slot : this.habitatSlots) {
            slot.draw(this.startX, this.startY);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void initGui() {
        super.initGui();
        this.startX = (this.width - this.xSize) / 2;
        this.startY = (this.height - this.ySize) / 2;
    }

    static {
        habitats.putAll((Object)"Ocean", Arrays.asList(BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.BEACH));
        habitats.put((Object)"Plains", (Object)BiomeDictionary.Type.PLAINS);
        habitats.put((Object)"Desert", (Object)BiomeDictionary.Type.SANDY);
        habitats.putAll((Object)"Forest", Arrays.asList(BiomeDictionary.Type.FOREST, BiomeDictionary.Type.RIVER));
        habitats.put((Object)"Jungle", (Object)BiomeDictionary.Type.JUNGLE);
        habitats.put((Object)"Taiga", (Object)BiomeDictionary.Type.CONIFEROUS);
        habitats.put((Object)"Hills", (Object)BiomeDictionary.Type.MOUNTAIN);
        habitats.put((Object)"Swamp", (Object)BiomeDictionary.Type.SWAMP);
        habitats.put((Object)"Snow", (Object)BiomeDictionary.Type.SNOWY);
        habitats.put((Object)"Mushroom", (Object)BiomeDictionary.Type.MUSHROOM);
        habitats.put((Object)"Nether", (Object)BiomeDictionary.Type.NETHER);
        habitats.put((Object)"End", (Object)BiomeDictionary.Type.END);
    }
}

