/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.tiles;

import forestry.api.multiblock.IFarmComponent;
import forestry.core.tiles.IPowerHandler;
import forestry.energy.EnergyManager;
import forestry.farming.multiblock.IFarmControllerInternal;
import forestry.farming.multiblock.MultiblockLogicFarm;
import forestry.farming.tiles.TileFarm;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileFarmGearbox
extends TileFarm
implements IPowerHandler,
IFarmComponent.Active {
    private static final int WORK_CYCLES = 4;
    private static final int ENERGY_PER_OPERATION = 200;
    private final EnergyManager energyManager = new EnergyManager(200, 10000);
    private int activationDelay = 0;
    private int previousDelays = 0;
    private int workCounter;

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.energyManager.readFromNBT(nbttagcompound);
        this.activationDelay = nbttagcompound.getInteger("ActivationDelay");
        this.previousDelays = nbttagcompound.getInteger("PrevDelays");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this.energyManager.writeToNBT(nbttagcompound);
        nbttagcompound.setInteger("ActivationDelay", this.activationDelay);
        nbttagcompound.setInteger("PrevDelays", this.previousDelays);
    }

    @Override
    public void updateServer(int tickCount) {
        if (this.energyManager.getTotalEnergyStored() <= 0) {
            return;
        }
        if (this.activationDelay > 0) {
            --this.activationDelay;
            return;
        }
        if (this.workCounter < 4 && this.energyManager.consumeEnergyToDoWork(4, 200)) {
            ++this.workCounter;
        }
        if (this.workCounter >= 4 && tickCount % 5 == 0) {
            IFarmControllerInternal farmController = ((MultiblockLogicFarm)this.getMultiblockLogic()).getController();
            if (farmController.doWork()) {
                this.workCounter = 0;
                this.previousDelays = 0;
            } else {
                this.activationDelay = 10 * this.previousDelays < 120 ? 10 * this.previousDelays : 120;
                ++this.previousDelays;
            }
        }
    }

    @Override
    public void updateClient(int tickCount) {
    }

    @Override
    public EnergyManager getEnergyManager() {
        return this.energyManager;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.energyManager.receiveEnergy(from, maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.energyManager.extractEnergy(from, maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.energyManager.getEnergyStored(from);
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.energyManager.getMaxEnergyStored(from);
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.energyManager.canConnectEnergy(from);
    }
}

