/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.gui;

import forestry.core.config.Config;
import forestry.core.proxy.Proxies;
import forestry.core.render.ForestryResource;
import forestry.mail.POBoxInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiMailboxInfo
extends Gui {
    public static final GuiMailboxInfo instance = new GuiMailboxInfo();
    private static final int WIDTH = 98;
    private static final int HEIGHT = 17;
    private final FontRenderer fontRendererObj;
    private POBoxInfo poInfo;
    private final ResourceLocation textureAlert = new ForestryResource("textures/gui/mailalert.png");

    private GuiMailboxInfo() {
        this.fontRendererObj = Proxies.common.getClientInstance().fontRenderer;
    }

    public void render() {
        if (this.poInfo == null || !Config.mailAlertEnabled || !this.poInfo.hasMail()) {
            return;
        }
        int x = 0;
        int y = 0;
        Minecraft minecraft = Minecraft.getMinecraft();
        ScaledResolution scaledresolution = new ScaledResolution(minecraft, minecraft.displayWidth, minecraft.displayHeight);
        if (Config.mailAlertXPosition == XPosition.RIGHT) {
            x = scaledresolution.getScaledWidth() - 98;
        }
        if (Config.mailAlertYPosition == YPosition.BOTTOM) {
            y = scaledresolution.getScaledHeight() - 17;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Proxies.render.bindTexture(this.textureAlert);
        this.drawTexturedModalRect(x, y, 0, 0, 98, 17);
        this.fontRendererObj.drawString(Integer.toString(this.poInfo.playerLetters), x + 27 + this.getCenteredOffset(Integer.toString(this.poInfo.playerLetters), 22), y + 5, 0xFFFFFF);
        this.fontRendererObj.drawString(Integer.toString(this.poInfo.tradeLetters), x + 75 + this.getCenteredOffset(Integer.toString(this.poInfo.tradeLetters), 22), y + 5, 0xFFFFFF);
    }

    protected int getCenteredOffset(String string, int xWidth) {
        return (xWidth - this.fontRendererObj.getStringWidth(string)) / 2;
    }

    public boolean hasPOBoxInfo() {
        return this.poInfo != null;
    }

    public void setPOBoxInfo(POBoxInfo info) {
        boolean playJingle = false;
        if (info.hasMail()) {
            if (this.poInfo == null) {
                playJingle = true;
            } else if (this.poInfo.playerLetters != info.playerLetters || this.poInfo.tradeLetters != info.tradeLetters) {
                playJingle = true;
            }
        }
        if (playJingle) {
            Proxies.common.getRenderWorld().playSoundAtEntity((Entity)Proxies.common.getClientInstance().thePlayer, "random.levelup", 1.0f, 1.0f);
        }
        this.poInfo = info;
    }

    public static enum YPosition {
        TOP,
        BOTTOM;

    }

    public static enum XPosition {
        LEFT,
        RIGHT;

    }
}

