/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network.packets;

import forestry.core.access.IAccessHandler;
import forestry.core.access.IRestrictedAccess;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.PacketIdClient;
import forestry.core.network.packets.PacketCoordinates;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;

public class PacketAccessUpdate
extends PacketCoordinates
implements IForestryPacketClient {
    private IAccessHandler accessHandler;

    public PacketAccessUpdate() {
    }

    public PacketAccessUpdate(IRestrictedAccess restrictedAccess, TileEntity tile) {
        super(tile);
        this.accessHandler = restrictedAccess.getAccessHandler();
    }

    @Override
    protected void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        this.accessHandler.writeData(data);
    }

    @Override
    public void onPacketData(DataInputStreamForestry data, EntityPlayer player) throws IOException {
        TileEntity tile = this.getTarget(player.worldObj);
        if (tile instanceof IRestrictedAccess) {
            IRestrictedAccess restrictedAccessTile = (IRestrictedAccess)tile;
            restrictedAccessTile.getAccessHandler().readData(data);
        }
    }

    @Override
    public PacketIdClient getPacketId() {
        return PacketIdClient.ACCESS_UPDATE;
    }
}

