/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.eventhandler.Event;
import forestry.api.core.ForestryEvent;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.network.packets.PacketGenomeTrackerSync;
import forestry.core.proxy.Proxies;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;

public abstract class BreedingTracker
extends WorldSavedData
implements IBreedingTracker {
    private static final String SPECIES_COUNT_KEY = "SpeciesCount";
    private static final String MUTATIONS_COUNT_KEY = "MutationsCount";
    private static final String RESEARCHED_COUNT_KEY = "ResearchedCount";
    private static final String SPECIES_KEY = "SD";
    private static final String MUTATIONS_KEY = "MD";
    private static final String RESEARCHED_KEY = "RD";
    private static final String MODE_NAME_KEY = "BMS";
    private static final String MUTATION_FORMAT = "%s-%s=%s";
    private static final Collection<String> emptyStringCollection = Collections.emptyList();
    public static final String TYPE_KEY = "TYPE";
    private final Set<String> discoveredSpecies = new HashSet<String>();
    private final Set<String> discoveredMutations = new HashSet<String>();
    private final Set<String> researchedMutations = new HashSet<String>();
    private String modeName;
    @Nullable
    private GameProfile username;
    @Nullable
    private World world;

    protected BreedingTracker(String s) {
        super(s);
    }

    public void setUsername(@Nullable GameProfile username) {
        this.username = username;
    }

    public void setWorld(@Nullable World world) {
        this.world = world;
    }

    @Override
    public String getModeName() {
        return this.modeName;
    }

    @Override
    public void setModeName(String name) {
        this.modeName = name;
        this.markDirty();
    }

    protected abstract IBreedingTracker getBreedingTracker(EntityPlayer var1);

    protected abstract String speciesRootUID();

    @Override
    public void synchToPlayer(EntityPlayer player) {
        if (player instanceof EntityPlayerMP && !(player instanceof FakePlayer)) {
            IBreedingTracker breedingTracker = this.getBreedingTracker(player);
            String modeName = breedingTracker.getModeName();
            this.setModeName(modeName);
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            this.encodeToNBT(nbttagcompound);
            PacketGenomeTrackerSync packet = new PacketGenomeTrackerSync(nbttagcompound);
            Proxies.net.sendToPlayer(packet, player);
        }
    }

    private void syncToPlayer(Collection<String> discoveredSpecies, Collection<String> discoveredMutations, Collection<String> researchedMutations) {
        EntityPlayer player;
        if (this.world != null && this.username != null && this.username.getName() != null && (player = this.world.getPlayerEntityByName(this.username.getName())) instanceof EntityPlayerMP && !(player instanceof FakePlayer)) {
            IBreedingTracker breedingTracker = this.getBreedingTracker(player);
            String modeName = breedingTracker.getModeName();
            this.setModeName(modeName);
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            this.writeToNBT(nbtTagCompound, discoveredSpecies, discoveredMutations, researchedMutations);
            PacketGenomeTrackerSync packet = new PacketGenomeTrackerSync(nbtTagCompound);
            Proxies.net.sendToPlayer(packet, player);
        }
    }

    @Override
    public void decodeFromNBT(NBTTagCompound nbttagcompound) {
        this.readFromNBT(nbttagcompound);
    }

    @Override
    public void encodeToNBT(NBTTagCompound nbttagcompound) {
        this.writeToNBT(nbttagcompound);
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        if (nbttagcompound.hasKey(MODE_NAME_KEY)) {
            this.modeName = nbttagcompound.getString(MODE_NAME_KEY);
        }
        BreedingTracker.readValuesFromNBT(nbttagcompound, this.discoveredSpecies, SPECIES_COUNT_KEY, SPECIES_KEY);
        BreedingTracker.readValuesFromNBT(nbttagcompound, this.discoveredMutations, MUTATIONS_COUNT_KEY, MUTATIONS_KEY);
        BreedingTracker.readValuesFromNBT(nbttagcompound, this.researchedMutations, RESEARCHED_COUNT_KEY, RESEARCHED_KEY);
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        this.writeToNBT(nbttagcompound, this.discoveredSpecies, this.discoveredMutations, this.researchedMutations);
    }

    private void writeToNBT(NBTTagCompound nbtTagCompound, Collection<String> discoveredSpecies, Collection<String> discoveredMutations, Collection<String> researchedMutations) {
        if (this.modeName != null && !this.modeName.isEmpty()) {
            nbtTagCompound.setString(MODE_NAME_KEY, this.modeName);
        }
        nbtTagCompound.setString(TYPE_KEY, this.speciesRootUID());
        BreedingTracker.writeValuesToNBT(nbtTagCompound, discoveredSpecies, SPECIES_COUNT_KEY, SPECIES_KEY);
        BreedingTracker.writeValuesToNBT(nbtTagCompound, discoveredMutations, MUTATIONS_COUNT_KEY, MUTATIONS_KEY);
        BreedingTracker.writeValuesToNBT(nbtTagCompound, researchedMutations, RESEARCHED_COUNT_KEY, RESEARCHED_KEY);
    }

    private static void readValuesFromNBT(NBTTagCompound nbttagcompound, Set<String> values, String countKey, String key) {
        if (nbttagcompound.hasKey(countKey)) {
            int count = nbttagcompound.getInteger(countKey);
            for (int i = 0; i < count; ++i) {
                String value = nbttagcompound.getString(key + i);
                if (value == null || value.length() <= 0) continue;
                values.add(value);
            }
        }
    }

    private static void writeValuesToNBT(NBTTagCompound nbttagcompound, Collection<String> values, String countKey, String key) {
        int count = values.size();
        nbttagcompound.setInteger(countKey, count);
        Iterator<String> iterator = values.iterator();
        for (int i = 0; i < count; ++i) {
            String value = iterator.next();
            if (value == null || value.length() <= 0) continue;
            nbttagcompound.setString(key + i, value);
        }
    }

    private static String getMutationString(IMutation mutation) {
        String species0 = mutation.getAllele0().getUID();
        String species1 = mutation.getAllele1().getUID();
        String resultSpecies = mutation.getTemplate()[0].getUID();
        return String.format(MUTATION_FORMAT, species0, species1, resultSpecies);
    }

    @Override
    public void registerMutation(IMutation mutation) {
        String mutationString = BreedingTracker.getMutationString(mutation);
        if (!this.discoveredMutations.contains(mutationString)) {
            this.discoveredMutations.add(mutationString);
            this.markDirty();
            ISpeciesRoot speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot(this.speciesRootUID());
            ForestryEvent.MutationDiscovered event = new ForestryEvent.MutationDiscovered(speciesRoot, this.username, mutation, this);
            MinecraftForge.EVENT_BUS.post((Event)event);
            this.syncToPlayer(emptyStringCollection, Collections.singleton(mutationString), emptyStringCollection);
        }
    }

    @Override
    public boolean isDiscovered(IMutation mutation) {
        String mutationString = BreedingTracker.getMutationString(mutation);
        return this.discoveredMutations.contains(mutationString) || this.researchedMutations.contains(mutationString);
    }

    @Override
    public boolean isDiscovered(IAlleleSpecies species) {
        return this.discoveredSpecies.contains(species.getUID());
    }

    @Override
    public int getSpeciesBred() {
        return this.discoveredSpecies.size();
    }

    @Override
    public void registerBirth(IIndividual individual) {
        this.registerSpecies(individual.getGenome().getPrimary());
        this.registerSpecies(individual.getGenome().getSecondary());
    }

    @Override
    public void registerSpecies(IAlleleSpecies species) {
        if (!this.discoveredSpecies.contains(species.getUID())) {
            this.discoveredSpecies.add(species.getUID());
            ISpeciesRoot speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot(this.speciesRootUID());
            ForestryEvent.SpeciesDiscovered event = new ForestryEvent.SpeciesDiscovered(speciesRoot, this.username, species, this);
            MinecraftForge.EVENT_BUS.post((Event)event);
            this.syncToPlayer(Collections.singleton(species.getUID()), emptyStringCollection, emptyStringCollection);
        }
    }

    @Override
    public void researchMutation(IMutation mutation) {
        String mutationString = BreedingTracker.getMutationString(mutation);
        if (!this.researchedMutations.contains(mutationString)) {
            this.researchedMutations.add(mutationString);
            this.markDirty();
            this.registerMutation(mutation);
            this.syncToPlayer(emptyStringCollection, emptyStringCollection, Collections.singleton(mutationString));
        }
    }

    @Override
    public boolean isResearched(IMutation mutation) {
        String mutationString = BreedingTracker.getMutationString(mutation);
        return this.researchedMutations.contains(mutationString);
    }
}

