/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.multiblock;

import forestry.api.multiblock.IMultiblockComponent;
import forestry.core.multiblock.IMultiblockSizeLimits;
import forestry.core.multiblock.MultiblockControllerForestry;
import forestry.core.multiblock.MultiblockValidationException;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public abstract class RectangularMultiblockControllerBase
extends MultiblockControllerForestry {
    private final IMultiblockSizeLimits sizeLimits;

    protected RectangularMultiblockControllerBase(World world, IMultiblockSizeLimits sizeLimits) {
        super(world);
        this.sizeLimits = sizeLimits;
    }

    @Override
    protected void isMachineWhole() throws MultiblockValidationException {
        int minX = this.sizeLimits.getMinimumXSize();
        int minY = this.sizeLimits.getMinimumYSize();
        int minZ = this.sizeLimits.getMinimumZSize();
        if (this.connectedParts.size() < this.sizeLimits.getMinimumNumberOfBlocksForAssembledMachine()) {
            throw new MultiblockValidationException(StatCollector.translateToLocalFormatted((String)"for.multiblock.error.small", (Object[])new Object[]{minX, minY, minZ}));
        }
        ChunkCoordinates maximumCoord = this.getMaximumCoord();
        ChunkCoordinates minimumCoord = this.getMinimumCoord();
        int deltaX = maximumCoord.posX - minimumCoord.posX + 1;
        int deltaY = maximumCoord.posY - minimumCoord.posY + 1;
        int deltaZ = maximumCoord.posZ - minimumCoord.posZ + 1;
        int maxX = this.sizeLimits.getMaximumXSize();
        int maxY = this.sizeLimits.getMaximumYSize();
        int maxZ = this.sizeLimits.getMaximumZSize();
        if (maxX > 0 && deltaX > maxX) {
            throw new MultiblockValidationException(StatCollector.translateToLocalFormatted((String)"for.multiblock.error.large.x", (Object[])new Object[]{maxX}));
        }
        if (maxY > 0 && deltaY > maxY) {
            throw new MultiblockValidationException(StatCollector.translateToLocalFormatted((String)"for.multiblock.error.large.y", (Object[])new Object[]{maxY}));
        }
        if (maxZ > 0 && deltaZ > maxZ) {
            throw new MultiblockValidationException(StatCollector.translateToLocalFormatted((String)"for.multiblock.error.large.z", (Object[])new Object[]{maxZ}));
        }
        if (deltaX < minX) {
            throw new MultiblockValidationException(StatCollector.translateToLocalFormatted((String)"for.multiblock.error.small.x", (Object[])new Object[]{minX}));
        }
        if (deltaY < minY) {
            throw new MultiblockValidationException(StatCollector.translateToLocalFormatted((String)"for.multiblock.error.small.y", (Object[])new Object[]{minY}));
        }
        if (deltaZ < minZ) {
            throw new MultiblockValidationException(StatCollector.translateToLocalFormatted((String)"for.multiblock.error.small.z", (Object[])new Object[]{minZ}));
        }
        Class<?> myClass = this.getClass();
        for (int x = minimumCoord.posX; x <= maximumCoord.posX; ++x) {
            for (int y = minimumCoord.posY; y <= maximumCoord.posY; ++y) {
                for (int z = minimumCoord.posZ; z <= maximumCoord.posZ; ++z) {
                    IMultiblockComponent part;
                    TileEntity te = this.worldObj.getTileEntity(x, y, z);
                    if (te instanceof IMultiblockComponent) {
                        part = (IMultiblockComponent)te;
                        if (!myClass.equals(part.getMultiblockLogic().getController().getClass())) {
                            throw new MultiblockValidationException(StatCollector.translateToLocalFormatted((String)"for.multiblock.error.invalid.part", (Object[])new Object[]{x, y, z, myClass.getSimpleName()}));
                        }
                    } else {
                        part = null;
                    }
                    int extremes = 0;
                    if (x == minimumCoord.posX) {
                        ++extremes;
                    }
                    if (y == minimumCoord.posY) {
                        ++extremes;
                    }
                    if (z == minimumCoord.posZ) {
                        ++extremes;
                    }
                    if (x == maximumCoord.posX) {
                        ++extremes;
                    }
                    if (y == maximumCoord.posY) {
                        ++extremes;
                    }
                    if (z == maximumCoord.posZ) {
                        ++extremes;
                    }
                    if (extremes >= 1) {
                        int exteriorLevel = y - minimumCoord.posY;
                        if (part != null) {
                            this.isGoodForExteriorLevel(part, exteriorLevel);
                            continue;
                        }
                        this.isBlockGoodForExteriorLevel(exteriorLevel, this.worldObj, x, y, z);
                        continue;
                    }
                    if (part != null) {
                        this.isGoodForInterior(part);
                        continue;
                    }
                    this.isBlockGoodForInterior(this.worldObj, x, y, z);
                }
            }
        }
    }

    protected abstract void isGoodForExteriorLevel(IMultiblockComponent var1, int var2) throws MultiblockValidationException;

    protected abstract void isGoodForInterior(IMultiblockComponent var1) throws MultiblockValidationException;
}

