/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.FMLCommonHandler;
import forestry.api.mail.EnumAddressee;
import forestry.api.mail.PostManager;
import forestry.api.recipes.RecipeManagers;
import forestry.apiculture.items.ItemRegistryApiculture;
import forestry.core.ISaveEventHandler;
import forestry.core.circuits.EnumCircuitBoardType;
import forestry.core.config.Config;
import forestry.core.fluids.Fluids;
import forestry.core.items.EnumElectronTube;
import forestry.core.network.IPacketRegistry;
import forestry.core.recipes.RecipeUtil;
import forestry.core.tiles.MachineDefinition;
import forestry.mail.PostRegistry;
import forestry.mail.PostalCarrier;
import forestry.mail.SaveEventHandlerMail;
import forestry.mail.TickHandlerMailClient;
import forestry.mail.blocks.BlockMailType;
import forestry.mail.blocks.BlockRegistryMail;
import forestry.mail.commands.CommandMail;
import forestry.mail.items.EnumStampDefinition;
import forestry.mail.items.ItemRegistryMail;
import forestry.mail.network.PacketRegistryMail;
import forestry.mail.triggers.MailTriggers;
import forestry.plugins.ForestryPlugin;
import forestry.plugins.Plugin;
import forestry.plugins.PluginApiculture;
import forestry.plugins.PluginCore;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@Plugin(pluginID="Mail", name="Mail", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.mail.description")
public class PluginMail
extends ForestryPlugin {
    public static ItemRegistryMail items;
    public static BlockRegistryMail blocks;

    @Override
    protected void setupAPI() {
        super.setupAPI();
        PostManager.postRegistry = new PostRegistry();
        PostManager.postRegistry.registerCarrier(new PostalCarrier(EnumAddressee.PLAYER));
        PostManager.postRegistry.registerCarrier(new PostalCarrier(EnumAddressee.TRADER));
    }

    @Override
    protected void registerItemsAndBlocks() {
        items = new ItemRegistryMail();
        blocks = new BlockRegistryMail();
    }

    @Override
    public void preInit() {
        super.preInit();
        PluginCore.rootCommand.addChildCommand(new CommandMail());
        if (Config.mailAlertEnabled) {
            FMLCommonHandler.instance().bus().register((Object)new TickHandlerMailClient());
        }
        PluginMail.blocks.mail.addDefinitions(new MachineDefinition(BlockMailType.MAILBOX).setFaces(0, 1, 2, 2, 2, 2, 0, 7), new MachineDefinition(BlockMailType.TRADESTATION).setFaces(0, 1, 2, 3, 4, 4, 0, 7), new MachineDefinition(BlockMailType.PHILATELIST).setFaces(0, 1, 2, 3, 2, 2, 0, 7));
    }

    @Override
    protected void registerTriggers() {
        MailTriggers.initialize();
    }

    @Override
    public void doInit() {
        super.doInit();
        PluginMail.blocks.mail.init();
    }

    @Override
    public IPacketRegistry getPacketRegistry() {
        return new PacketRegistryMail();
    }

    @Override
    protected void registerRecipes() {
        Item letterGlue;
        Item stampGlue;
        ItemRegistryApiculture beeItems = PluginApiculture.items;
        if (beeItems != null) {
            stampGlue = beeItems.honeyDrop;
            letterGlue = beeItems.propolis.getWildcard();
        } else {
            stampGlue = Items.slime_ball;
            letterGlue = Items.slime_ball;
        }
        RecipeUtil.addShapelessRecipe(PluginMail.items.letters.getItemStack(), Items.paper, letterGlue);
        if (Config.craftingStampsEnabled) {
            for (EnumStampDefinition stampDefinition : EnumStampDefinition.VALUES) {
                if (Config.collectorStamps.contains(stampDefinition.getName())) continue;
                ItemStack stamps = PluginMail.items.stamps.get(stampDefinition, 9);
                RecipeUtil.addRecipe(stamps, "XXX", "###", "ZZZ", Character.valueOf('X'), stampDefinition.getCraftingIngredient(), Character.valueOf('#'), Items.paper, Character.valueOf('Z'), stampGlue);
                RecipeManagers.carpenterManager.addRecipe(10, Fluids.SEEDOIL.getFluid(300), null, stamps, "XXX", "###", Character.valueOf('X'), stampDefinition.getCraftingIngredient(), Character.valueOf('#'), Items.paper);
            }
        }
        RecipeUtil.addRecipe(new ItemStack(Items.paper), "###", Character.valueOf('#'), PluginMail.items.letters.getWildcard());
        RecipeManagers.carpenterManager.addRecipe(10, Fluids.WATER.getFluid(250), null, PluginMail.items.letters.getItemStack(), new Object[]{"###", "###", Character.valueOf('#'), PluginCore.items.woodPulp});
        RecipeUtil.addShapelessRecipe(PluginMail.items.catalogue.getItemStack(), PluginMail.items.stamps.getWildcard(), new ItemStack(Items.book));
        RecipeUtil.addRecipe(PluginMail.blocks.mail.get(BlockMailType.MAILBOX), new Object[]{" # ", "#Y#", "XXX", Character.valueOf('#'), "ingotTin", Character.valueOf('X'), "chestWood", Character.valueOf('Y'), PluginCore.items.sturdyCasing});
        RecipeUtil.addRecipe(PluginMail.blocks.mail.get(BlockMailType.TRADESTATION), new Object[]{"Z#Z", "#Y#", "XWX", Character.valueOf('#'), PluginCore.items.tubes.get(EnumElectronTube.BRONZE, 1), Character.valueOf('X'), "chestWood", Character.valueOf('Y'), PluginCore.items.sturdyCasing, Character.valueOf('Z'), PluginCore.items.tubes.get(EnumElectronTube.IRON, 1), Character.valueOf('W'), PluginCore.items.circuitboards.get(EnumCircuitBoardType.REFINED)});
    }

    @Override
    public ISaveEventHandler getSaveEventHandler() {
        return new SaveEventHandlerMail();
    }
}

