/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.entities;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.IToolScoop;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.EnumFlutterType;
import forestry.api.lepidopterology.IAlleleButterflySpecies;
import forestry.api.lepidopterology.IButterfly;
import forestry.api.lepidopterology.IButterflyGenome;
import forestry.api.lepidopterology.IButterflyRoot;
import forestry.api.lepidopterology.IEntityButterfly;
import forestry.api.lepidopterology.ILepidopteristTracker;
import forestry.core.utils.ItemStackUtil;
import forestry.lepidopterology.entities.AIButterflyFlee;
import forestry.lepidopterology.entities.AIButterflyMate;
import forestry.lepidopterology.entities.AIButterflyPollinate;
import forestry.lepidopterology.entities.AIButterflyRest;
import forestry.lepidopterology.entities.AIButterflyRise;
import forestry.lepidopterology.entities.AIButterflyWander;
import forestry.lepidopterology.entities.EnumButterflyState;
import forestry.lepidopterology.genetics.Butterfly;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockWall;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.IPlantable;

public class EntityButterfly
extends EntityCreature
implements IEntityButterfly {
    public static final int COOLDOWNS = 1500;
    private static final int DATAWATCHER_ID_SPECIES = 16;
    private static final int DATAWATCHER_ID_SIZE = 17;
    private static final int DATAWATCHER_ID_STATE = 18;
    private static final float DEFAULT_BUTTERFLY_SIZE = 0.75f;
    private static final EnumButterflyState DEFAULT_STATE = EnumButterflyState.FLYING;
    public static final int EXHAUSTION_REST = 1000;
    public static final int EXHAUSTION_CONSUMPTION = 100000;
    public static final int MAX_LIFESPAN = 168000;
    private Vec3 flightTarget;
    private int exhaustion;
    private IButterfly contained;
    private IIndividual pollen;
    public int cooldownPollination = 0;
    public int cooldownEgg = 0;
    private IAlleleButterflySpecies species;
    private float size = 0.75f;
    private EnumButterflyState state = DEFAULT_STATE;
    @SideOnly(value=Side.CLIENT)
    private ResourceLocation textureResource;

    public EntityButterfly(World world) {
        super(world);
        this.setDefaults();
    }

    public EntityButterfly(World world, IButterfly butterfly) {
        super(world);
        this.setDefaults();
        this.setIndividual(butterfly);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(16, (Object)"");
        this.dataWatcher.addObject(17, (Object)75);
        this.dataWatcher.addObject(18, (Object)((byte)DEFAULT_STATE.ordinal()));
    }

    private void setDefaults() {
        this.tasks.addTask(8, (EntityAIBase)new AIButterflyFlee(this));
        this.tasks.addTask(9, (EntityAIBase)new AIButterflyMate(this));
        this.tasks.addTask(10, (EntityAIBase)new AIButterflyPollinate(this));
        this.tasks.addTask(11, (EntityAIBase)new AIButterflyRest(this));
        this.tasks.addTask(12, (EntityAIBase)new AIButterflyRise(this));
        this.tasks.addTask(12, (EntityAIBase)new AIButterflyWander(this));
    }

    @Override
    public EntityCreature getEntity() {
        return this;
    }

    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        super.writeEntityToNBT(nbttagcompound);
        NBTTagCompound bio = new NBTTagCompound();
        this.contained.writeToNBT(bio);
        nbttagcompound.setTag("BTFLY", (NBTBase)bio);
        if (this.pollen != null) {
            NBTTagCompound pln = new NBTTagCompound();
            this.pollen.writeToNBT(pln);
            nbttagcompound.setTag("PLN", (NBTBase)pln);
        }
        nbttagcompound.setByte("STATE", (byte)this.getState().ordinal());
        nbttagcompound.setInteger("EXH", this.exhaustion);
    }

    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        super.readEntityFromNBT(nbttagcompound);
        Butterfly butterfly = null;
        if (nbttagcompound.hasKey("BTFLY")) {
            butterfly = new Butterfly((NBTTagCompound)nbttagcompound.getTag("BTFLY"));
        }
        this.setIndividual(butterfly);
        if (nbttagcompound.hasKey("PLN")) {
            this.pollen = TreeManager.treeRoot.getMember((NBTTagCompound)nbttagcompound.getTag("PLN"));
        }
        EnumButterflyState state = EnumButterflyState.VALUES[nbttagcompound.getByte("STATE")];
        this.setState(state);
        this.exhaustion = nbttagcompound.getInteger("EXH");
    }

    public float getWingFlap(float partialTicktime) {
        return this.getState().getWingFlap(this, this.species.getUID().hashCode(), partialTicktime);
    }

    public void setState(EnumButterflyState state) {
        if (this.state != state) {
            this.state = state;
            if (!this.worldObj.isRemote) {
                this.dataWatcher.updateObject(18, (Object)((byte)state.ordinal()));
            }
        }
    }

    public EnumButterflyState getState() {
        return this.state;
    }

    public float getSize() {
        return this.size;
    }

    public float getSpeed() {
        return this.contained.getGenome().getSpeed();
    }

    public Vec3 getDestination() {
        return this.flightTarget;
    }

    public void setDestination(Vec3 destination) {
        this.flightTarget = destination;
    }

    public float getBlockPathWeight(int x, int y, int z) {
        int depth;
        float weight = 0.0f;
        if (!this.getButterfly().isAcceptedEnvironment(this.worldObj, x, y, z)) {
            weight -= 15.0f;
        }
        if (!this.worldObj.getEntitiesWithinAABB(EntityButterfly.class, AxisAlignedBB.getBoundingBox((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1))).isEmpty()) {
            weight -= 1.0f;
        }
        if ((depth = this.getFluidDepth(x, z)) > 0) {
            weight -= 0.1f * (float)depth;
        } else {
            Block block = this.worldObj.getBlock(x, y, z);
            if (block instanceof BlockFlower) {
                weight += 2.0f;
            } else if (block instanceof IPlantable) {
                weight += 1.5f;
            } else if (block instanceof IGrowable) {
                weight += 1.0f;
            } else if (block.getMaterial() == Material.plants) {
                weight += 1.0f;
            }
            block = this.worldObj.getBlock(x, y - 1, z);
            if (block.isLeaves((IBlockAccess)this.worldObj, x, y - 1, z)) {
                weight += 2.5f;
            } else if (block instanceof BlockFence) {
                weight += 1.0f;
            } else if (block instanceof BlockWall) {
                weight += 1.0f;
            }
        }
        return weight += this.worldObj.getLightBrightness(x, y, z);
    }

    private int getFluidDepth(int x, int z) {
        Chunk chunk = this.worldObj.getChunkFromBlockCoords(x, z);
        int xx = x & 0xF;
        int zz = z & 0xF;
        int depth = 0;
        for (int y = chunk.getTopFilledSegment() + 15; y > 0; --y) {
            Block block = chunk.getBlock(xx, y, zz);
            if (block.getMaterial().isLiquid()) {
                ++depth;
                continue;
            }
            if (!block.isAir((IBlockAccess)this.worldObj, x, y, z)) break;
        }
        return depth;
    }

    @Override
    public IIndividual getPollen() {
        return this.pollen;
    }

    @Override
    public void setPollen(IIndividual pollen) {
        this.pollen = pollen;
    }

    public boolean isRenderable() {
        return this.species != null;
    }

    @Override
    public void changeExhaustion(int change) {
        this.exhaustion = this.exhaustion + change > 0 ? this.exhaustion + change : 0;
    }

    @Override
    public int getExhaustion() {
        return this.exhaustion;
    }

    public boolean canFly() {
        return this.contained.canTakeFlight(this.worldObj, this.posX, this.posY, this.posZ);
    }

    public void setIndividual(IButterfly butterfly) {
        if (butterfly == null) {
            butterfly = ButterflyManager.butterflyRoot.templateAsIndividual(ButterflyManager.butterflyRoot.getDefaultTemplate());
        }
        this.contained = butterfly;
        IButterflyGenome genome = this.contained.getGenome();
        this.isImmuneToFire = genome.getFireResist();
        this.size = genome.getSize();
        this.setSize(this.size, 0.4f);
        this.species = genome.getPrimary();
        if (!this.worldObj.isRemote) {
            this.dataWatcher.updateObject(17, (Object)((int)(this.size * 100.0f)));
            this.dataWatcher.updateObject(16, (Object)this.species.getUID());
        } else {
            this.textureResource = new ResourceLocation(this.species.getEntityTexture());
        }
    }

    @Override
    public IButterfly getButterfly() {
        return this.contained;
    }

    public IEntityLivingData onSpawnWithEgg(IEntityLivingData data) {
        if (!this.worldObj.isRemote) {
            this.setIndividual(this.contained);
        }
        return data;
    }

    public String getCommandSenderName() {
        if (this.species == null) {
            return super.getCommandSenderName();
        }
        return this.species.getName();
    }

    public boolean getCanSpawnHere() {
        return true;
    }

    public int getMaxInPortalTime() {
        return 1000;
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getTexture() {
        return this.textureResource;
    }

    public boolean canBePushed() {
        return false;
    }

    protected void collideWithEntity(Entity other) {
    }

    protected boolean isAIEnabled() {
        return true;
    }

    protected boolean canDespawn() {
        return this.ticksExisted > 168000;
    }

    public boolean interact(EntityPlayer player) {
        if (this.isDead) {
            return false;
        }
        ItemStack heldItem = player.getHeldItem();
        if (heldItem == null) {
            return false;
        }
        if (!(heldItem.getItem() instanceof IToolScoop)) {
            return false;
        }
        if (!this.worldObj.isRemote) {
            IButterflyRoot root = this.contained.getGenome().getPrimary().getRoot();
            ILepidopteristTracker tracker = root.getBreedingTracker(this.worldObj, player.getGameProfile());
            ItemStack itemStack = root.getMemberStack(this.contained.copy(), EnumFlutterType.BUTTERFLY.ordinal());
            tracker.registerCatch(this.contained);
            ItemStackUtil.dropItemStackAsEntity(itemStack, this.worldObj, this.posX, this.posY, this.posZ);
            this.setDead();
        } else {
            player.swingItem();
        }
        return true;
    }

    protected void dropFewItems(boolean playerKill, int lootLevel) {
        for (ItemStack stack : this.contained.getLootDrop(this, playerKill, lootLevel)) {
            ItemStackUtil.dropItemStackAsEntity(stack, this.worldObj, this.posX, this.posY, this.posZ);
        }
        IIndividual pollen = this.getPollen();
        if (pollen != null) {
            ISpeciesRoot root = AlleleManager.alleleRegistry.getSpeciesRoot(pollen.getClass());
            ItemStack pollenStack = root.getMemberStack(pollen, EnumGermlingType.POLLEN.ordinal());
            ItemStackUtil.dropItemStackAsEntity(pollenStack, this.worldObj, this.posX, this.posY, this.posZ);
        }
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.worldObj.isRemote) {
            String speciesUid;
            IAllele allele;
            if (this.species == null && (allele = AlleleManager.alleleRegistry.getAllele(speciesUid = this.dataWatcher.getWatchableObjectString(16))) instanceof IAlleleButterflySpecies) {
                this.species = (IAlleleButterflySpecies)allele;
                this.textureResource = new ResourceLocation(this.species.getEntityTexture());
                this.size = (float)this.dataWatcher.getWatchableObjectInt(17) / 100.0f;
            }
            byte stateOrdinal = this.dataWatcher.getWatchableObjectByte(18);
            if (this.state == null || this.state.ordinal() != stateOrdinal) {
                this.setState(EnumButterflyState.VALUES[stateOrdinal]);
            }
        }
        this.motionY *= (double)0.6f;
        if (this.exhaustion > 100000 && this.getRNG().nextInt(20) == 0) {
            this.attackEntityFrom(DamageSource.generic, 1.0f);
        }
        if (this.ticksExisted > 168000) {
            this.attackEntityFrom(DamageSource.generic, 1.0f);
        }
        if (this.cooldownEgg > 0) {
            --this.cooldownEgg;
        }
        if (this.cooldownPollination > 0) {
            --this.cooldownPollination;
        }
    }

    protected void updateAITasks() {
        super.updateAITasks();
        if (this.getState().doesMovement && this.flightTarget != null) {
            double diffX = this.flightTarget.xCoord + 0.5 - this.posX;
            double diffY = this.flightTarget.yCoord + 0.1 - this.posY;
            double diffZ = this.flightTarget.zCoord + 0.5 - this.posZ;
            this.motionX += (Math.signum(diffX) * 0.5 - this.motionX) * (double)0.1f;
            this.motionY += (Math.signum(diffY) * (double)0.7f - this.motionY) * (double)0.1f;
            this.motionZ += (Math.signum(diffZ) * 0.5 - this.motionZ) * (double)0.1f;
            float horizontal = (float)(Math.atan2(this.motionZ, this.motionX) * 180.0 / Math.PI) - 90.0f;
            this.rotationYaw += MathHelper.wrapAngleTo180_float((float)(horizontal - this.rotationYaw));
            this.setMoveForward(this.contained.getGenome().getSpeed());
        }
    }

    protected boolean canTriggerWalking() {
        return false;
    }

    protected void fall(float par1) {
    }

    protected void updateFallState(double par1, boolean par3) {
    }

    public boolean doesEntityNotTriggerPressurePlate() {
        return true;
    }

    public float getSwingProgress(float partialTicktime) {
        float flap = this.swingProgress - this.prevSwingProgress;
        if (flap < 0.0f) {
            flap += 1.0f;
        }
        return this.prevSwingProgress + flap * partialTicktime;
    }

    protected float getSoundVolume() {
        return 0.1f;
    }

    public ItemStack getPickedResult(MovingObjectPosition target) {
        if (this.species == null) {
            return null;
        }
        IButterflyRoot root = this.species.getRoot();
        IAllele[] template = root.getTemplate(this.species.getUID());
        IButterfly butterfly = root.templateAsIndividual(template);
        return root.getMemberStack(butterfly, EnumFlutterType.BUTTERFLY.ordinal());
    }
}

