/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.network.packets;

import forestry.api.mail.EnumAddressee;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketServer;
import forestry.core.network.PacketIdServer;
import forestry.mail.gui.ContainerLetter;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class PacketLetterInfoRequest
extends ForestryPacket
implements IForestryPacketServer {
    private String recipientName;
    private EnumAddressee addressType;

    public PacketLetterInfoRequest() {
    }

    public PacketLetterInfoRequest(String recipientName, EnumAddressee addressType) {
        this.recipientName = recipientName;
        this.addressType = addressType;
    }

    @Override
    protected void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        data.writeUTF(this.recipientName);
        data.writeByte(this.addressType.ordinal());
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.recipientName = data.readUTF();
        this.addressType = EnumAddressee.values()[data.readByte()];
    }

    @Override
    public void onPacketData(DataInputStreamForestry data, EntityPlayerMP player) throws IOException {
        if (!(player.openContainer instanceof ContainerLetter)) {
            return;
        }
        ((ContainerLetter)player.openContainer).handleRequestLetterInfo((EntityPlayer)player, this.recipientName, this.addressType);
    }

    @Override
    public PacketIdServer getPacketId() {
        return PacketIdServer.LETTER_INFO_REQUEST;
    }
}

