/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.tiles;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.DefaultBeeListener;
import forestry.api.apiculture.IBeeHousingInventory;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.apiculture.BeehouseBeeModifier;
import forestry.apiculture.InventoryBeeHousing;
import forestry.apiculture.gui.ContainerBeeHousing;
import forestry.apiculture.gui.GuiBeeHousing;
import forestry.apiculture.tiles.TileBeeHousingBase;
import java.util.Collections;
import net.minecraft.entity.player.EntityPlayer;

public class TileBeehouse
extends TileBeeHousingBase {
    private static final IBeeModifier beeModifier = new BeehouseBeeModifier();
    private final IBeeListener beeListener = new DefaultBeeListener();
    private final InventoryBeeHousing beeInventory = new InventoryBeeHousing(12, this.getAccessHandler());

    public TileBeehouse() {
        super("bee.house");
        this.beeInventory.disableAutomation();
        this.setInternalInventory(this.beeInventory);
    }

    @Override
    public IBeeHousingInventory getBeeInventory() {
        return this.beeInventory;
    }

    @Override
    public Iterable<IBeeModifier> getBeeModifiers() {
        return Collections.singleton(beeModifier);
    }

    @Override
    public Iterable<IBeeListener> getBeeListeners() {
        return Collections.singleton(this.beeListener);
    }

    @Override
    public Object getGui(EntityPlayer player, int data) {
        ContainerBeeHousing container = new ContainerBeeHousing(player.inventory, this, false);
        return new GuiBeeHousing<ContainerBeeHousing>(this, container, GuiBeeHousing.Icon.BEE_HOUSE);
    }

    @Override
    public Object getContainer(EntityPlayer player, int data) {
        BeeManager.beeRoot.syncBreedingTrackerToPlayer(player);
        return new ContainerBeeHousing(player.inventory, this, false);
    }
}

