/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiTextField;

public class GuiTextBox
extends GuiTextField {
    private static final int enabledColor = 0xE0E0E0;
    private static final int disabledColor = 0x707070;
    private final FontRenderer fontRendererObj;
    private final int startX;
    private final int startY;
    private final int width;
    private final int height;
    private int lineScroll = 0;
    private int maxLines = 0;

    public GuiTextBox(FontRenderer fontRendererObj, int startX, int startY, int width, int height) {
        super(fontRendererObj, startX, startY, width, height);
        this.fontRendererObj = fontRendererObj;
        this.startX = startX;
        this.startY = startY;
        this.width = width;
        this.height = height;
    }

    private int getLineScrollOffset() {
        return 0;
    }

    public void advanceLine() {
        if (this.lineScroll < this.maxLines - 1) {
            ++this.lineScroll;
        }
    }

    public void regressLine() {
        if (this.lineScroll > 0) {
            --this.lineScroll;
        }
    }

    public boolean moreLinesAllowed() {
        return this.fontRendererObj.listFormattedStringToWidth(this.getCursoredText(), this.width).size() * this.fontRendererObj.FONT_HEIGHT < this.height;
    }

    private String getCursoredText() {
        if (!this.isFocused()) {
            return this.getText();
        }
        int cursorPos = this.getCursorPosition() - this.getLineScrollOffset();
        String text = this.getText();
        if (cursorPos < 0) {
            return text;
        }
        if (cursorPos >= text.length()) {
            return text + "_";
        }
        return text.substring(0, cursorPos) + "_" + text.substring(cursorPos);
    }

    private void drawScrolledSplitString(String text, int startX, int startY, int width, int textColour) {
        List lines = this.fontRendererObj.listFormattedStringToWidth(text, width);
        this.maxLines = lines.size();
        int count = 0;
        int lineY = startY;
        for (String line : lines) {
            if (count < this.lineScroll) {
                ++count;
                continue;
            }
            if (lineY + this.fontRendererObj.FONT_HEIGHT - startY > this.height) break;
            this.fontRendererObj.drawString(line, startX, lineY, textColour);
            lineY += this.fontRendererObj.FONT_HEIGHT;
            ++count;
        }
    }

    public void drawTextBox() {
        if (!this.getVisible()) {
            return;
        }
        if (this.getEnableBackgroundDrawing()) {
            GuiTextBox.drawRect((int)(this.startX - 1), (int)(this.startY - 1), (int)(this.startX + this.width + 1), (int)(this.startY + this.height + 1), (int)-6250336);
            GuiTextBox.drawRect((int)this.startX, (int)this.startY, (int)(this.startX + this.width), (int)(this.startY + this.height), (int)-16777216);
        }
        int textColour = this.isFocused() ? 0xE0E0E0 : 0x707070;
        this.drawScrolledSplitString(this.getCursoredText(), this.startX + 2, this.startY + 2, this.width - 4, textColour);
    }
}

