/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.tiles;

import forestry.api.core.INBTTagable;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IIndividual;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IStreamable;
import forestry.core.utils.ColourUtil;
import forestry.core.utils.StringUtil;
import java.io.IOException;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class EscritoireGameToken
implements INBTTagable,
IStreamable {
    private static final String[] OVERLAY_NONE = new String[0];
    private static final String[] OVERLAY_FAILED = new String[]{"errors/errored"};
    private static final String[] OVERLAY_SELECTED = new String[]{"errors/unknown"};
    private ItemStack tokenStack;
    private State state = State.UNREVEALED;

    public EscritoireGameToken() {
    }

    public EscritoireGameToken(ItemStack tokenStack) {
        this.tokenStack = tokenStack;
    }

    public EscritoireGameToken(NBTTagCompound nbttagcompound) {
        this.readFromNBT(nbttagcompound);
    }

    public ItemStack getTokenStack() {
        return this.tokenStack;
    }

    public boolean isVisible() {
        return this.state != State.UNREVEALED;
    }

    public boolean isProbed() {
        return this.state == State.PROBED;
    }

    public boolean isMatched() {
        return this.state == State.MATCHED;
    }

    public boolean isSelected() {
        return this.state == State.SELECTED;
    }

    public void setFailed() {
        this.state = State.FAILED;
    }

    public void setProbed(boolean probed) {
        this.state = probed ? State.PROBED : State.UNREVEALED;
    }

    public void setSelected() {
        this.state = State.SELECTED;
    }

    public void setMatched() {
        this.state = State.MATCHED;
    }

    public int getTokenColour() {
        if (this.tokenStack == null || !this.isVisible()) {
            return 0xFFFFFF;
        }
        IIndividual individual = AlleleManager.alleleRegistry.getIndividual(this.tokenStack);
        int iconColor = individual.getGenome().getPrimary().getIconColour(0);
        if (this.state == State.MATCHED) {
            return ColourUtil.multiplyRGBComponents(iconColor, 0.7f);
        }
        return iconColor;
    }

    public String getTooltip() {
        return this.tokenStack != null ? this.tokenStack.getDisplayName() : StringUtil.localize("gui.unknown");
    }

    public String[] getOverlayIcons() {
        switch (this.state) {
            case FAILED: {
                return OVERLAY_FAILED;
            }
            case SELECTED: {
                return OVERLAY_SELECTED;
            }
        }
        return OVERLAY_NONE;
    }

    public boolean matches(EscritoireGameToken other) {
        return ItemStack.areItemStacksEqual((ItemStack)this.tokenStack, (ItemStack)other.getTokenStack());
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        if (nbttagcompound.hasKey("state")) {
            int stateOrdinal = nbttagcompound.getInteger("state");
            this.state = State.values()[stateOrdinal];
        }
        if (nbttagcompound.hasKey("tokenStack")) {
            this.tokenStack = ItemStack.loadItemStackFromNBT((NBTTagCompound)nbttagcompound.getCompoundTag("tokenStack"));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.setInteger("state", this.state.ordinal());
        if (this.tokenStack != null) {
            NBTTagCompound stackcompound = new NBTTagCompound();
            this.tokenStack.writeToNBT(stackcompound);
            nbttagcompound.setTag("tokenStack", (NBTBase)stackcompound);
        }
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        data.writeEnum(this.state, State.VALUES);
        data.writeItemStack(this.tokenStack);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        this.state = (State)data.readEnum(State.VALUES);
        this.tokenStack = data.readItemStack();
    }

    private static enum State {
        UNREVEALED,
        PROBED,
        SELECTED,
        MATCHED,
        FAILED;

        public static final State[] VALUES;

        static {
            VALUES = State.values();
        }
    }
}

