/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.entities;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.eventhandler.Event;
import forestry.core.access.AccessHandler;
import forestry.core.access.EnumAccess;
import forestry.core.access.IAccessHandler;
import forestry.core.access.IRestrictedAccess;
import forestry.core.gui.GuiHandler;
import forestry.core.gui.IGuiHandlerEntity;
import forestry.core.gui.IHintSource;
import forestry.core.tiles.ITitled;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.minecart.MinecartInteractEvent;

public abstract class EntityMinecartForestry
extends EntityMinecart
implements ITitled,
IRestrictedAccess,
IHintSource,
IGuiHandlerEntity {
    private final AccessHandler accessHandler = new AccessHandler(this);

    public EntityMinecartForestry(World world) {
        super(world);
        this.setHasDisplayTile(true);
    }

    public EntityMinecartForestry(World world, double posX, double posY, double posZ) {
        super(world, posX, posY, posZ);
        this.setHasDisplayTile(true);
    }

    public final boolean interactFirst(EntityPlayer player) {
        if (MinecraftForge.EVENT_BUS.post((Event)new MinecartInteractEvent((EntityMinecart)this, player))) {
            return true;
        }
        if (!this.worldObj.isRemote) {
            GuiHandler.openGui(player, this);
        }
        return true;
    }

    public void setOwner(GameProfile owner) {
        this.accessHandler.setOwner(owner);
    }

    public int getMinecartType() {
        return -1;
    }

    protected void readEntityFromNBT(NBTTagCompound nbtTagCompound) {
        super.readEntityFromNBT(nbtTagCompound);
        this.accessHandler.readFromNBT(nbtTagCompound);
    }

    protected void writeEntityToNBT(NBTTagCompound nbtTagCompound) {
        super.writeEntityToNBT(nbtTagCompound);
        this.accessHandler.writeToNBT(nbtTagCompound);
    }

    public boolean canBeRidden() {
        return false;
    }

    public abstract Block func_145820_n();

    public abstract int getDisplayTileData();

    public abstract ItemStack getCartItem();

    public void killMinecart(DamageSource damageSource) {
        super.killMinecart(damageSource);
        this.entityDropItem(new ItemStack(this.func_145820_n(), 1, this.getDisplayTileData()), 0.0f);
    }

    public float getBrightness(float p_70013_1_) {
        return 1.0f;
    }

    public String getCommandSenderName() {
        return StatCollector.translateToLocal((String)this.getUnlocalizedTitle());
    }

    @Override
    public String getUnlocalizedTitle() {
        ItemStack cartItem = this.getCartItem();
        return cartItem.getUnlocalizedName() + ".name";
    }

    @Override
    public IAccessHandler getAccessHandler() {
        return this.accessHandler;
    }

    @Override
    public void onSwitchAccess(EnumAccess oldAccess, EnumAccess newAccess) {
    }
}

