/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.tiles;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.IFruitProvider;
import forestry.api.arboriculture.ILeafTickHandler;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.ITreekeepingMode;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IFruitBearer;
import forestry.api.genetics.IFruitFamily;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IPollinatable;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.IButterfly;
import forestry.api.lepidopterology.IButterflyGenome;
import forestry.api.lepidopterology.IButterflyNursery;
import forestry.arboriculture.genetics.Tree;
import forestry.arboriculture.genetics.TreeDefinition;
import forestry.arboriculture.genetics.alleles.AlleleFruit;
import forestry.arboriculture.network.IRipeningPacketReceiver;
import forestry.arboriculture.network.packets.PacketRipeningUpdate;
import forestry.arboriculture.tiles.TileTreeContainer;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.packets.PacketTileStream;
import forestry.core.proxy.Proxies;
import forestry.core.render.TextureManager;
import forestry.core.utils.ColourUtil;
import forestry.core.utils.GeneticsUtil;
import forestry.core.utils.Log;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;

public class TileLeaves
extends TileTreeContainer
implements IPollinatable,
IFruitBearer,
IButterflyNursery,
IRipeningPacketReceiver {
    private int colourLeaves;
    private int colourLeavesPollinated;
    private int colourFruits;
    private short textureIndexFruits = (short)-1;
    private IAlleleTreeSpecies species;
    private boolean isFruitLeaf;
    private boolean isPollinatedState;
    private int ripeningTime;
    private short ripeningPeriod = (short)32766;
    private boolean isDecorative = false;
    private int maturationTime;
    private int damage;
    private IEffectData[] effectData = new IEffectData[2];
    private static final short hasFruitFlag = 1;
    private static final short isPollinatedFlag = 2;
    private IButterfly caterpillar;

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        if (nbttagcompound.hasKey("x")) {
            this.xCoord = nbttagcompound.getInteger("x");
            this.yCoord = nbttagcompound.getInteger("y");
            this.zCoord = nbttagcompound.getInteger("z");
        }
        if (nbttagcompound.hasKey("species")) {
            this.isDecorative = true;
            String speciesUID = nbttagcompound.getString("species");
            IAllele[] treeTemplate = TreeManager.treeRoot.getTemplate(speciesUID);
            ITree containedTree = TreeManager.treeRoot.templateAsIndividual(treeTemplate);
            this.setTree(containedTree);
        } else {
            if (nbttagcompound.hasKey("owner")) {
                this.setOwner(NBTUtil.func_152459_a((NBTTagCompound)nbttagcompound.getCompoundTag("owner")));
            }
            this.ripeningTime = nbttagcompound.getShort("RT");
            this.damage = nbttagcompound.getInteger("ENC");
            if (nbttagcompound.hasKey("CATER")) {
                this.maturationTime = nbttagcompound.getInteger("CATMAT");
                this.caterpillar = ButterflyManager.butterflyRoot.getMember(nbttagcompound.getCompoundTag("CATER"));
            }
            this.isDecorative = nbttagcompound.hasKey("Decorative") ? nbttagcompound.getBoolean("Decorative") : nbttagcompound.getBoolean("DEC");
            if (nbttagcompound.hasKey("ContainedTree")) {
                this.setTree(new Tree(nbttagcompound.getCompoundTag("ContainedTree")));
            }
        }
    }

    public void writeToNBTDecorative(NBTTagCompound nbtTagCompound) {
        String speciesUID = this.getSpeciesUID();
        if (speciesUID != null) {
            nbtTagCompound.setString("species", speciesUID);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        nbtTagCompound.setString("id", "forestry.Leaves");
        nbtTagCompound.setInteger("x", this.xCoord);
        nbtTagCompound.setInteger("y", this.yCoord);
        nbtTagCompound.setInteger("z", this.zCoord);
        if (this.isDecorative) {
            this.writeToNBTDecorative(nbtTagCompound);
        } else {
            GameProfile owner;
            ITree tree = this.getTree();
            if (tree != null) {
                NBTTagCompound subcompound = new NBTTagCompound();
                tree.writeToNBT(subcompound);
                nbtTagCompound.setTag("ContainedTree", (NBTBase)subcompound);
            }
            if ((owner = this.getOwner()) != null) {
                NBTTagCompound nbt = new NBTTagCompound();
                NBTUtil.func_152460_a((NBTTagCompound)nbt, (GameProfile)owner);
                nbtTagCompound.setTag("owner", (NBTBase)nbt);
            }
            nbtTagCompound.setInteger("RT", this.getRipeningTime());
            nbtTagCompound.setInteger("ENC", this.damage);
            if (this.caterpillar != null) {
                nbtTagCompound.setInteger("CATMAT", this.maturationTime);
                NBTTagCompound subcompound = new NBTTagCompound();
                this.caterpillar.writeToNBT(subcompound);
                nbtTagCompound.setTag("CATER", (NBTBase)subcompound);
            }
        }
    }

    @Override
    public void onBlockTick() {
        ITree tree = this.getTree();
        if (this.isDecorative || tree == null) {
            return;
        }
        ITreeGenome genome = tree.getGenome();
        boolean isDestroyed = TileLeaves.isDestroyed(tree, this.damage);
        for (ILeafTickHandler tickHandler : genome.getPrimary().getRoot().getLeafTickHandlers()) {
            if (!tickHandler.onRandomLeafTick(tree, this.worldObj, this.xCoord, this.yCoord, this.zCoord, isDestroyed)) continue;
            return;
        }
        if (isDestroyed) {
            return;
        }
        if (this.damage > 0) {
            --this.damage;
        }
        if (this.hasFruit() && this.getRipeningTime() < this.ripeningPeriod) {
            ITreekeepingMode treekeepingMode = TreeManager.treeRoot.getTreekeepingMode(this.worldObj);
            float sappinessModifier = treekeepingMode.getSappinessModifier(genome, 1.0f);
            float sappiness = genome.getSappiness() * sappinessModifier;
            if (this.worldObj.rand.nextFloat() < sappiness) {
                ++this.ripeningTime;
                this.sendNetworkUpdateRipening();
            }
        }
        if (this.caterpillar != null) {
            this.matureCaterpillar();
        }
        this.effectData = tree.doEffect(this.effectData, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public void setTree(ITree tree) {
        super.setTree(tree);
        ITreeGenome genome = tree.getGenome();
        this.species = genome.getPrimary();
        if (tree.canBearFruit()) {
            IFruitProvider fruitProvider = genome.getFruitProvider();
            this.isFruitLeaf = fruitProvider.markAsFruitLeaf(genome, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
            if (this.isFruitLeaf) {
                this.textureIndexFruits = this.species == TreeDefinition.Oak.getGenome().getPrimary() && fruitProvider == AlleleFruit.fruitApple.getProvider() ? (short)-1 : fruitProvider.getIconIndex(genome, (IBlockAccess)this.worldObj, this.xCoord, this.yCoord, this.zCoord, this.getRipeningTime(), true);
                this.ripeningPeriod = (short)tree.getGenome().getFruitProvider().getRipeningPeriod();
            }
        } else {
            this.isFruitLeaf = false;
            this.textureIndexFruits = (short)-1;
        }
        this.colourLeaves = this.species.getLeafColour(false);
        this.colourLeavesPollinated = this.species.getLeafColour(true);
        if (TileLeaves.isDestroyed(tree, this.damage)) {
            this.colourLeaves = ColourUtil.addRGBComponents(this.colourLeaves, 92, 61, 0);
        } else if (this.caterpillar != null) {
            this.colourLeaves = ColourUtil.multiplyRGBComponents(this.colourLeaves, 1.5f);
        }
        this.markDirty();
    }

    private static boolean isDestroyed(ITree tree, int damage) {
        if (tree == null) {
            return false;
        }
        return damage > tree.getResilience();
    }

    @Override
    public boolean isPollinated() {
        ITree tree = this.getTree();
        return tree != null && !TileLeaves.isDestroyed(tree, this.damage) && tree.getMate() != null;
    }

    public int getFoliageColour(EntityPlayer player) {
        if (this.isPollinatedState && GeneticsUtil.hasNaturalistEye(player)) {
            return this.colourLeavesPollinated;
        }
        return this.colourLeaves;
    }

    public int getFruitColour() {
        if (this.colourFruits == 0 && this.hasFruit()) {
            this.colourFruits = this.determineFruitColour();
        }
        return this.colourFruits;
    }

    private int determineFruitColour() {
        ITree tree = this.getTree();
        ITreeGenome genome = tree.getGenome();
        IFruitProvider fruit = genome.getFruitProvider();
        return fruit.getColour(genome, (IBlockAccess)this.worldObj, this.xCoord, this.yCoord, this.zCoord, this.getRipeningTime());
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(boolean fancy) {
        if (this.species == null) {
            return TreeDefinition.Oak.getIndividual().getGenome().getPrimary().getLeafIcon(false, fancy);
        }
        return this.species.getLeafIcon(this.isPollinatedState, fancy);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getFruitTexture() {
        if (this.textureIndexFruits >= 0) {
            return TextureManager.getInstance().getIcon(this.textureIndexFruits);
        }
        return null;
    }

    public int getRipeningTime() {
        return this.isDecorative ? this.ripeningPeriod : this.ripeningTime;
    }

    public void setDecorative() {
        this.isDecorative = true;
    }

    public boolean isDecorative() {
        return this.isDecorative;
    }

    @Override
    public EnumSet<EnumPlantType> getPlantType() {
        if (this.getTree() == null) {
            return EnumSet.noneOf(EnumPlantType.class);
        }
        return this.getTree().getPlantTypes();
    }

    @Override
    public boolean canMateWith(IIndividual individual) {
        if (this.getTree() == null || this.isDecorative) {
            return false;
        }
        if (this.getTree().getMate() != null) {
            return false;
        }
        if (!(individual instanceof ITree)) {
            return false;
        }
        return !this.getTree().isGeneticEqual(individual);
    }

    @Override
    public void mateWith(IIndividual individual) {
        if (this.getTree() == null || this.isDecorative) {
            return;
        }
        this.getTree().mate((ITree)individual);
        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public IIndividual getPollen() {
        if (this.isDecorative) {
            return null;
        }
        return this.getTree();
    }

    public String getUnlocalizedName() {
        ITree tree = this.getTree();
        if (tree == null) {
            return "for.leaves.corrupted";
        }
        return tree.getGenome().getPrimary().getUnlocalizedName();
    }

    private void sendNetworkUpdate() {
        Proxies.net.sendNetworkPacket(new PacketTileStream(this), this.worldObj);
    }

    private void sendNetworkUpdateRipening() {
        int newColourFruits = this.determineFruitColour();
        if (newColourFruits == this.colourFruits) {
            return;
        }
        this.colourFruits = newColourFruits;
        PacketRipeningUpdate ripeningUpdate = new PacketRipeningUpdate(this);
        Proxies.net.sendNetworkPacket(ripeningUpdate, this.worldObj);
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        int leafState = 0;
        boolean hasFruit = this.hasFruit();
        if (this.isPollinated()) {
            leafState = (byte)(leafState | 2);
        }
        if (hasFruit) {
            leafState = (byte)(leafState | 1);
        }
        data.writeByte(leafState);
        if (hasFruit) {
            String fruitAlleleUID = this.getTree().getGenome().getActiveAllele(EnumTreeChromosome.FRUITS).getUID();
            int colourFruits = this.getFruitColour();
            data.writeUTF(fruitAlleleUID);
            data.writeInt(colourFruits);
        }
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        IAllele fruitAllele;
        String speciesUID = data.readUTF();
        byte leafState = data.readByte();
        this.isFruitLeaf = (leafState & 1) > 0;
        this.isPollinatedState = (leafState & 2) > 0;
        String fruitAlleleUID = null;
        if (this.isFruitLeaf) {
            fruitAlleleUID = data.readUTF();
            this.colourFruits = data.readInt();
        }
        IAllele[] treeTemplate = TreeManager.treeRoot.getTemplate(speciesUID);
        if (fruitAlleleUID != null && (fruitAllele = AlleleManager.alleleRegistry.getAllele(fruitAlleleUID)) != null) {
            treeTemplate[EnumTreeChromosome.FRUITS.ordinal()] = fruitAllele;
        }
        if (treeTemplate != null) {
            ITree tree = TreeManager.treeRoot.templateAsIndividual(treeTemplate);
            if (this.isPollinatedState) {
                tree.mate(tree);
            }
            this.setTree(tree);
            this.worldObj.func_147479_m(this.xCoord, this.yCoord, this.zCoord);
        }
    }

    @Override
    public void fromRipeningPacket(int newColourFruits) {
        if (newColourFruits == this.colourFruits) {
            return;
        }
        this.colourFruits = newColourFruits;
        this.worldObj.func_147479_m(this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public Collection<ItemStack> pickFruit(ItemStack tool) {
        ITree tree = this.getTree();
        if (tree == null || !this.hasFruit() || this.isDecorative) {
            return Collections.emptyList();
        }
        ItemStack[] produceStacks = tree.produceStacks(this.worldObj, this.xCoord, this.yCoord, this.zCoord, this.getRipeningTime());
        this.ripeningTime = 0;
        this.sendNetworkUpdateRipening();
        return Arrays.asList(produceStacks);
    }

    @Override
    public IFruitFamily getFruitFamily() {
        ITree tree = this.getTree();
        if (tree == null) {
            return null;
        }
        return tree.getGenome().getFruitProvider().getFamily();
    }

    @Override
    public float getRipeness() {
        if (this.ripeningPeriod == 0) {
            return 1.0f;
        }
        if (this.getTree() == null) {
            return 0.0f;
        }
        return (float)this.getRipeningTime() / (float)this.ripeningPeriod;
    }

    @Override
    public boolean hasFruit() {
        return this.isFruitLeaf && !TileLeaves.isDestroyed(this.getTree(), this.damage);
    }

    @Override
    public void addRipeness(float add) {
        if (this.getTree() == null || !this.isFruitLeaf || this.getRipeningTime() >= this.ripeningPeriod || this.isDecorative) {
            return;
        }
        this.ripeningTime = (int)((float)this.ripeningTime + (float)this.ripeningPeriod * add);
        this.sendNetworkUpdateRipening();
    }

    public String getSpeciesUID() {
        if (this.species == null) {
            return null;
        }
        return this.species.getUID();
    }

    private void matureCaterpillar() {
        ++this.maturationTime;
        ITree tree = this.getTree();
        boolean wasDestroyed = TileLeaves.isDestroyed(tree, this.damage);
        this.damage += this.caterpillar.getGenome().getMetabolism();
        IButterflyGenome caterpillarGenome = this.caterpillar.getGenome();
        int caterpillarMatureTime = Math.round((float)caterpillarGenome.getLifespan() / (float)(caterpillarGenome.getFertility() * 2));
        if (this.maturationTime >= caterpillarMatureTime && this.caterpillar.canTakeFlight(this.worldObj, this.xCoord, this.yCoord, this.zCoord)) {
            if (this.worldObj.isAirBlock(this.xCoord - 1, this.yCoord, this.zCoord)) {
                TileLeaves.attemptButterflySpawn(this.worldObj, this.caterpillar, this.xCoord - 1, this.yCoord, this.zCoord);
            } else if (this.worldObj.isAirBlock(this.xCoord + 1, this.yCoord, this.zCoord)) {
                TileLeaves.attemptButterflySpawn(this.worldObj, this.caterpillar, this.xCoord + 1, this.yCoord, this.zCoord);
            } else if (this.worldObj.isAirBlock(this.xCoord, this.yCoord, this.zCoord - 1)) {
                TileLeaves.attemptButterflySpawn(this.worldObj, this.caterpillar, this.xCoord, this.yCoord, this.zCoord - 1);
            } else if (this.worldObj.isAirBlock(this.xCoord, this.yCoord, this.zCoord + 1)) {
                TileLeaves.attemptButterflySpawn(this.worldObj, this.caterpillar, this.xCoord, this.yCoord, this.zCoord + 1);
            }
            this.setCaterpillar(null);
        } else if (!wasDestroyed && TileLeaves.isDestroyed(tree, this.damage)) {
            this.sendNetworkUpdate();
        }
    }

    private static void attemptButterflySpawn(World world, IButterfly butterfly, double x, double y, double z) {
        if (ButterflyManager.butterflyRoot.spawnButterflyInWorld(world, butterfly.copy(), x, y + (double)0.1f, z) != null) {
            Log.finest("A caterpillar '%s' hatched at %s/%s/%s.", butterfly.getDisplayName(), x, y, z);
        }
    }

    @Override
    public ChunkCoordinates getCoordinates() {
        return new ChunkCoordinates(this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public IButterfly getCaterpillar() {
        return this.caterpillar;
    }

    @Override
    public IIndividual getNanny() {
        return this.getTree();
    }

    @Override
    public void setCaterpillar(IButterfly butterfly) {
        if (this.isDecorative) {
            return;
        }
        this.maturationTime = 0;
        this.caterpillar = butterfly;
        this.sendNetworkUpdate();
    }

    @Override
    public boolean canNurse(IButterfly butterfly) {
        ITree tree = this.getTree();
        return !this.isDecorative && !TileLeaves.isDestroyed(tree, this.damage) && this.caterpillar == null;
    }
}

