/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.core.utils.Stack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public abstract class ItemStackUtil {
    public static final ItemStack[] EMPTY_STACK_ARRAY = new ItemStack[0];

    public static boolean isIdenticalItem(ItemStack lhs, ItemStack rhs) {
        if (lhs == rhs) {
            return true;
        }
        if (lhs == null || rhs == null) {
            return false;
        }
        if (lhs.getItem() != rhs.getItem()) {
            return false;
        }
        if (lhs.getItemDamage() != Short.MAX_VALUE && lhs.getItemDamage() != rhs.getItemDamage()) {
            return false;
        }
        return ItemStack.areItemStackTagsEqual((ItemStack)lhs, (ItemStack)rhs);
    }

    public static void mergeStacks(ItemStack giver, ItemStack receptor) {
        if (receptor.stackSize >= 64) {
            return;
        }
        if (!receptor.isItemEqual(giver)) {
            return;
        }
        if (giver.stackSize <= receptor.getMaxStackSize() - receptor.stackSize) {
            receptor.stackSize += giver.stackSize;
            giver.stackSize = 0;
            return;
        }
        ItemStack temp = giver.splitStack(receptor.getMaxStackSize() - receptor.stackSize);
        receptor.stackSize += temp.stackSize;
        temp.stackSize = 0;
    }

    public static ItemStack createSplitStack(ItemStack stack, int amount) {
        ItemStack split = new ItemStack(stack.getItem(), amount, stack.getItemDamage());
        if (stack.getTagCompound() != null) {
            NBTTagCompound nbttagcompound = (NBTTagCompound)stack.getTagCompound().copy();
            split.setTagCompound(nbttagcompound);
        }
        return split;
    }

    public static ItemStack[] condenseStacks(ItemStack[] stacks) {
        ArrayList<ItemStack> condensed = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            if (stack == null || stack.stackSize <= 0) continue;
            boolean matched = false;
            for (ItemStack cached : condensed) {
                if (!cached.isItemEqual(stack) || !ItemStack.areItemStackTagsEqual((ItemStack)cached, (ItemStack)stack)) continue;
                cached.stackSize += stack.stackSize;
                matched = true;
            }
            if (matched) continue;
            ItemStack cached = stack.copy();
            condensed.add(cached);
        }
        return condensed.toArray(new ItemStack[condensed.size()]);
    }

    public static boolean containsItemStack(Iterable<ItemStack> list, ItemStack itemStack) {
        for (ItemStack listStack : list) {
            if (!ItemStackUtil.isIdenticalItem(listStack, itemStack)) continue;
            return true;
        }
        return false;
    }

    public static int containsSets(ItemStack[] set, ItemStack[] stock) {
        return ItemStackUtil.containsSets(set, stock, false, false);
    }

    public static int containsSets(ItemStack[] set, ItemStack[] stock, boolean oreDictionary, boolean craftingTools) {
        int totalSets = 0;
        ItemStack[] condensedRequired = ItemStackUtil.condenseStacks(set);
        ItemStack[] condensedOffered = ItemStackUtil.condenseStacks(stock);
        for (ItemStack req : condensedRequired) {
            int reqCount = 0;
            for (ItemStack offer : condensedOffered) {
                if (!ItemStackUtil.isCraftingEquivalent(req, offer, oreDictionary, craftingTools)) continue;
                int stackCount = (int)Math.floor(offer.stackSize / req.stackSize);
                reqCount = Math.max(reqCount, stackCount);
            }
            if (reqCount == 0) {
                return 0;
            }
            if (totalSets == 0) {
                totalSets = reqCount;
                continue;
            }
            if (totalSets <= reqCount) continue;
            totalSets = reqCount;
        }
        return totalSets;
    }

    public static boolean equalSets(ItemStack[] set1, ItemStack[] set2) {
        if (set1 == set2) {
            return true;
        }
        if (set1 == null || set2 == null) {
            return false;
        }
        if (set1.length != set2.length) {
            return false;
        }
        for (int i = 0; i < set1.length; ++i) {
            if (ItemStackUtil.isIdenticalItem(set1[i], set2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isCraftingEquivalent(ItemStack base, ItemStack comparison) {
        if (base == null || comparison == null) {
            return false;
        }
        if (base.getItem() != comparison.getItem()) {
            return false;
        }
        if (base.getItemDamage() != Short.MAX_VALUE && base.getItemDamage() != comparison.getItemDamage()) {
            return false;
        }
        if (base.stackTagCompound == null || base.stackTagCompound.hasNoTags()) {
            return true;
        }
        return ItemStack.areItemStackTagsEqual((ItemStack)base, (ItemStack)comparison);
    }

    public static boolean isCraftingEquivalent(ItemStack base, ItemStack comparison, boolean oreDictionary, boolean craftingTools) {
        if (ItemStackUtil.isCraftingEquivalent(base, comparison)) {
            return true;
        }
        if (base == null || comparison == null) {
            return false;
        }
        if (craftingTools && ItemStackUtil.isCraftingToolEquivalent(base, comparison)) {
            return true;
        }
        if (base.hasTagCompound() && !base.stackTagCompound.hasNoTags() && !ItemStack.areItemStacksEqual((ItemStack)base, (ItemStack)comparison)) {
            return false;
        }
        if (oreDictionary) {
            int[] idsBase = OreDictionary.getOreIDs((ItemStack)base);
            Arrays.sort(idsBase);
            int[] idsComp = OreDictionary.getOreIDs((ItemStack)comparison);
            Arrays.sort(idsComp);
            int iBase = 0;
            int iComp = 0;
            while (iBase < idsBase.length && iComp < idsComp.length) {
                if (idsBase[iBase] < idsComp[iComp]) {
                    ++iBase;
                    continue;
                }
                if (idsBase[iBase] > idsComp[iComp]) {
                    ++iComp;
                    continue;
                }
                return true;
            }
        }
        return false;
    }

    public static boolean isCraftingToolEquivalent(ItemStack base, ItemStack comparison) {
        if (base == null || comparison == null) {
            return false;
        }
        Item baseItem = base.getItem();
        if (baseItem.doesContainerItemLeaveCraftingGrid(base)) {
            return false;
        }
        if (baseItem != comparison.getItem()) {
            return false;
        }
        if (base.stackTagCompound == null || base.stackTagCompound.hasNoTags()) {
            return true;
        }
        if (base.getItemDamage() == Short.MAX_VALUE) {
            return true;
        }
        return base.getItemDamage() == comparison.getItemDamage();
    }

    public static void dropItemStackAsEntity(ItemStack items, World world, double x, double y, double z) {
        ItemStackUtil.dropItemStackAsEntity(items, world, x, y, z, 10);
    }

    public static void dropItemStackAsEntity(ItemStack items, World world, double x, double y, double z, int delayForPickup) {
        if (items.stackSize <= 0 || world.isRemote) {
            return;
        }
        float f1 = 0.7f;
        double d = (double)(world.rand.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        double d1 = (double)(world.rand.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        double d2 = (double)(world.rand.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        EntityItem entityitem = new EntityItem(world, x + d, y + d1, z + d2, items);
        entityitem.delayBeforeCanPickup = delayForPickup;
        world.spawnEntityInWorld((Entity)entityitem);
    }

    public static ItemStack copyWithRandomSize(ItemStack template, int max, Random rand) {
        int size = rand.nextInt(max);
        ItemStack created = template.copy();
        created.stackSize = size <= 0 ? 1 : (size > created.getMaxStackSize() ? created.getMaxStackSize() : size);
        return created;
    }

    public static Block getBlock(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof ItemBlock) {
            return ((ItemBlock)item).field_150939_a;
        }
        return null;
    }

    public static boolean equals(Block block, ItemStack stack) {
        return block == ItemStackUtil.getBlock(stack);
    }

    public static boolean equals(Block block, int meta, ItemStack stack) {
        return block == ItemStackUtil.getBlock(stack) && meta == stack.getItemDamage();
    }

    public static List<ItemStack> parseItemStackStrings(String[] itemStackStrings, int missingMetaValue) {
        List<Stack> stacks = Stack.parseStackStrings(itemStackStrings, missingMetaValue);
        return ItemStackUtil.getItemStacks(stacks);
    }

    public static List<ItemStack> parseItemStackStrings(String itemStackStrings, int missingMetaValue) {
        List<Stack> stacks = Stack.parseStackStrings(itemStackStrings, missingMetaValue);
        return ItemStackUtil.getItemStacks(stacks);
    }

    private static List<ItemStack> getItemStacks(List<Stack> stacks) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>(stacks.size());
        for (Stack stack : stacks) {
            Item item = stack.getItem();
            if (item == null) continue;
            int meta = stack.getMeta();
            ItemStack itemStack = new ItemStack(item, 1, meta);
            itemStacks.add(itemStack);
        }
        return itemStacks;
    }
}

