/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network.packets;

import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.ForestryPacket;
import forestry.core.network.ILocatedPacket;
import java.io.IOException;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public abstract class PacketCoordinates
extends ForestryPacket
implements ILocatedPacket {
    private int posX;
    private int posY;
    private int posZ;

    public PacketCoordinates() {
    }

    protected PacketCoordinates(TileEntity tileEntity) {
        this(tileEntity.xCoord, tileEntity.yCoord, tileEntity.zCoord);
    }

    protected PacketCoordinates(ChunkCoordinates coordinates) {
        this(coordinates.posX, coordinates.posY, coordinates.posZ);
    }

    protected PacketCoordinates(int posX, int posY, int posZ) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
    }

    @Override
    protected void writeData(DataOutputStreamForestry data) throws IOException {
        data.writeVarInt(this.posX);
        data.writeVarInt(this.posY);
        data.writeVarInt(this.posZ);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        this.posX = data.readVarInt();
        this.posY = data.readVarInt();
        this.posZ = data.readVarInt();
    }

    protected final ChunkCoordinates getCoordinates() {
        return new ChunkCoordinates(this.posX, this.posY, this.posZ);
    }

    @Override
    public final int getPosX() {
        return this.posX;
    }

    @Override
    public final int getPosY() {
        return this.posY;
    }

    @Override
    public final int getPosZ() {
        return this.posZ;
    }

    public final TileEntity getTarget(World world) {
        return world.getTileEntity(this.posX, this.posY, this.posZ);
    }
}

