/*
 * Decompiled with CFR 0.152.
 */
package forestry;

import com.google.common.collect.ImmutableList;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.core.ForestryAPI;
import forestry.core.EventHandlerCore;
import forestry.core.config.Config;
import forestry.core.config.Constants;
import forestry.core.config.GameMode;
import forestry.core.errors.EnumErrorCode;
import forestry.core.errors.ErrorStateRegistry;
import forestry.core.gui.GuiHandler;
import forestry.core.multiblock.MultiblockEventHandler;
import forestry.core.network.PacketHandler;
import forestry.core.proxy.Proxies;
import forestry.core.utils.Log;
import forestry.core.utils.StringUtil;
import forestry.core.worldgen.WorldGenerator;
import forestry.plugins.PluginManager;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="Forestry", name="Forestry", version="4.2.0.842-unstable", guiFactory="forestry.core.config.ForestryGuiConfigFactory", dependencies="required-after:Forge@[10.13.4.1448,);after:Buildcraft|Core@[6.1.7,);after:ExtrabiomesXL;after:BiomesOPlenty;after:IC2@[2.0.140,);after:Natura@[2.2.0,);after:HardcoreEnderExpansion;")
public class Forestry {
    @Mod.Instance(value="Forestry")
    public static Forestry instance;
    private File configFolder;
    public static PacketHandler packetHandler;

    public Forestry() {
        ForestryAPI.instance = this;
        ForestryAPI.forestryConstants = new Constants();
        ForestryAPI.errorStateRegistry = new ErrorStateRegistry();
        EnumErrorCode.init();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        packetHandler = new PacketHandler();
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerCore());
        MinecraftForge.EVENT_BUS.register((Object)new MultiblockEventHandler());
        this.configFolder = new File(event.getModConfigurationDirectory(), "forestry");
        Config.load();
        PluginManager.runSetup();
        ForestryAPI.activeMode = new GameMode(Config.gameMode);
        PluginManager.runPreInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        PluginManager.runInit();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        PluginManager.runPostInit();
        WorldGenerator worldGenerator = new WorldGenerator();
        GameRegistry.registerWorldGenerator((IWorldGenerator)worldGenerator, (int)0);
        Proxies.common.registerTickHandlers(worldGenerator);
        PluginManager.processIMCMessages((ImmutableList<FMLInterModComms.IMCMessage>)FMLInterModComms.fetchRuntimeMessages((Object)ForestryAPI.instance));
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        PluginManager.serverStarting(event.getServer());
    }

    public File getConfigFolder() {
        return this.configFolder;
    }

    @Mod.EventHandler
    public void processIMCMessages(FMLInterModComms.IMCEvent event) {
        PluginManager.processIMCMessages((ImmutableList<FMLInterModComms.IMCMessage>)event.getMessages());
    }

    @Mod.EventHandler
    public void missingMapping(FMLMissingMappingsEvent event) {
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.get()) {
            Block block;
            if (mapping.type == GameRegistry.Type.BLOCK) {
                block = GameRegistry.findBlock((String)"Forestry", (String)StringUtil.cleanTags(mapping.name));
                if (block == null) continue;
                mapping.remap(block);
                Log.warning("Remapping block " + mapping.name + " to " + StringUtil.cleanBlockName(block));
                continue;
            }
            block = GameRegistry.findBlock((String)"Forestry", (String)StringUtil.cleanTags(mapping.name));
            if (block == null) continue;
            mapping.remap(Item.getItemFromBlock((Block)block));
            Log.warning("Remapping item " + mapping.name + " to " + StringUtil.cleanBlockName(block));
        }
    }
}

