/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.core.gui.slots.SlotForestry;
import forestry.core.gui.slots.SlotLocked;
import forestry.core.network.IForestryPacketClient;
import forestry.core.proxy.Proxies;
import forestry.core.utils.SlotUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public abstract class ContainerForestry
extends Container {
    protected final void addPlayerInventory(InventoryPlayer playerInventory, int xInv, int yInv) {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.addSlotToContainer(new Slot((IInventory)playerInventory, column + row * 9 + 9, xInv + column * 18, yInv + row * 18));
            }
        }
        for (int column = 0; column < 9; ++column) {
            this.addHotbarSlot(playerInventory, column, xInv + column * 18, yInv + 58);
        }
    }

    protected void addHotbarSlot(InventoryPlayer playerInventory, int slot, int x, int y) {
        this.addSlotToContainer(new Slot((IInventory)playerInventory, slot, x, y));
    }

    public Slot addSlotToContainer(Slot p_75146_1_) {
        return super.addSlotToContainer(p_75146_1_);
    }

    public ItemStack slotClick(int slotIndex, int button, int modifier, EntityPlayer player) {
        SlotForestry slotForestry;
        Slot slot;
        int hotbarSlotIndex;
        Slot hotbarSlot;
        if (!this.canAccess(player)) {
            return null;
        }
        if (modifier == 2 && button >= 0 && button < 9 && (hotbarSlot = this.getSlot(hotbarSlotIndex = 27 + button)) instanceof SlotLocked) {
            return null;
        }
        Slot slot2 = slot = slotIndex < 0 ? null : this.getSlot(slotIndex);
        if (slot instanceof SlotForestry && (slotForestry = (SlotForestry)slot).isPhantom()) {
            return SlotUtil.slotClickPhantom(slotForestry, button, modifier, player);
        }
        return super.slotClick(slotIndex, button, modifier, player);
    }

    public final ItemStack transferStackInSlot(EntityPlayer player, int slotIndex) {
        if (!this.canAccess(player)) {
            return null;
        }
        return SlotUtil.transferStackInSlot(this.inventorySlots, player, slotIndex);
    }

    protected abstract boolean canAccess(EntityPlayer var1);

    protected final void sendPacketToCrafters(IForestryPacketClient packet) {
        for (Object crafter : this.crafters) {
            if (!(crafter instanceof EntityPlayer)) continue;
            Proxies.net.sendToPlayer(packet, (EntityPlayer)crafter);
        }
    }
}

