/*
 * Decompiled with CFR 0.152.
 */
package forestry.food.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.core.render.TextureManager;
import forestry.food.items.ItemBeverage;
import java.awt.Color;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;

public enum EnumBeverage implements ItemBeverage.IBeverageInfo
{
    MEAD_SHORT("meadShort", "glass", new Color(15505945), new Color(0xFFFFFF), 1, 0.2f, true),
    MEAD_CURATIVE("meadCurative", "glass", new Color(12975871), new Color(0xFFFFFF), 1, 0.2f, true);

    public static final EnumBeverage[] VALUES;
    private final String name;
    private final String iconType;
    private final int primaryColor;
    private final int secondaryColor;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconBottle;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconContents;
    private final int heal;
    private final float saturation;
    private final boolean isAlwaysEdible;

    private EnumBeverage(String name, String iconType, Color primaryColor, Color secondaryColor, int heal, float saturation, boolean isAlwaysEdible) {
        this.name = name;
        this.iconType = iconType;
        this.primaryColor = primaryColor.getRGB();
        this.secondaryColor = secondaryColor.getRGB();
        this.heal = heal;
        this.saturation = saturation;
        this.isAlwaysEdible = isAlwaysEdible;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.iconBottle = TextureManager.registerTex(register, "liquids/" + this.iconType + ".bottle");
        this.iconContents = TextureManager.registerTex(register, "liquids/" + this.iconType + ".contents");
    }

    @Override
    public int getHeal() {
        return this.heal;
    }

    @Override
    public float getSaturation() {
        return this.saturation;
    }

    @Override
    public boolean isAlwaysEdible() {
        return this.isAlwaysEdible;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getPrimaryColor() {
        return this.primaryColor;
    }

    @Override
    public int getSecondaryColor() {
        return this.secondaryColor;
    }

    @Override
    public boolean isSecret() {
        return false;
    }

    @Override
    public IIcon getIconBottle() {
        return this.iconBottle;
    }

    @Override
    public IIcon getIconContents() {
        return this.iconContents;
    }

    static {
        VALUES = EnumBeverage.values();
    }
}

