/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage.items;

import forestry.api.core.ForestryAPI;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.storage.EnumBackpackType;
import forestry.api.storage.IBackpackDefinition;
import forestry.core.gui.GuiNaturalistInventory;
import forestry.core.network.GuiId;
import forestry.storage.gui.ContainerNaturalistBackpack;
import forestry.storage.inventory.ItemInventoryBackpackPaged;
import forestry.storage.items.ItemBackpack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemBackpackNaturalist
extends ItemBackpack {
    private final ISpeciesRoot speciesRoot;

    public ItemBackpackNaturalist(ISpeciesRoot speciesRoot, IBackpackDefinition definition, EnumBackpackType type) {
        super(definition, type);
        this.speciesRoot = speciesRoot;
    }

    @Override
    protected void openGui(World world, EntityPlayer entityplayer) {
        entityplayer.openGui(ForestryAPI.instance, GuiId.ItemGui.ordinal(), world, (int)entityplayer.posX, (int)entityplayer.posY, (int)entityplayer.posZ);
    }

    @Override
    public Object getGui(EntityPlayer player, ItemStack heldItem, int page) {
        ItemInventoryBackpackPaged inventory = new ItemInventoryBackpackPaged(player, 125, heldItem);
        ContainerNaturalistBackpack container = new ContainerNaturalistBackpack(player, inventory, page);
        return new GuiNaturalistInventory(this.speciesRoot, player, container, inventory, page, 5);
    }

    @Override
    public Object getContainer(EntityPlayer player, ItemStack heldItem, int page) {
        ItemInventoryBackpackPaged inventory = new ItemInventoryBackpackPaged(player, 125, heldItem);
        return new ContainerNaturalistBackpack(player, inventory, page);
    }
}

