/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.core.items.ItemWithGui;
import forestry.core.utils.StringUtil;
import forestry.mail.Letter;
import forestry.mail.LetterProperties;
import forestry.mail.gui.ContainerLetter;
import forestry.mail.gui.GuiLetter;
import forestry.mail.inventory.ItemInventoryLetter;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemLetter
extends ItemWithGui {
    public ItemLetter() {
        this.setMaxStackSize(64);
    }

    @Override
    public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (!world.isRemote) {
            if (itemstack.stackSize == 1) {
                this.openGui(world, entityplayer);
            } else {
                entityplayer.addChatMessage((IChatComponent)new ChatComponentTranslation("for.chat.mail.wrongstacksize", new Object[0]));
            }
        }
        return itemstack;
    }

    public boolean getShareTag() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        LetterProperties.registerIcons(register);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int damage) {
        return LetterProperties.getIconFromDamage(damage);
    }

    public void addInformation(ItemStack itemstack, EntityPlayer player, List list, boolean flag) {
        NBTTagCompound nbttagcompound = itemstack.getTagCompound();
        if (nbttagcompound == null) {
            list.add('<' + StringUtil.localize("gui.blank") + '>');
            return;
        }
        Letter letter = new Letter(nbttagcompound);
        letter.addTooltip(list);
    }

    public void getSubItems(Item item, CreativeTabs tab, List list) {
        LetterProperties.getSubItems(item, tab, list);
    }

    @Override
    public Object getGui(EntityPlayer player, ItemStack heldItem, int data) {
        return new GuiLetter(player, new ItemInventoryLetter(player, heldItem));
    }

    @Override
    public Object getContainer(EntityPlayer player, ItemStack heldItem, int data) {
        return new ContainerLetter(player, new ItemInventoryLetter(player, heldItem));
    }
}

