/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import cpw.mods.fml.common.network.IGuiHandler;
import forestry.core.network.GuiId;
import forestry.core.network.IGuiHandlerEntity;
import forestry.core.network.IGuiHandlerItem;
import forestry.core.network.IGuiHandlerTile;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class GuiHandler
implements IGuiHandler {
    public static int encodeGuiData(GuiId guiId, int data) {
        return data << 8 | guiId.ordinal();
    }

    public static int decodeGuiID(int guiId) {
        return guiId & 0xFF;
    }

    public static int decodeGuiData(int guiId) {
        return guiId >> 8;
    }

    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        int cleanId = GuiHandler.decodeGuiID(id);
        int data = GuiHandler.decodeGuiData(id);
        if (cleanId >= GuiId.values().length) {
            return null;
        }
        switch (GuiId.values()[cleanId]) {
            case ItemGui: {
                Item item;
                ItemStack heldItem = player.getCurrentEquippedItem();
                if (heldItem == null || !((item = heldItem.getItem()) instanceof IGuiHandlerItem)) break;
                return ((IGuiHandlerItem)item).getGui(player, heldItem, data);
            }
            case TileGui: {
                TileEntity tileEntity = world.getTileEntity(x, y, z);
                if (!(tileEntity instanceof IGuiHandlerTile)) break;
                return ((IGuiHandlerTile)tileEntity).getGui(player, data);
            }
            case EntityGui: {
                Entity entity = world.getEntityByID(x);
                if (!(entity instanceof IGuiHandlerEntity)) break;
                return ((IGuiHandlerEntity)entity).getGui(player, data);
            }
        }
        return null;
    }

    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        int cleanId = GuiHandler.decodeGuiID(id);
        int data = GuiHandler.decodeGuiData(id);
        if (cleanId >= GuiId.values().length) {
            return null;
        }
        switch (GuiId.values()[cleanId]) {
            case ItemGui: {
                Item item;
                ItemStack heldItem = player.getCurrentEquippedItem();
                if (heldItem == null || !((item = heldItem.getItem()) instanceof IGuiHandlerItem)) break;
                return ((IGuiHandlerItem)item).getContainer(player, heldItem, data);
            }
            case TileGui: {
                TileEntity tileEntity = world.getTileEntity(x, y, z);
                if (!(tileEntity instanceof IGuiHandlerTile)) break;
                return ((IGuiHandlerTile)tileEntity).getContainer(player, data);
            }
            case EntityGui: {
                Entity entity = world.getEntityByID(x);
                if (!(entity instanceof IGuiHandlerEntity)) break;
                return ((IGuiHandlerEntity)entity).getContainer(player, data);
            }
        }
        return null;
    }
}

