/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInterModComms;
import forestry.Forestry;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.BackpackManager;
import forestry.api.storage.IBackpackDefinition;
import forestry.api.storage.StorageManager;
import forestry.apiculture.blocks.BlockRegistryApiculture;
import forestry.core.GuiHandlerBase;
import forestry.core.IPickupHandler;
import forestry.core.IResupplyHandler;
import forestry.core.config.LocalizedConfiguration;
import forestry.core.fluids.Fluids;
import forestry.core.items.ItemCrated;
import forestry.core.recipes.RecipeUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.Log;
import forestry.core.utils.StringUtil;
import forestry.lepidopterology.blocks.BlockLepidopterologyType;
import forestry.lepidopterology.blocks.BlockRegistryLepidopterology;
import forestry.plugins.ForestryPlugin;
import forestry.plugins.Plugin;
import forestry.plugins.PluginApiculture;
import forestry.plugins.PluginCore;
import forestry.plugins.PluginLepidopterology;
import forestry.plugins.PluginManager;
import forestry.storage.BackpackDefinition;
import forestry.storage.BackpackInterface;
import forestry.storage.CrateRegistry;
import forestry.storage.GuiHandlerStorage;
import forestry.storage.PickupHandlerStorage;
import forestry.storage.ResupplyHandler;
import forestry.storage.items.ItemRegistryStorage;
import forestry.storage.proxy.ProxyStorage;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBasePressurePlate;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockRedstoneDiode;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.BlockWall;
import net.minecraft.block.BlockWorkbench;
import net.minecraft.block.IGrowable;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDoor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

@Plugin(pluginID="Storage", name="Storage", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.storage.description")
public class PluginStorage
extends ForestryPlugin {
    private static final List<ItemCrated> crates = new ArrayList<ItemCrated>();
    private static final String CONFIG_CATEGORY = "backpacks";
    @SidedProxy(clientSide="forestry.storage.proxy.ProxyStorageClient", serverSide="forestry.storage.proxy.ProxyStorage")
    public static ProxyStorage proxy;
    private final ArrayList<ItemStack> minerItems = new ArrayList();
    private final ArrayList<ItemStack> diggerItems = new ArrayList();
    private final ArrayList<ItemStack> foresterItems = new ArrayList();
    private final ArrayList<ItemStack> hunterItems = new ArrayList();
    private final ArrayList<ItemStack> adventurerItems = new ArrayList();
    private final ArrayList<ItemStack> builderItems = new ArrayList();
    public static ItemRegistryStorage items;

    @Override
    protected void setupAPI() {
        BackpackDefinition definition;
        super.setupAPI();
        StorageManager.crateRegistry = new CrateRegistry();
        BackpackManager.backpackInterface = new BackpackInterface();
        BackpackManager.backpackItems = new ArrayList[6];
        BackpackManager.backpackItems[0] = this.minerItems;
        BackpackManager.backpackItems[1] = this.diggerItems;
        BackpackManager.backpackItems[2] = this.foresterItems;
        BackpackManager.backpackItems[3] = this.hunterItems;
        BackpackManager.backpackItems[4] = this.adventurerItems;
        BackpackManager.backpackItems[5] = this.builderItems;
        if (PluginManager.Module.APICULTURE.isEnabled()) {
            definition = new BackpackDefinition.BackpackDefinitionApiarist(new Color(12882493).getRGB());
            BackpackManager.definitions.put(definition.getKey(), definition);
        }
        if (PluginManager.Module.LEPIDOPTEROLOGY.isEnabled()) {
            definition = new BackpackDefinition.BackpackDefinitionLepidopterist(new Color(10050353).getRGB());
            BackpackManager.definitions.put(definition.getKey(), definition);
        }
        definition = new BackpackDefinition("miner", new Color(3545213).getRGB());
        BackpackManager.definitions.put(definition.getKey(), definition);
        definition = new BackpackDefinition("digger", new Color(3554501).getRGB());
        BackpackManager.definitions.put(definition.getKey(), definition);
        definition = new BackpackDefinition("forester", new Color(3437607).getRGB());
        BackpackManager.definitions.put(definition.getKey(), definition);
        definition = new BackpackDefinition("hunter", new Color(4268565).getRGB());
        BackpackManager.definitions.put(definition.getKey(), definition);
        definition = new BackpackDefinition("adventurer", new Color(8370370).getRGB());
        BackpackManager.definitions.put(definition.getKey(), definition);
        definition = new BackpackDefinition("builder", new Color(0xDD3A3A).getRGB());
        BackpackManager.definitions.put(definition.getKey(), definition);
    }

    @Override
    protected void registerItemsAndBlocks() {
        items = new ItemRegistryStorage();
    }

    @Override
    public void postInit() {
        String newConfig = "backpacks.cfg";
        File configFile = new File(Forestry.instance.getConfigFolder(), "backpacks.cfg");
        if (!configFile.exists()) {
            this.setDefaultsForConfig();
        }
        LocalizedConfiguration config = new LocalizedConfiguration(configFile, "1.0.0");
        PluginStorage.handleBackpackConfig(config, "miner");
        PluginStorage.handleBackpackConfig(config, "digger");
        PluginStorage.handleBackpackConfig(config, "forester");
        PluginStorage.handleBackpackConfig(config, "hunter");
        PluginStorage.handleBackpackConfig(config, "adventurer");
        PluginStorage.handleBackpackConfig(config, "builder");
        config.save();
        BackpackDefinition forester = (BackpackDefinition)BackpackManager.definitions.get("forester");
        forester.addValidBlockClasses(Arrays.asList(IPlantable.class, IGrowable.class, IShearable.class));
        forester.addValidItemClasses(Arrays.asList(IPlantable.class, IGrowable.class));
        BackpackDefinition builder = (BackpackDefinition)BackpackManager.definitions.get("builder");
        builder.addValidBlockClasses(Arrays.asList(BlockStairs.class, BlockFence.class, BlockFenceGate.class, BlockWall.class, BlockBasePressurePlate.class, BlockLever.class, BlockButton.class, BlockTorch.class, BlockRedstoneDiode.class, BlockChest.class, BlockWorkbench.class, BlockFurnace.class, BlockLadder.class, BlockTrapDoor.class, BlockDoor.class, BlockSlab.class));
        builder.addValidItemClass(ItemDoor.class);
    }

    private void setDefaultsForConfig() {
        BackpackDefinition miner = (BackpackDefinition)BackpackManager.definitions.get("miner");
        BackpackDefinition digger = (BackpackDefinition)BackpackManager.definitions.get("digger");
        BackpackDefinition forester = (BackpackDefinition)BackpackManager.definitions.get("forester");
        BackpackDefinition adventurer = (BackpackDefinition)BackpackManager.definitions.get("adventurer");
        BackpackDefinition builder = (BackpackDefinition)BackpackManager.definitions.get("builder");
        BackpackDefinition hunter = (BackpackDefinition)BackpackManager.definitions.get("hunter");
        miner.addValidItems(this.minerItems);
        digger.addValidItems(this.diggerItems);
        forester.addValidItems(this.foresterItems);
        hunter.addValidItems(this.hunterItems);
        adventurer.addValidItems(this.adventurerItems);
        builder.addValidItems(this.builderItems);
        Pattern minerOreDictPattern = Pattern.compile("(ore|dust|gem|ingot|nugget|crushed|cluster|denseore)[A-Z].*");
        Pattern diggerOreDictPattern = Pattern.compile("(stone)[A-Z].*");
        Pattern foresterOreDictPattern = Pattern.compile("(crop|seed|tree)[A-Z].*");
        Pattern builderOreDictPattern = Pattern.compile("(block|paneGlass|slabWood|stainedClay|stainedGlass)[A-Z].*");
        ArrayList<String> minerOreDictNames = new ArrayList<String>();
        ArrayList<String> diggerOreDictNames = new ArrayList<String>(Arrays.asList("cobblestone", "stone", "sand"));
        ArrayList<String> foresterOreDictNames = new ArrayList<String>(Arrays.asList("logWood", "stickWood", "woodStick", "saplingTree"));
        ArrayList<String> builderOreDictNames = new ArrayList<String>(Arrays.asList("stone", "plankWood", "stairWood", "slabWood", "fenceWood", "glass", "blockGlass", "paneGlass"));
        for (String name : OreDictionary.getOreNames()) {
            if (minerOreDictPattern.matcher(name).matches()) {
                minerOreDictNames.add(name);
                continue;
            }
            if (diggerOreDictPattern.matcher(name).matches()) {
                if (name.equals("stoneRod")) continue;
                diggerOreDictNames.add(name);
                continue;
            }
            if (foresterOreDictPattern.matcher(name).matches()) {
                foresterOreDictNames.add(name);
                continue;
            }
            if (!builderOreDictPattern.matcher(name).matches() || name.equals("blockHopper")) continue;
            builderOreDictNames.add(name);
        }
        miner.addValidOreDictNames(minerOreDictNames);
        miner.addValidItems(Arrays.asList(new ItemStack(Blocks.obsidian), new ItemStack(Blocks.coal_ore), new ItemStack(Items.coal), PluginCore.items.bronzePickaxe.getItemStack(), PluginCore.items.kitPickaxe.getItemStack(), PluginCore.items.brokenBronzePickaxe.getItemStack()));
        digger.addValidOreDictNames(diggerOreDictNames);
        digger.addValidItems(Arrays.asList(new ItemStack(Blocks.dirt, 1, Short.MAX_VALUE), new ItemStack(Blocks.gravel), new ItemStack(Items.flint), new ItemStack(Blocks.netherrack), new ItemStack(Blocks.sandstone, 1, 0), new ItemStack(Items.clay_ball), new ItemStack(Blocks.soul_sand), PluginCore.items.bronzeShovel.getItemStack(), PluginCore.items.kitShovel.getItemStack(), PluginCore.items.brokenBronzeShovel.getItemStack()));
        forester.addValidOreDictNames(foresterOreDictNames);
        forester.addValidItems(Arrays.asList(new ItemStack((Block)Blocks.red_mushroom), new ItemStack((Block)Blocks.brown_mushroom), new ItemStack((Block)Blocks.red_flower), new ItemStack((Block)Blocks.yellow_flower), new ItemStack(Blocks.cactus), new ItemStack((Block)Blocks.tallgrass, 1, Short.MAX_VALUE), new ItemStack(Blocks.vine), new ItemStack(Blocks.pumpkin), new ItemStack(Blocks.melon_block), new ItemStack(Items.golden_apple), new ItemStack(Items.nether_wart), new ItemStack(Items.pumpkin_seeds), new ItemStack(Items.melon_seeds)));
        hunter.addValidItems(Arrays.asList(new ItemStack(Items.feather), new ItemStack(Items.gunpowder), new ItemStack(Items.blaze_powder), new ItemStack(Items.blaze_rod), new ItemStack(Items.bone), new ItemStack(Items.string), new ItemStack(Items.rotten_flesh), new ItemStack(Items.ghast_tear), new ItemStack(Items.gold_nugget), new ItemStack(Items.arrow), new ItemStack(Items.porkchop), new ItemStack(Items.cooked_porkchop), new ItemStack(Items.beef), new ItemStack(Items.cooked_beef), new ItemStack(Items.chicken), new ItemStack(Items.cooked_chicken), new ItemStack(Items.leather), new ItemStack(Items.egg), new ItemStack(Items.ender_pearl), new ItemStack(Items.spider_eye), new ItemStack(Items.fermented_spider_eye), new ItemStack(Items.slime_ball), new ItemStack(Items.dye, 1, 0), new ItemStack(Blocks.hay_block), new ItemStack(Blocks.wool, 1, Short.MAX_VALUE), new ItemStack(Items.ender_eye), new ItemStack(Items.magma_cream), new ItemStack(Items.speckled_melon), new ItemStack(Items.fish), new ItemStack(Items.cooked_fished), new ItemStack(Items.lead), new ItemStack((Item)Items.fishing_rod), new ItemStack(Items.name_tag), new ItemStack(Items.saddle), new ItemStack(Items.diamond_horse_armor), new ItemStack(Items.golden_horse_armor), new ItemStack(Items.iron_horse_armor)));
        builder.addValidOreDictNames(builderOreDictNames);
        builder.addValidItems(Arrays.asList(new ItemStack(Blocks.torch), new ItemStack(Blocks.redstone_torch), new ItemStack(Blocks.redstone_lamp), new ItemStack(Blocks.stonebrick, 1, Short.MAX_VALUE), new ItemStack(Blocks.sandstone, 1, 1), new ItemStack(Blocks.sandstone, 1, 2), new ItemStack(Blocks.brick_block), new ItemStack(Blocks.clay), new ItemStack(Blocks.hardened_clay, 1, Short.MAX_VALUE), new ItemStack(Blocks.stained_hardened_clay, 1, Short.MAX_VALUE), new ItemStack(Blocks.packed_ice), new ItemStack(Blocks.nether_brick), new ItemStack(Blocks.crafting_table), new ItemStack(Blocks.furnace), new ItemStack(Blocks.lever), new ItemStack(Blocks.dispenser), new ItemStack(Blocks.dropper), new ItemStack(Blocks.ladder), new ItemStack(Blocks.iron_bars), new ItemStack(Blocks.quartz_block, 1, Short.MAX_VALUE), new ItemStack(Items.sign), new ItemStack(Items.item_frame)));
        BlockRegistryApiculture beeBlocks = PluginApiculture.blocks;
        if (beeBlocks != null) {
            builder.addValidItem(new ItemStack((Block)beeBlocks.candle, 1, Short.MAX_VALUE));
            builder.addValidItem(new ItemStack((Block)beeBlocks.stump, 1, Short.MAX_VALUE));
        }
    }

    private static void handleBackpackConfig(LocalizedConfiguration config, String backpackName) {
        BackpackDefinition backpackDefinition = (BackpackDefinition)BackpackManager.definitions.get(backpackName);
        ArrayList<String> backpackOreDict = new ArrayList<String>();
        ArrayList<String> validItems = new ArrayList<String>(backpackDefinition.getValidItemStacks());
        Collections.sort(validItems);
        String[] defaultValidItems = validItems.toArray(new String[validItems.size()]);
        Property backpackConf = config.get("backpacks." + backpackName, "item.stacks", defaultValidItems);
        backpackConf.comment = StringUtil.localizeAndFormat("config.backpacks.item.stacks.format", backpackName);
        String[] backpackItemList = backpackConf.getStringList();
        List<ItemStack> backpackItems = ItemStackUtil.parseItemStackStrings(backpackItemList, Short.MAX_VALUE);
        ArrayList<Integer> oreIds = new ArrayList<Integer>(backpackDefinition.getValidOreIds());
        String[] defaultOreNames = new String[oreIds.size()];
        for (int i = 0; i < oreIds.size(); ++i) {
            int oreId = (Integer)oreIds.get(i);
            defaultOreNames[i] = OreDictionary.getOreName((int)oreId);
        }
        ArrayList defaultOreNamesList = new ArrayList();
        Collections.addAll(defaultOreNamesList, defaultOreNames);
        Collections.sort(defaultOreNamesList);
        defaultOreNames = defaultOreNamesList.toArray(new String[defaultOreNamesList.size()]);
        Property backpackConf2 = config.get("backpacks." + backpackName, "ore.dict", defaultOreNames);
        backpackConf2.comment = StringUtil.localizeAndFormat("config.backpacks.ore.dict.format", backpackName);
        String[] oreDictNameList = backpackConf2.getStringList();
        Collections.addAll(backpackOreDict, oreDictNameList);
        backpackDefinition.clearAllValid();
        backpackDefinition.addValidItems(backpackItems);
        backpackDefinition.addValidOreDictNames(backpackOreDict);
    }

    public static void registerCrate(ItemCrated crate) {
        proxy.registerCrateForRendering(crate);
        crates.add(crate);
    }

    public static void createCrateRecipes() {
        for (ItemCrated crate : crates) {
            ItemStack crateStack = new ItemStack((Item)crate);
            ItemStack uncrated = crate.getContained();
            if (crate.usesOreDict()) {
                int[] oreIds;
                for (int oreId : oreIds = OreDictionary.getOreIDs((ItemStack)uncrated)) {
                    String oreName = OreDictionary.getOreName((int)oreId);
                    PluginStorage.addCrating(crateStack, oreName);
                }
            } else {
                PluginStorage.addCrating(crateStack, uncrated);
            }
            PluginStorage.addUncrating(crateStack, uncrated);
        }
    }

    private static void addCrating(ItemStack crateStack, Object uncrated) {
        FluidStack water = Fluids.WATER.getFluid(100);
        ItemStack box = PluginStorage.items.crate.getItemStack();
        RecipeManagers.carpenterManager.addRecipe(5, water, box, crateStack, "###", "###", "###", Character.valueOf('#'), uncrated);
    }

    private static void addUncrating(ItemStack crateStack, ItemStack uncrated) {
        ItemStack product = new ItemStack(uncrated.getItem(), 9, uncrated.getItemDamage());
        RecipeManagers.carpenterManager.addRecipe(5, null, product, "#", Character.valueOf('#'), crateStack);
    }

    @Override
    public boolean processIMCMessage(FMLInterModComms.IMCMessage message) {
        if (message.key.equals("add-backpack-items")) {
            String[] tokens = message.getStringValue().split("@");
            if (tokens.length != 2) {
                PluginStorage.logInvalidIMCMessage(message);
                return true;
            }
            if (!BackpackManager.definitions.containsKey(tokens[0])) {
                String errorMessage = PluginStorage.getInvalidIMCMessageText(message);
                Log.warning("%s For non-existent backpack %s.", errorMessage, tokens[0]);
                return true;
            }
            IBackpackDefinition backpackDefinition = BackpackManager.definitions.get(tokens[0]);
            List<ItemStack> itemStacks = ItemStackUtil.parseItemStackStrings(tokens[1], 0);
            backpackDefinition.addValidItems(itemStacks);
            return true;
        }
        return false;
    }

    @Override
    public IPickupHandler getPickupHandler() {
        return new PickupHandlerStorage();
    }

    @Override
    public GuiHandlerBase getGuiHandler() {
        return new GuiHandlerStorage();
    }

    @Override
    public IResupplyHandler getResupplyHandler() {
        return new ResupplyHandler();
    }

    @Override
    protected void registerRecipes() {
        BlockRegistryApiculture beeBlocks = PluginApiculture.blocks;
        if (PluginStorage.items.apiaristBackpack != null && beeBlocks != null) {
            PluginStorage.addBackpackRecipe(PluginStorage.items.apiaristBackpack, "stickWood", (Object)beeBlocks.apicultureChest);
        }
        BlockRegistryLepidopterology butterflyBlocks = PluginLepidopterology.blocks;
        if (PluginStorage.items.lepidopteristBackpack != null && butterflyBlocks != null) {
            ItemStack chest = butterflyBlocks.lepidopterology.get(BlockLepidopterologyType.LEPICHEST);
            PluginStorage.addBackpackRecipe(PluginStorage.items.lepidopteristBackpack, "stickWood", chest);
        }
        PluginStorage.addBackpackRecipe(PluginStorage.items.minerBackpack, "ingotIron");
        PluginStorage.addBackpackRecipe(PluginStorage.items.diggerBackpack, "stone");
        PluginStorage.addBackpackRecipe(PluginStorage.items.foresterBackpack, "logWood");
        PluginStorage.addBackpackRecipe(PluginStorage.items.hunterBackpack, Items.feather);
        PluginStorage.addBackpackRecipe(PluginStorage.items.adventurerBackpack, Items.bone);
        PluginStorage.addBackpackRecipe(PluginStorage.items.builderBackpack, Items.clay_ball);
        if (PluginManager.Module.FACTORY.isEnabled()) {
            RecipeManagers.carpenterManager.addRecipe(20, Fluids.WATER.getFluid(1000), null, PluginStorage.items.crate.getItemStack(24), " # ", "# #", " # ", Character.valueOf('#'), "logWood");
            PluginStorage.addT2BackpackRecipe(PluginStorage.items.minerBackpack, PluginStorage.items.minerBackpackT2);
            PluginStorage.addT2BackpackRecipe(PluginStorage.items.diggerBackpack, PluginStorage.items.diggerBackpackT2);
            PluginStorage.addT2BackpackRecipe(PluginStorage.items.foresterBackpack, PluginStorage.items.foresterBackpackT2);
            PluginStorage.addT2BackpackRecipe(PluginStorage.items.hunterBackpack, PluginStorage.items.hunterBackpackT2);
            PluginStorage.addT2BackpackRecipe(PluginStorage.items.adventurerBackpack, PluginStorage.items.adventurerBackpackT2);
            PluginStorage.addT2BackpackRecipe(PluginStorage.items.builderBackpack, PluginStorage.items.builderBackpackT2);
        }
    }

    private static void addBackpackRecipe(Item backpack, Object material) {
        PluginStorage.addBackpackRecipe(backpack, material, "chestWood");
    }

    private static void addBackpackRecipe(Item backpack, Object material, Object chest) {
        RecipeUtil.addRecipe(backpack, "X#X", "VYV", "X#X", Character.valueOf('#'), Blocks.wool, Character.valueOf('X'), Items.string, Character.valueOf('V'), material, Character.valueOf('Y'), chest);
    }

    private static void addT2BackpackRecipe(Item backpackT1, Item backpackT2) {
        ItemStack wovenSilk = PluginCore.items.craftingMaterial.getWovenSilk();
        RecipeManagers.carpenterManager.addRecipe(200, Fluids.WATER.getFluid(1000), null, new ItemStack(backpackT2), "WXW", "WTW", "WWW", Character.valueOf('X'), "gemDiamond", Character.valueOf('W'), wovenSilk, Character.valueOf('T'), backpackT1);
    }
}

