/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.SidedProxy;
import forestry.Forestry;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.AlleleManager;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.recipes.RecipeManagers;
import forestry.core.GuiHandlerBase;
import forestry.core.config.LocalizedConfiguration;
import forestry.core.fluids.Fluids;
import forestry.core.recipes.RecipeUtil;
import forestry.core.tiles.MachineDefinition;
import forestry.core.utils.EntityUtil;
import forestry.lepidopterology.ButterflySpawner;
import forestry.lepidopterology.GuiHandlerLepidopterology;
import forestry.lepidopterology.blocks.BlockLepidopterologyType;
import forestry.lepidopterology.blocks.BlockRegistryLepidopterology;
import forestry.lepidopterology.commands.CommandButterfly;
import forestry.lepidopterology.entities.EntityButterfly;
import forestry.lepidopterology.genetics.AlleleButterflyEffect;
import forestry.lepidopterology.genetics.ButterflyBranchDefinition;
import forestry.lepidopterology.genetics.ButterflyDefinition;
import forestry.lepidopterology.genetics.ButterflyFactory;
import forestry.lepidopterology.genetics.ButterflyHelper;
import forestry.lepidopterology.genetics.MothDefinition;
import forestry.lepidopterology.items.ItemRegistryLepidopterology;
import forestry.lepidopterology.proxy.ProxyLepidopterology;
import forestry.lepidopterology.recipes.MatingRecipe;
import forestry.plugins.ForestryPlugin;
import forestry.plugins.Plugin;
import forestry.plugins.PluginCore;
import forestry.plugins.PluginManager;
import java.io.File;
import java.util.EnumSet;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraftforge.oredict.RecipeSorter;

@Plugin(pluginID="Lepidopterology", name="Lepidopterology", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.lepidopterology.description")
public class PluginLepidopterology
extends ForestryPlugin {
    @SidedProxy(clientSide="forestry.lepidopterology.proxy.ProxyLepidopterologyClient", serverSide="forestry.lepidopterology.proxy.ProxyLepidopterology")
    public static ProxyLepidopterology proxy;
    private static final String CONFIG_CATEGORY = "lepidopterology";
    public static int spawnConstraint;
    public static int entityConstraint;
    private static boolean allowPollination;
    public static ItemRegistryLepidopterology items;
    public static BlockRegistryLepidopterology blocks;

    @Override
    protected void setupAPI() {
        super.setupAPI();
        ButterflyManager.butterflyRoot = new ButterflyHelper();
        AlleleManager.alleleRegistry.registerSpeciesRoot(ButterflyManager.butterflyRoot);
        ButterflyManager.butterflyFactory = new ButterflyFactory();
    }

    @Override
    protected void registerItemsAndBlocks() {
        items = new ItemRegistryLepidopterology();
        blocks = new BlockRegistryLepidopterology();
    }

    @Override
    public void preInit() {
        ButterflyBranchDefinition.createAlleles();
        AlleleButterflyEffect.createAlleles();
        MachineDefinition definitionChest = new MachineDefinition(BlockLepidopterologyType.LEPICHEST).setBoundingBox(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9375f);
        PluginLepidopterology.blocks.lepidopterology.addDefinition(definitionChest);
    }

    @Override
    public EnumSet<PluginManager.Module> getDependancies() {
        EnumSet<PluginManager.Module> deps = super.getDependancies();
        deps.add(PluginManager.Module.ARBORICULTURE);
        return deps;
    }

    @Override
    public void doInit() {
        File configFile = new File(Forestry.instance.getConfigFolder(), "lepidopterology.cfg");
        PluginLepidopterology.loadConfig(configFile);
        PluginCore.rootCommand.addChildCommand(new CommandButterfly());
        EntityUtil.registerEntity(EntityButterfly.class, "butterflyGE", 0, 0, 0xFFFFFF, 50, 1, true);
        proxy.initializeRendering();
        MothDefinition.initMoths();
        ButterflyDefinition.initButterflies();
        PluginLepidopterology.blocks.lepidopterology.init();
        TreeManager.treeRoot.registerLeafTickHandler(new ButterflySpawner());
        RecipeSorter.register((String)"forestry:lepidopterologymating", MatingRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"before:minecraft:shapeless");
    }

    private static void loadConfig(File configFile) {
        LocalizedConfiguration config = new LocalizedConfiguration(configFile, "1.0.0");
        spawnConstraint = config.getIntLocalized("butterfly.entities", "spawn.limit", spawnConstraint, 0, 500);
        entityConstraint = config.getIntLocalized("butterfly.entities", "maximum", entityConstraint, 0, 5000);
        allowPollination = config.getBooleanLocalized("butterfly.entities", "pollination", allowPollination);
        config.save();
    }

    @Override
    protected void registerRecipes() {
        CraftingManager.getInstance().getRecipeList().add(new MatingRecipe());
        RecipeManagers.carpenterManager.addRecipe(100, Fluids.WATER.getFluid(2000), null, PluginLepidopterology.items.flutterlyzer.getItemStack(), "X#X", "X#X", "RDR", Character.valueOf('#'), "paneGlass", Character.valueOf('X'), "ingotBronze", Character.valueOf('R'), "dustRedstone", Character.valueOf('D'), "gemDiamond");
        RecipeUtil.addRecipe(PluginLepidopterology.blocks.lepidopterology.get(BlockLepidopterologyType.LEPICHEST), " # ", "XYX", "XXX", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), new ItemStack((Item)PluginLepidopterology.items.butterflyGE, 1, Short.MAX_VALUE), Character.valueOf('Y'), "chestWood");
    }

    @Override
    public GuiHandlerBase getGuiHandler() {
        return new GuiHandlerLepidopterology();
    }

    public static boolean isPollinationAllowed() {
        return allowPollination;
    }

    static {
        spawnConstraint = 100;
        entityConstraint = 1000;
        allowPollination = true;
    }
}

