/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import com.google.common.collect.ImmutableList;
import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.CircuitSocketType;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.core.ForestryAPI;
import forestry.api.fuels.EngineBronzeFuel;
import forestry.api.fuels.EngineCopperFuel;
import forestry.api.fuels.FermenterFuel;
import forestry.api.fuels.FuelManager;
import forestry.api.fuels.GeneratorFuel;
import forestry.api.fuels.MoistenerFuel;
import forestry.api.fuels.RainSubstrate;
import forestry.api.recipes.RecipeManagers;
import forestry.apiculture.items.ItemRegistryApiculture;
import forestry.core.GuiHandlerBase;
import forestry.core.blocks.BlockCoreType;
import forestry.core.blocks.BlockSoil;
import forestry.core.circuits.Circuit;
import forestry.core.circuits.CircuitLayout;
import forestry.core.circuits.EnumCircuitBoardType;
import forestry.core.circuits.ItemCircuitBoard;
import forestry.core.fluids.Fluids;
import forestry.core.items.EnumElectronTube;
import forestry.core.items.ItemElectronTube;
import forestry.core.items.ItemRegistryCore;
import forestry.core.network.IPacketRegistry;
import forestry.core.recipes.RecipeUtil;
import forestry.core.recipes.craftguide.CraftGuideIntegration;
import forestry.core.tiles.MachineDefinition;
import forestry.core.utils.Log;
import forestry.core.utils.ModUtil;
import forestry.core.utils.datastructures.FluidMap;
import forestry.core.utils.datastructures.ItemStackMap;
import forestry.factory.DummyManagers;
import forestry.factory.GuiHandlerFactory;
import forestry.factory.blocks.BlockFactoryPlainType;
import forestry.factory.blocks.BlockFactoryTesrType;
import forestry.factory.blocks.BlockRegistryFactory;
import forestry.factory.circuits.CircuitSpeedUpgrade;
import forestry.factory.network.PacketRegistryFactory;
import forestry.factory.recipes.CarpenterRecipeManager;
import forestry.factory.recipes.CentrifugeRecipeManager;
import forestry.factory.recipes.FabricatorRecipeManager;
import forestry.factory.recipes.FabricatorSmeltingRecipeManager;
import forestry.factory.recipes.FermenterRecipeManager;
import forestry.factory.recipes.MoistenerRecipeManager;
import forestry.factory.recipes.SqueezerRecipeManager;
import forestry.factory.recipes.StillRecipeManager;
import forestry.factory.triggers.FactoryTriggers;
import forestry.plugins.ForestryPlugin;
import forestry.plugins.Plugin;
import forestry.plugins.PluginApiculture;
import forestry.plugins.PluginCore;
import forestry.plugins.PluginFluids;
import forestry.plugins.PluginManager;
import forestry.plugins.PluginStorage;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

@Plugin(pluginID="Factory", name="Factory", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.factory.description")
public class PluginFactory
extends ForestryPlugin {
    private static MachineDefinition definitionBottler;
    private static MachineDefinition definitionCarpenter;
    private static MachineDefinition definitionCentrifuge;
    private static MachineDefinition definitionFermenter;
    private static MachineDefinition definitionMoistener;
    private static MachineDefinition definitionSqueezer;
    private static MachineDefinition definitionStill;
    private static MachineDefinition definitionRainmaker;
    private static MachineDefinition definitionFabricator;
    private static MachineDefinition definitionRaintank;
    private static MachineDefinition definitionWorktable;
    public static BlockRegistryFactory blocks;

    @Override
    protected void setupAPI() {
        super.setupAPI();
        RecipeManagers.carpenterManager = new CarpenterRecipeManager();
        RecipeManagers.centrifugeManager = new CentrifugeRecipeManager();
        RecipeManagers.fabricatorManager = new FabricatorRecipeManager();
        RecipeManagers.fabricatorSmeltingManager = new FabricatorSmeltingRecipeManager();
        RecipeManagers.fermenterManager = new FermenterRecipeManager();
        RecipeManagers.moistenerManager = new MoistenerRecipeManager();
        RecipeManagers.squeezerManager = new SqueezerRecipeManager();
        RecipeManagers.stillManager = new StillRecipeManager();
        RecipeManagers.craftingProviders = ImmutableList.of((Object)RecipeManagers.carpenterManager, (Object)RecipeManagers.centrifugeManager, (Object)RecipeManagers.fabricatorManager, (Object)RecipeManagers.fabricatorSmeltingManager, (Object)RecipeManagers.fermenterManager, (Object)RecipeManagers.moistenerManager, (Object)RecipeManagers.squeezerManager, (Object)RecipeManagers.stillManager);
        PluginFactory.setupFuelManager();
    }

    @Override
    protected void disabledSetupAPI() {
        super.disabledSetupAPI();
        RecipeManagers.carpenterManager = new DummyManagers.DummyCarpenterManager();
        RecipeManagers.centrifugeManager = new DummyManagers.DummyCentrifugeManager();
        RecipeManagers.fabricatorManager = new DummyManagers.DummyFabricatorManager();
        RecipeManagers.fabricatorSmeltingManager = new DummyManagers.DummyFabricatorSmeltingManager();
        RecipeManagers.fermenterManager = new DummyManagers.DummyFermenterManager();
        RecipeManagers.moistenerManager = new DummyManagers.DummyMoistenerManager();
        RecipeManagers.squeezerManager = new DummyManagers.DummySqueezerManager();
        RecipeManagers.stillManager = new DummyManagers.DummyStillManager();
        RecipeManagers.craftingProviders = ImmutableList.of((Object)RecipeManagers.carpenterManager, (Object)RecipeManagers.centrifugeManager, (Object)RecipeManagers.fabricatorManager, (Object)RecipeManagers.fabricatorSmeltingManager, (Object)RecipeManagers.fermenterManager, (Object)RecipeManagers.moistenerManager, (Object)RecipeManagers.squeezerManager, (Object)RecipeManagers.stillManager);
        PluginFactory.setupFuelManager();
    }

    private static void setupFuelManager() {
        FuelManager.fermenterFuel = new ItemStackMap<FermenterFuel>();
        FuelManager.moistenerResource = new ItemStackMap<MoistenerFuel>();
        FuelManager.rainSubstrate = new ItemStackMap<RainSubstrate>();
        FuelManager.bronzeEngineFuel = new FluidMap<EngineBronzeFuel>();
        FuelManager.copperEngineFuel = new ItemStackMap<EngineCopperFuel>();
        FuelManager.generatorFuel = new FluidMap<GeneratorFuel>();
    }

    @Override
    protected void registerItemsAndBlocks() {
        blocks = new BlockRegistryFactory();
    }

    @Override
    public IPacketRegistry getPacketRegistry() {
        return new PacketRegistryFactory();
    }

    @Override
    public void preInit() {
        super.preInit();
        ItemRegistryCore coreItems = PluginCore.items;
        ItemStack fertilizerCompound = coreItems.fertilizerCompound.getItemStack();
        FuelManager.fermenterFuel.put(fertilizerCompound, new FermenterFuel(fertilizerCompound, ForestryAPI.activeMode.getIntegerSetting("fermenter.value.fertilizer"), ForestryAPI.activeMode.getIntegerSetting("fermenter.cycles.fertilizer")));
        int cyclesCompost = ForestryAPI.activeMode.getIntegerSetting("fermenter.cycles.compost");
        int valueCompost = ForestryAPI.activeMode.getIntegerSetting("fermenter.value.compost");
        ItemStack fertilizerBio = coreItems.fertilizerBio.getItemStack();
        ItemStack mulch = coreItems.mulch.getItemStack();
        FuelManager.fermenterFuel.put(fertilizerBio, new FermenterFuel(fertilizerBio, valueCompost, cyclesCompost));
        FuelManager.fermenterFuel.put(mulch, new FermenterFuel(mulch, valueCompost, cyclesCompost));
        ItemStack wheat = new ItemStack(Items.wheat);
        ItemStack mouldyWheat = coreItems.mouldyWheat.getItemStack();
        ItemStack decayingWheat = coreItems.decayingWheat.getItemStack();
        FuelManager.moistenerResource.put(wheat, new MoistenerFuel(wheat, mouldyWheat, 0, 300));
        FuelManager.moistenerResource.put(mouldyWheat, new MoistenerFuel(mouldyWheat, decayingWheat, 1, 600));
        FuelManager.moistenerResource.put(decayingWheat, new MoistenerFuel(decayingWheat, mulch, 2, 900));
        ItemStack peat = coreItems.peat.getItemStack();
        FuelManager.copperEngineFuel.put(peat, new EngineCopperFuel(peat, 10, 5000));
        ItemStack bituminousPeat = coreItems.peat.getItemStack();
        FuelManager.copperEngineFuel.put(bituminousPeat, new EngineCopperFuel(bituminousPeat, 20, 6000));
        FuelManager.bronzeEngineFuel.put(Fluids.BIOMASS.getFluid(), new EngineBronzeFuel(Fluids.BIOMASS.getFluid(), 50, (int)(2500.0f * ForestryAPI.activeMode.getFloatSetting("fuel.biomass.biogas")), 1));
        FuelManager.bronzeEngineFuel.put(Fluids.WATER.getFluid(), new EngineBronzeFuel(Fluids.WATER.getFluid(), 10, 1000, 3));
        FuelManager.bronzeEngineFuel.put(Fluids.MILK.getFluid(), new EngineBronzeFuel(Fluids.MILK.getFluid(), 10, 10000, 3));
        FuelManager.bronzeEngineFuel.put(Fluids.SEEDOIL.getFluid(), new EngineBronzeFuel(Fluids.SEEDOIL.getFluid(), 30, 2500, 1));
        FuelManager.bronzeEngineFuel.put(Fluids.HONEY.getFluid(), new EngineBronzeFuel(Fluids.HONEY.getFluid(), 20, 2500, 1));
        FuelManager.bronzeEngineFuel.put(Fluids.JUICE.getFluid(), new EngineBronzeFuel(Fluids.JUICE.getFluid(), 10, 2500, 1));
        ItemStack iodineCharge = coreItems.iodineCharge.getItemStack();
        ItemStack dissipationCharge = coreItems.craftingMaterial.getDissipationCharge();
        FuelManager.rainSubstrate.put(iodineCharge, new RainSubstrate(iodineCharge, 10000, 0.01f));
        FuelManager.rainSubstrate.put(dissipationCharge, new RainSubstrate(dissipationCharge, 0.075f));
        for (BlockFactoryTesrType type : BlockFactoryTesrType.VALUES) {
            MachineDefinition machineDefinition = new MachineDefinition(type);
            PluginFactory.blocks.factoryTESR.addDefinition(machineDefinition);
        }
        PluginFactory.blocks.factoryPlain.addDefinitions(new MachineDefinition(BlockFactoryPlainType.FABRICATOR).setFaces(0, 1, 2, 3, 4, 4), new MachineDefinition(BlockFactoryPlainType.RAINTANK).setFaces(0, 1, 0, 0, 0, 0), new MachineDefinition(BlockFactoryPlainType.WORKTABLE).setFaces(0, 1, 2, 3, 4, 4));
        CircuitLayout layoutMachineUpgrade = new CircuitLayout("machine.upgrade", CircuitSocketType.MACHINE);
        ChipsetManager.circuitRegistry.registerLayout(layoutMachineUpgrade);
    }

    @Override
    protected void registerTriggers() {
        FactoryTriggers.initialize();
    }

    @Override
    public void doInit() {
        super.doInit();
        PluginFactory.blocks.factoryTESR.init();
        PluginFactory.blocks.factoryPlain.init();
        Circuit.machineSpeedUpgrade1 = new CircuitSpeedUpgrade("machine.speed.boost.1", 0.125, 0.05f, 4);
        Circuit.machineSpeedUpgrade2 = new CircuitSpeedUpgrade("machine.speed.boost.2", 0.25, 0.1f, 4);
        Circuit.machineEfficiencyUpgrade1 = new CircuitSpeedUpgrade("machine.efficiency.1", 0.0, -0.1f, 2);
    }

    @Override
    public void postInit() {
        super.postInit();
        if (ModUtil.isModLoaded("craftguide")) {
            CraftGuideIntegration.register();
        } else {
            Log.info("Skipping CraftGuide integration.");
        }
    }

    @Override
    protected void registerRecipes() {
        ItemElectronTube electronTube = PluginCore.items.tubes;
        RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), electronTube.get(EnumElectronTube.COPPER, 4), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), "ingotCopper"});
        RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), electronTube.get(EnumElectronTube.TIN, 4), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), "ingotTin"});
        RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), electronTube.get(EnumElectronTube.BRONZE, 4), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), "ingotBronze"});
        RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), electronTube.get(EnumElectronTube.IRON, 4), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), "ingotIron"});
        RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), electronTube.get(EnumElectronTube.GOLD, 4), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), "ingotGold"});
        RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), electronTube.get(EnumElectronTube.DIAMOND, 4), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), "gemDiamond"});
        RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), electronTube.get(EnumElectronTube.OBSIDIAN, 4), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), Blocks.obsidian});
        RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), electronTube.get(EnumElectronTube.BLAZE, 4), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), Items.blaze_powder});
        RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), electronTube.get(EnumElectronTube.EMERALD, 4), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), "gemEmerald"});
        RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), electronTube.get(EnumElectronTube.APATITE, 4), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), "gemApatite"});
        RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), electronTube.get(EnumElectronTube.LAPIS, 4), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), new ItemStack(Items.dye, 1, 4)});
        RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), electronTube.get(EnumElectronTube.ENDER, 4), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), new ItemStack(Items.ender_eye, 1, 0), Character.valueOf('X'), new ItemStack(Blocks.end_stone, 1, 0)});
        String[] dyes = new String[]{"dyeBlack", "dyeRed", "dyeGreen", "dyeBrown", "dyeBlue", "dyePurple", "dyeCyan", "dyeLightGray", "dyeGray", "dyePink", "dyeLime", "dyeYellow", "dyeLightBlue", "dyeMagenta", "dyeOrange", "dyeWhite"};
        if (PluginManager.Module.APICULTURE.isEnabled()) {
            ItemRegistryApiculture beeItems = PluginApiculture.items;
            FluidStack liquidGlass = Fluids.GLASS.getFluid(1000);
            for (int i = 0; i < 16; ++i) {
                RecipeManagers.fabricatorManager.addRecipe(beeItems.waxCast.getWildcard(), liquidGlass, new ItemStack((Block)Blocks.stained_glass, 4, 15 - i), new Object[]{"#", "X", Character.valueOf('#'), dyes[i], Character.valueOf('X'), beeItems.propolis.getWildcard()});
            }
        }
        int appleMulchAmount = ForestryAPI.activeMode.getIntegerSetting("squeezer.mulch.apple");
        int appleJuiceAmount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.apple");
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(Items.apple)}, Fluids.JUICE.getFluid(appleJuiceAmount), PluginCore.items.mulch.getItemStack(), appleMulchAmount);
        int seedOilAmount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.seed");
        FluidStack seedOil = Fluids.SEEDOIL.getFluid(seedOilAmount);
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(Items.wheat_seeds)}, seedOil);
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(Items.pumpkin_seeds)}, seedOil);
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(Items.melon_seeds)}, seedOil);
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{PluginCore.items.phosphor.getItemStack(2), new ItemStack(Blocks.cobblestone)}, Fluids.LAVA.getFluid(1600));
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(Blocks.cactus)}, Fluids.WATER.getFluid(500));
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(Items.snowball), PluginCore.items.craftingMaterial.getIceShard(4)}, Fluids.ICE.getFluid(4000));
        RecipeManagers.stillManager.addRecipe(100, Fluids.BIOMASS.getFluid(10), Fluids.ETHANOL.getFluid(3));
        if (FluidRegistry.isFluidRegistered((String)Fluids.LEGACY_HONEY.name())) {
            RecipeManagers.stillManager.addRecipe(1, Fluids.LEGACY_HONEY.getFluid(1000), Fluids.HONEY.getFluid(1000));
        }
        RecipeManagers.moistenerManager.addRecipe(new ItemStack(Items.wheat_seeds), new ItemStack((Block)Blocks.mycelium), 5000);
        RecipeManagers.moistenerManager.addRecipe(new ItemStack(Blocks.cobblestone), new ItemStack(Blocks.mossy_cobblestone), 20000);
        RecipeManagers.moistenerManager.addRecipe(new ItemStack(Blocks.stonebrick), new ItemStack(Blocks.stonebrick, 1, 1), 20000);
        for (int i = 0; i < 6; ++i) {
            RecipeUtil.addFermenterRecipes(new ItemStack(Blocks.sapling, 1, i), ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.sapling"), Fluids.BIOMASS);
        }
        RecipeUtil.addFermenterRecipes(new ItemStack(Blocks.cactus), ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.cactus"), Fluids.BIOMASS);
        RecipeUtil.addFermenterRecipes(new ItemStack(Items.wheat), ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.wheat"), Fluids.BIOMASS);
        RecipeUtil.addFermenterRecipes(new ItemStack(Items.reeds), ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.cane"), Fluids.BIOMASS);
        RecipeUtil.addFermenterRecipes(new ItemStack((Block)Blocks.brown_mushroom), ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.mushroom"), Fluids.BIOMASS);
        RecipeUtil.addFermenterRecipes(new ItemStack((Block)Blocks.red_mushroom), ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.mushroom"), Fluids.BIOMASS);
        RecipeManagers.fabricatorSmeltingManager.addSmelting(new ItemStack(Blocks.glass), Fluids.GLASS.getFluid(1000), 1000);
        RecipeManagers.fabricatorSmeltingManager.addSmelting(new ItemStack(Blocks.glass_pane), Fluids.GLASS.getFluid(375), 1000);
        RecipeManagers.fabricatorSmeltingManager.addSmelting(new ItemStack((Block)Blocks.sand), Fluids.GLASS.getFluid(1000), 3000);
        RecipeManagers.carpenterManager.addRecipe(50, Fluids.SEEDOIL.getFluid(250), null, PluginCore.items.impregnatedCasing.getItemStack(), "###", "# #", "###", Character.valueOf('#'), "logWood");
        RecipeManagers.carpenterManager.addRecipe(50, Fluids.SEEDOIL.getFluid(500), null, PluginCore.blocks.core.get(BlockCoreType.ESCRITOIRE, 1), "#  ", "###", "# #", Character.valueOf('#'), "plankWood");
        RecipeManagers.carpenterManager.addRecipe(10, Fluids.SEEDOIL.getFluid(100), null, PluginCore.items.stickImpregnated.getItemStack(2), "#", "#", Character.valueOf('#'), "logWood");
        RecipeManagers.carpenterManager.addRecipe(5, Fluids.WATER.getFluid(250), null, PluginCore.items.woodPulp.getItemStack(4), "#", Character.valueOf('#'), "logWood");
        RecipeManagers.carpenterManager.addRecipe(5, Fluids.WATER.getFluid(250), null, new ItemStack(Items.paper, 1), "#", "#", Character.valueOf('#'), "pulpWood");
        RecipeManagers.carpenterManager.addRecipe(5, Fluids.WATER.getFluid(1000), null, PluginCore.blocks.soil.get(BlockSoil.SoilType.HUMUS, 9), new Object[]{"###", "#X#", "###", Character.valueOf('#'), Blocks.dirt, Character.valueOf('X'), PluginCore.items.mulch});
        RecipeManagers.carpenterManager.addRecipe(5, Fluids.WATER.getFluid(1000), null, PluginCore.blocks.soil.get(BlockSoil.SoilType.BOG_EARTH, 8), new Object[]{"#X#", "XYX", "#X#", Character.valueOf('#'), Blocks.dirt, Character.valueOf('X'), "sand", Character.valueOf('Y'), PluginCore.items.mulch});
        RecipeManagers.carpenterManager.addRecipe(75, Fluids.WATER.getFluid(5000), null, PluginCore.items.hardenedCasing.getItemStack(), new Object[]{"# #", " Y ", "# #", Character.valueOf('#'), "gemDiamond", Character.valueOf('Y'), PluginCore.items.sturdyCasing});
        ItemCircuitBoard circuitBoard = PluginCore.items.circuitboards;
        RecipeManagers.carpenterManager.addRecipe(20, Fluids.WATER.getFluid(1000), null, circuitBoard.get(EnumCircuitBoardType.BASIC), "R R", "R#R", "R R", Character.valueOf('#'), "ingotTin", Character.valueOf('R'), "dustRedstone");
        RecipeManagers.carpenterManager.addRecipe(40, Fluids.WATER.getFluid(1000), null, circuitBoard.get(EnumCircuitBoardType.ENHANCED), "R#R", "R#R", "R#R", Character.valueOf('#'), "ingotBronze", Character.valueOf('R'), "dustRedstone");
        RecipeManagers.carpenterManager.addRecipe(80, Fluids.WATER.getFluid(1000), null, circuitBoard.get(EnumCircuitBoardType.REFINED), "R#R", "R#R", "R#R", Character.valueOf('#'), "ingotIron", Character.valueOf('R'), "dustRedstone");
        RecipeManagers.carpenterManager.addRecipe(80, Fluids.WATER.getFluid(1000), null, circuitBoard.get(EnumCircuitBoardType.INTRICATE), "R#R", "R#R", "R#R", Character.valueOf('#'), "ingotGold", Character.valueOf('R'), "dustRedstone");
        RecipeManagers.carpenterManager.addRecipe(40, Fluids.WATER.getFluid(1000), null, PluginCore.items.solderingIron.getItemStack(), " # ", "# #", "  B", Character.valueOf('#'), "ingotIron", Character.valueOf('B'), "ingotBronze");
        ItemRegistryApiculture beeItems = PluginApiculture.items;
        if (beeItems != null) {
            RecipeManagers.carpenterManager.addRecipe(5, Fluids.WATER.getFluid(1000), null, PluginCore.items.iodineCharge.getItemStack(), new Object[]{"Z#Z", "#Y#", "X#X", Character.valueOf('#'), beeItems.pollenCluster.getWildcard(), Character.valueOf('X'), Items.gunpowder, Character.valueOf('Y'), PluginFluids.items.canEmpty, Character.valueOf('Z'), beeItems.honeyDrop});
            RecipeManagers.carpenterManager.addRecipe(5, Fluids.WATER.getFluid(1000), null, PluginCore.items.craftingMaterial.getDissipationCharge(), new Object[]{"Z#Z", "#Y#", "X#X", Character.valueOf('#'), beeItems.royalJelly, Character.valueOf('X'), Items.gunpowder, Character.valueOf('Y'), PluginFluids.items.canEmpty, Character.valueOf('Z'), beeItems.honeydew});
        }
        RecipeManagers.carpenterManager.addRecipe(100, null, new ItemStack(Items.ender_pearl, 1), " # ", "###", " # ", Character.valueOf('#'), PluginCore.items.craftingMaterial.getPulsatingMesh());
        RecipeManagers.carpenterManager.addRecipe(10, Fluids.WATER.getFluid(500), null, PluginCore.items.craftingMaterial.getWovenSilk(), "###", "###", "###", Character.valueOf('#'), PluginCore.items.craftingMaterial.getSilkWisp());
        RecipeManagers.carpenterManager.addRecipe(5, Fluids.WATER.getFluid(1000), null, PluginCore.items.carton.getItemStack(2), " # ", "# #", " # ", Character.valueOf('#'), "pulpWood");
        RecipeManagers.carpenterManager.addRecipe(20, (FluidStack)null, PluginCore.items.carton.getItemStack(), PluginCore.items.kitPickaxe.getItemStack(), "###", " X ", " X ", Character.valueOf('#'), "ingotBronze", Character.valueOf('X'), "stickWood");
        RecipeManagers.carpenterManager.addRecipe(20, (FluidStack)null, PluginCore.items.carton.getItemStack(), PluginCore.items.kitShovel.getItemStack(), " # ", " X ", " X ", Character.valueOf('#'), "ingotBronze", Character.valueOf('X'), "stickWood");
        RecipeManagers.carpenterManager.addRecipe(null, PluginCore.items.ingotBronze.getItemStack(2), new Object[]{"#", Character.valueOf('#'), PluginCore.items.brokenBronzePickaxe});
        RecipeManagers.carpenterManager.addRecipe(null, PluginCore.items.ingotBronze.getItemStack(), new Object[]{"#", Character.valueOf('#'), PluginCore.items.brokenBronzeShovel});
        if (PluginManager.Module.STORAGE.isEnabled()) {
            PluginStorage.createCrateRecipes();
        }
        ICircuitLayout layout = ChipsetManager.circuitRegistry.getLayout("forestry.machine.upgrade");
        ChipsetManager.solderManager.addRecipe(layout, PluginCore.items.tubes.get(EnumElectronTube.EMERALD, 1), Circuit.machineSpeedUpgrade1);
        ChipsetManager.solderManager.addRecipe(layout, PluginCore.items.tubes.get(EnumElectronTube.BLAZE, 1), Circuit.machineSpeedUpgrade2);
        ChipsetManager.solderManager.addRecipe(layout, PluginCore.items.tubes.get(EnumElectronTube.GOLD, 1), Circuit.machineEfficiencyUpgrade1);
        RecipeUtil.addRecipe(PluginFactory.blocks.factoryTESR.get(BlockFactoryTesrType.BOTTLER), new Object[]{"X#X", "#Y#", "X#X", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), PluginFluids.items.canEmpty, Character.valueOf('Y'), PluginCore.items.sturdyCasing});
        RecipeUtil.addRecipe(PluginFactory.blocks.factoryTESR.get(BlockFactoryTesrType.CARPENTER), new Object[]{"X#X", "XYX", "X#X", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), "ingotBronze", Character.valueOf('Y'), PluginCore.items.sturdyCasing});
        RecipeUtil.addRecipe(PluginFactory.blocks.factoryTESR.get(BlockFactoryTesrType.CENTRIFUGE), new Object[]{"X#X", "XYX", "X#X", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), "ingotCopper", Character.valueOf('Y'), PluginCore.items.sturdyCasing});
        RecipeUtil.addRecipe(PluginFactory.blocks.factoryTESR.get(BlockFactoryTesrType.FERMENTER), new Object[]{"X#X", "#Y#", "X#X", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), "gearBronze", Character.valueOf('Y'), PluginCore.items.sturdyCasing});
        RecipeUtil.addRecipe(PluginFactory.blocks.factoryTESR.get(BlockFactoryTesrType.MOISTENER), new Object[]{"X#X", "#Y#", "X#X", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), "gearCopper", Character.valueOf('Y'), PluginCore.items.sturdyCasing});
        RecipeUtil.addRecipe(PluginFactory.blocks.factoryTESR.get(BlockFactoryTesrType.SQUEEZER), new Object[]{"X#X", "XYX", "X#X", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), "ingotTin", Character.valueOf('Y'), PluginCore.items.sturdyCasing});
        RecipeUtil.addRecipe(PluginFactory.blocks.factoryTESR.get(BlockFactoryTesrType.STILL), new Object[]{"X#X", "#Y#", "X#X", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), "dustRedstone", Character.valueOf('Y'), PluginCore.items.sturdyCasing});
        RecipeUtil.addRecipe(PluginFactory.blocks.factoryTESR.get(BlockFactoryTesrType.RAINMAKER), new Object[]{"X#X", "#Y#", "X#X", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), "gearTin", Character.valueOf('Y'), PluginCore.items.hardenedCasing});
        RecipeUtil.addRecipe(PluginFactory.blocks.factoryPlain.get(BlockFactoryPlainType.FABRICATOR), new Object[]{"X#X", "#Y#", "XZX", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), "ingotGold", Character.valueOf('Y'), PluginCore.items.sturdyCasing, Character.valueOf('Z'), "chestWood"});
        RecipeUtil.addRecipe(PluginFactory.blocks.factoryPlain.get(BlockFactoryPlainType.RAINTANK), new Object[]{"X#X", "XYX", "X#X", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), "ingotIron", Character.valueOf('Y'), PluginCore.items.sturdyCasing});
        RecipeUtil.addRecipe(PluginFactory.blocks.factoryPlain.get(BlockFactoryPlainType.WORKTABLE), "B", "W", "C", Character.valueOf('B'), Items.book, Character.valueOf('W'), "craftingTableWood", Character.valueOf('C'), "chestWood");
    }

    @Override
    public GuiHandlerBase getGuiHandler() {
        return new GuiHandlerFactory();
    }
}

