/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import forestry.core.fluids.Fluids;
import forestry.core.items.EnumContainerType;
import forestry.core.items.ItemLiquidContainer;
import forestry.core.items.ItemRegistry;
import net.minecraft.init.Blocks;

public class ItemRegistryFluids
extends ItemRegistry {
    public final ItemLiquidContainer canEmpty;
    public final ItemLiquidContainer waxCapsuleEmpty;
    public final ItemLiquidContainer refractoryEmpty;
    private final Table<EnumContainerType, Integer, ItemLiquidContainer> containers = HashBasedTable.create();

    public ItemLiquidContainer getContainer(EnumContainerType type, Fluids fluid) {
        return (ItemLiquidContainer)((Object)this.containers.get((Object)type, (Object)fluid.getFluid().getID()));
    }

    public ItemRegistryFluids() {
        this.canEmpty = ItemRegistryFluids.registerEmptyContainer(EnumContainerType.CAN, "canEmpty");
        this.waxCapsuleEmpty = ItemRegistryFluids.registerEmptyContainer(EnumContainerType.CAPSULE, "waxCapsule");
        this.refractoryEmpty = ItemRegistryFluids.registerEmptyContainer(EnumContainerType.REFRACTORY, "refractoryEmpty");
        for (Fluids fluidType : Fluids.values()) {
            if (fluidType.getFluid() == null) continue;
            for (EnumContainerType type : fluidType.getContainerTypes()) {
                ItemLiquidContainer liquidContainer = new ItemLiquidContainer(type, fluidType.getBlock(), fluidType.getColor());
                fluidType.setProperties(liquidContainer);
                String name = type.getContainerNameKey() + fluidType.getContainerNameKey();
                ItemRegistryFluids.registerItem(liquidContainer, name);
                this.containers.put((Object)type, (Object)fluidType.getFluid().getID(), (Object)liquidContainer);
            }
        }
    }

    private static ItemLiquidContainer registerEmptyContainer(EnumContainerType type, String name) {
        return ItemRegistryFluids.registerItem(new ItemLiquidContainer(type, Blocks.air, null), name);
    }
}

