/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.BeeManager;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.core.GuiHandlerBase;
import forestry.core.gui.GuiNaturalistInventory;
import forestry.core.network.GuiId;
import forestry.storage.gui.ContainerBackpack;
import forestry.storage.gui.ContainerNaturalistBackpack;
import forestry.storage.gui.GuiBackpack;
import forestry.storage.gui.GuiBackpackT2;
import forestry.storage.inventory.ItemInventoryBackpackPaged;
import forestry.storage.items.ItemBackpack;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class GuiHandlerStorage
extends GuiHandlerBase {
    @Override
    @SideOnly(value=Side.CLIENT)
    public Gui getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        int cleanId = GuiHandlerStorage.decodeGuiID(id);
        int guiData = GuiHandlerStorage.decodeGuiData(id);
        if (cleanId >= GuiId.values().length) {
            return null;
        }
        GuiId guiId = GuiId.values()[cleanId];
        switch (guiId) {
            case ApiaristBackpackGUI: {
                return GuiHandlerStorage.getNaturalistGui(BeeManager.beeRoot, player, guiId, guiData);
            }
            case LepidopteristBackpackGUI: {
                return GuiHandlerStorage.getNaturalistGui(ButterflyManager.butterflyRoot, player, guiId, guiData);
            }
            case BackpackGUI: {
                ItemStack equipped = GuiHandlerStorage.getBackpackItem(player);
                if (equipped == null) {
                    return null;
                }
                return new GuiBackpack(new ContainerBackpack(player, ContainerBackpack.Size.DEFAULT, equipped));
            }
            case BackpackT2GUI: {
                ItemStack equipped = GuiHandlerStorage.getBackpackItem(player);
                if (equipped == null) {
                    return null;
                }
                return new GuiBackpackT2(new ContainerBackpack(player, ContainerBackpack.Size.T2, equipped));
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private static Gui getNaturalistGui(ISpeciesRoot root, EntityPlayer player, GuiId guiId, int guiData) {
        ItemStack equipped = GuiHandlerStorage.getBackpackItem(player);
        if (equipped == null) {
            return null;
        }
        ItemInventoryBackpackPaged inventory = new ItemInventoryBackpackPaged(player, 125, equipped, guiId);
        ContainerNaturalistBackpack container = new ContainerNaturalistBackpack(player, inventory, guiData);
        return new GuiNaturalistInventory(root, player, container, inventory, guiData, 5);
    }

    private static ItemStack getBackpackItem(EntityPlayer player) {
        ItemStack equipped = player.getCurrentEquippedItem();
        if (equipped == null) {
            return null;
        }
        if (equipped.getItem() instanceof ItemBackpack) {
            return equipped;
        }
        return null;
    }

    @Override
    public Container getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        int cleanId = GuiHandlerStorage.decodeGuiID(id);
        int guiData = GuiHandlerStorage.decodeGuiData(id);
        GuiId guiId = GuiId.values()[cleanId];
        if (cleanId >= GuiId.values().length) {
            return null;
        }
        switch (guiId) {
            case ApiaristBackpackGUI: 
            case LepidopteristBackpackGUI: {
                ItemStack equipped = GuiHandlerStorage.getBackpackItem(player);
                if (equipped == null) {
                    return null;
                }
                ItemInventoryBackpackPaged inventory = new ItemInventoryBackpackPaged(player, 125, equipped, guiId);
                return new ContainerNaturalistBackpack(player, inventory, guiData);
            }
            case BackpackGUI: {
                ItemStack equipped = GuiHandlerStorage.getBackpackItem(player);
                if (equipped == null) {
                    return null;
                }
                return new ContainerBackpack(player, ContainerBackpack.Size.DEFAULT, equipped);
            }
            case BackpackT2GUI: {
                ItemStack equipped = GuiHandlerStorage.getBackpackItem(player);
                if (equipped == null) {
                    return null;
                }
                return new ContainerBackpack(player, ContainerBackpack.Size.T2, equipped);
            }
        }
        return null;
    }
}

