/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.EnumWoodType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.ForestryAPI;
import forestry.api.genetics.AlleleManager;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.ICrateRegistry;
import forestry.api.storage.StorageManager;
import forestry.arboriculture.GuiHandlerArboriculture;
import forestry.arboriculture.VillageHandlerArboriculture;
import forestry.arboriculture.WoodItemAccess;
import forestry.arboriculture.blocks.BlockArboricultureType;
import forestry.arboriculture.blocks.BlockRegistryArboriculture;
import forestry.arboriculture.commands.CommandTree;
import forestry.arboriculture.genetics.TreeBranchDefinition;
import forestry.arboriculture.genetics.TreeDefinition;
import forestry.arboriculture.genetics.TreeFactory;
import forestry.arboriculture.genetics.TreeHelper;
import forestry.arboriculture.genetics.TreeMutationFactory;
import forestry.arboriculture.genetics.TreekeepingMode;
import forestry.arboriculture.genetics.alleles.AlleleFruit;
import forestry.arboriculture.genetics.alleles.AlleleGrowth;
import forestry.arboriculture.genetics.alleles.AlleleLeafEffect;
import forestry.arboriculture.items.ItemRegistryArboriculture;
import forestry.arboriculture.network.PacketRegistryArboriculture;
import forestry.arboriculture.proxy.ProxyArboriculture;
import forestry.arboriculture.tiles.TileArboristChest;
import forestry.arboriculture.tiles.TileFruitPod;
import forestry.arboriculture.tiles.TileLeaves;
import forestry.arboriculture.tiles.TileSapling;
import forestry.arboriculture.tiles.TileWood;
import forestry.core.GuiHandlerBase;
import forestry.core.blocks.BlockCoreType;
import forestry.core.config.Config;
import forestry.core.fluids.Fluids;
import forestry.core.genetics.alleles.AllelePlantType;
import forestry.core.items.ItemFruit;
import forestry.core.network.IPacketRegistry;
import forestry.core.proxy.Proxies;
import forestry.core.recipes.RecipeUtil;
import forestry.core.tiles.MachineDefinition;
import forestry.factory.recipes.FabricatorRecipe;
import forestry.plugins.ForestryPlugin;
import forestry.plugins.Plugin;
import forestry.plugins.PluginCore;
import forestry.plugins.PluginManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;

@Plugin(pluginID="Arboriculture", name="Arboriculture", author="Binnie & SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.arboriculture.description")
public class PluginArboriculture
extends ForestryPlugin {
    @SidedProxy(clientSide="forestry.arboriculture.proxy.ProxyArboricultureClient", serverSide="forestry.arboriculture.proxy.ProxyArboriculture")
    public static ProxyArboriculture proxy;
    public static String treekeepingMode;
    public static int modelIdSaplings;
    public static int modelIdLeaves;
    public static int modelIdPods;
    public static final List<Block> validFences;
    public static ItemRegistryArboriculture items;
    public static BlockRegistryArboriculture blocks;

    @Override
    protected void setupAPI() {
        super.setupAPI();
        TreeManager.treeFactory = new TreeFactory();
        TreeManager.treeMutationFactory = new TreeMutationFactory();
        TreeManager.woodItemAccess = new WoodItemAccess();
        TreeManager.treeRoot = new TreeHelper();
        AlleleManager.alleleRegistry.registerSpeciesRoot(TreeManager.treeRoot);
        TreeManager.treeRoot.registerTreekeepingMode(TreekeepingMode.easy);
        TreeManager.treeRoot.registerTreekeepingMode(TreekeepingMode.normal);
        TreeManager.treeRoot.registerTreekeepingMode(TreekeepingMode.hard);
        TreeManager.treeRoot.registerTreekeepingMode(TreekeepingMode.hardcore);
        TreeManager.treeRoot.registerTreekeepingMode(TreekeepingMode.insane);
    }

    @Override
    protected void registerItemsAndBlocks() {
        items = new ItemRegistryArboriculture();
        blocks = new BlockRegistryArboriculture();
    }

    @Override
    public void preInit() {
        super.preInit();
        for (EnumWoodType woodType : EnumWoodType.VALUES) {
            WoodItemAccess.registerLog(PluginArboriculture.blocks.logs, woodType, false);
            WoodItemAccess.registerPlanks(PluginArboriculture.blocks.planks, woodType, false);
            WoodItemAccess.registerSlab((Block)PluginArboriculture.blocks.slabs, woodType, false);
            WoodItemAccess.registerFence((Block)PluginArboriculture.blocks.fences, woodType, false);
            WoodItemAccess.registerStairs((Block)PluginArboriculture.blocks.stairs, woodType, false);
            WoodItemAccess.registerLog(PluginArboriculture.blocks.logsFireproof, woodType, true);
            WoodItemAccess.registerPlanks(PluginArboriculture.blocks.planksFireproof, woodType, true);
            WoodItemAccess.registerSlab((Block)PluginArboriculture.blocks.slabsFireproof, woodType, true);
            WoodItemAccess.registerFence((Block)PluginArboriculture.blocks.fencesFireproof, woodType, true);
            WoodItemAccess.registerStairs((Block)PluginArboriculture.blocks.stairsFireproof, woodType, true);
        }
        MachineDefinition definitionChest = new MachineDefinition(BlockArboricultureType.ARBCHEST.ordinal(), "forestry.ArbChest", TileArboristChest.class, Proxies.render.getRenderChest("arbchest")).setBoundingBox(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9375f);
        PluginArboriculture.blocks.arboriculture.addDefinition(definitionChest);
        proxy.initializeRendering();
        validFences.add((Block)PluginArboriculture.blocks.fences);
        validFences.add((Block)PluginArboriculture.blocks.fencesFireproof);
        validFences.add(Blocks.fence);
        validFences.add(Blocks.fence_gate);
        validFences.add(Blocks.nether_brick_fence);
        PluginCore.rootCommand.addChildCommand(new CommandTree());
    }

    @Override
    public void doInit() {
        super.doInit();
        PluginArboriculture.createAlleles();
        TreeDefinition.initTrees();
        PluginArboriculture.registerErsatzGenomes();
        GameRegistry.registerTileEntity(TileSapling.class, (String)"forestry.Sapling");
        GameRegistry.registerTileEntity(TileLeaves.class, (String)"forestry.Leaves");
        GameRegistry.registerTileEntity(TileWood.class, (String)"forestry.Wood");
        GameRegistry.registerTileEntity(TileFruitPod.class, (String)"forestry.Pods");
        PluginArboriculture.blocks.arboriculture.init();
        if (Config.enableVillagers) {
            VillagerRegistry.instance().registerVillagerId(81);
            Proxies.render.registerVillagerSkin(81, "textures/entity/lumberjack.png");
            VillagerRegistry.instance().registerVillageTradeHandler(81, (VillagerRegistry.IVillageTradeHandler)new VillageHandlerArboriculture());
        }
    }

    @Override
    public void postInit() {
        super.postInit();
        PluginArboriculture.registerDungeonLoot();
    }

    @Override
    protected void registerCrates() {
        ICrateRegistry crateRegistry = StorageManager.crateRegistry;
        crateRegistry.registerCrate(ItemFruit.EnumFruit.CHERRY.getStack(), "cratedCherry");
        crateRegistry.registerCrate(ItemFruit.EnumFruit.WALNUT.getStack(), "cratedWalnut");
        crateRegistry.registerCrate(ItemFruit.EnumFruit.CHESTNUT.getStack(), "cratedChestnut");
        crateRegistry.registerCrate(ItemFruit.EnumFruit.LEMON.getStack(), "cratedLemon");
        crateRegistry.registerCrate(ItemFruit.EnumFruit.PLUM.getStack(), "cratedPlum");
        crateRegistry.registerCrate(ItemFruit.EnumFruit.PAPAYA.getStack(), "cratedPapaya");
        crateRegistry.registerCrate(ItemFruit.EnumFruit.DATES.getStack(), "cratedDates");
    }

    @Override
    protected void registerRecipes() {
        RecipeUtil.addSmelting(new ItemStack((Block)PluginArboriculture.blocks.logs, 1, Short.MAX_VALUE), new ItemStack(Items.coal, 1, 1), 0.15f);
        for (EnumWoodType woodType : EnumWoodType.VALUES) {
            ItemStack planks = TreeManager.woodItemAccess.getPlanks(woodType, false);
            ItemStack logs = TreeManager.woodItemAccess.getLog(woodType, false);
            ItemStack slabs = TreeManager.woodItemAccess.getSlab(woodType, false);
            ItemStack fences = TreeManager.woodItemAccess.getFence(woodType, false);
            ItemStack stairs = TreeManager.woodItemAccess.getStairs(woodType, false);
            ItemStack fireproofPlanks = TreeManager.woodItemAccess.getPlanks(woodType, true);
            ItemStack fireproofLogs = TreeManager.woodItemAccess.getLog(woodType, true);
            ItemStack fireproofSlabs = TreeManager.woodItemAccess.getSlab(woodType, true);
            ItemStack fireproofFences = TreeManager.woodItemAccess.getFence(woodType, true);
            ItemStack fireproofStairs = TreeManager.woodItemAccess.getStairs(woodType, true);
            planks.stackSize = 4;
            logs.stackSize = 1;
            RecipeUtil.addShapelessRecipe(planks.copy(), logs.copy());
            fireproofPlanks.stackSize = 4;
            fireproofLogs.stackSize = 1;
            RecipeUtil.addShapelessRecipe(fireproofPlanks.copy(), fireproofLogs.copy());
            slabs.stackSize = 6;
            planks.stackSize = 1;
            RecipeUtil.addPriorityRecipe(slabs.copy(), "###", Character.valueOf('#'), planks.copy());
            fireproofSlabs.stackSize = 6;
            fireproofPlanks.stackSize = 1;
            RecipeUtil.addPriorityRecipe(fireproofSlabs.copy(), "###", Character.valueOf('#'), fireproofPlanks.copy());
            fences.stackSize = 3;
            planks.stackSize = 1;
            RecipeUtil.addRecipe(fences.copy(), "#X#", "#X#", Character.valueOf('#'), planks.copy(), Character.valueOf('X'), "stickWood");
            fireproofFences.stackSize = 3;
            fireproofPlanks.stackSize = 1;
            RecipeUtil.addRecipe(fireproofFences.copy(), "#X#", "#X#", Character.valueOf('#'), fireproofPlanks.copy(), Character.valueOf('X'), "stickWood");
            stairs.stackSize = 4;
            planks.stackSize = 1;
            RecipeUtil.addPriorityRecipe(stairs.copy(), "#  ", "## ", "###", Character.valueOf('#'), planks.copy());
            fireproofStairs.stackSize = 4;
            fireproofPlanks.stackSize = 1;
            RecipeUtil.addPriorityRecipe(fireproofStairs.copy(), "#  ", "## ", "###", Character.valueOf('#'), fireproofPlanks.copy());
            if (!PluginManager.Module.FACTORY.isEnabled() || !PluginManager.Module.APICULTURE.isEnabled()) continue;
            logs.stackSize = 1;
            fireproofLogs.stackSize = 1;
            RecipeManagers.fabricatorManager.addRecipe(new FabricatorRecipe(null, Fluids.GLASS.getFluid(500), fireproofLogs.copy(), new Object[]{" # ", "#X#", " # ", Character.valueOf('#'), PluginCore.items.refractoryWax, Character.valueOf('X'), logs.copy()}));
            planks.stackSize = 1;
            fireproofPlanks.stackSize = 5;
            RecipeManagers.fabricatorManager.addRecipe(new FabricatorRecipe(null, Fluids.GLASS.getFluid(500), fireproofPlanks.copy(), new Object[]{"X#X", "#X#", "X#X", Character.valueOf('#'), PluginCore.items.refractoryWax, Character.valueOf('X'), planks.copy()}));
        }
        if (PluginManager.Module.FACTORY.isEnabled()) {
            RecipeManagers.carpenterManager.addRecipe(100, Fluids.WATER.getFluid(2000), null, PluginArboriculture.items.treealyzer.getItemStack(), "X#X", "X#X", "RDR", Character.valueOf('#'), "paneGlass", Character.valueOf('X'), "ingotCopper", Character.valueOf('R'), "dustRedstone", Character.valueOf('D'), "gemDiamond");
            int seedOilMultiplier = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.seed");
            int juiceMultiplier = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.apple");
            int mulchMultiplier = ForestryAPI.activeMode.getIntegerSetting("squeezer.mulch.apple");
            ItemStack mulch = new ItemStack((Item)PluginCore.items.mulch);
            RecipeManagers.squeezerManager.addRecipe(20, new ItemStack[]{ItemFruit.EnumFruit.CHERRY.getStack()}, Fluids.SEEDOIL.getFluid(5 * seedOilMultiplier), mulch, 5);
            RecipeManagers.squeezerManager.addRecipe(60, new ItemStack[]{ItemFruit.EnumFruit.WALNUT.getStack()}, Fluids.SEEDOIL.getFluid(18 * seedOilMultiplier), mulch, 5);
            RecipeManagers.squeezerManager.addRecipe(70, new ItemStack[]{ItemFruit.EnumFruit.CHESTNUT.getStack()}, Fluids.SEEDOIL.getFluid(22 * seedOilMultiplier), mulch, 2);
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{ItemFruit.EnumFruit.LEMON.getStack()}, Fluids.JUICE.getFluid(juiceMultiplier * 2), mulch, (int)Math.floor((float)mulchMultiplier * 0.5f));
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{ItemFruit.EnumFruit.PLUM.getStack()}, Fluids.JUICE.getFluid((int)Math.floor((float)juiceMultiplier * 0.5f)), mulch, mulchMultiplier * 3);
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{ItemFruit.EnumFruit.PAPAYA.getStack()}, Fluids.JUICE.getFluid(juiceMultiplier * 3), mulch, (int)Math.floor((float)mulchMultiplier * 0.5f));
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{ItemFruit.EnumFruit.DATES.getStack()}, Fluids.JUICE.getFluid((int)Math.floor((double)juiceMultiplier * 0.25)), mulch, mulchMultiplier);
            RecipeUtil.addFermenterRecipes(PluginArboriculture.items.sapling.getItemStack(), ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.sapling"), Fluids.BIOMASS);
        }
        RecipeUtil.addRecipe(PluginArboriculture.items.grafter.getItemStack(), "  B", " # ", "#  ", Character.valueOf('B'), "ingotBronze", Character.valueOf('#'), "stickWood");
        RecipeUtil.addRecipe(PluginCore.blocks.core.get(BlockCoreType.ANALYZER, 1), new Object[]{"XTX", " Y ", "X X", Character.valueOf('Y'), PluginCore.items.sturdyCasing, Character.valueOf('T'), PluginArboriculture.items.treealyzer, Character.valueOf('X'), "ingotBronze"});
        RecipeUtil.addRecipe(PluginArboriculture.blocks.arboriculture.get(BlockArboricultureType.ARBCHEST, 1), " # ", "XYX", "XXX", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), "treeSapling", Character.valueOf('Y'), "chestWood");
    }

    private static void createAlleles() {
        TreeBranchDefinition.createAlleles();
        AlleleFruit.createAlleles();
        AlleleGrowth.createAlleles();
        AlleleLeafEffect.createAlleles();
        AllelePlantType.createAlleles();
    }

    private static void registerErsatzGenomes() {
        AlleleManager.ersatzSpecimen.put(new ItemStack((Block)Blocks.leaves, 1, 0), TreeDefinition.Oak.getIndividual());
        AlleleManager.ersatzSpecimen.put(new ItemStack((Block)Blocks.leaves, 1, 1), TreeDefinition.Spruce.getIndividual());
        AlleleManager.ersatzSpecimen.put(new ItemStack((Block)Blocks.leaves, 1, 2), TreeDefinition.Birch.getIndividual());
        AlleleManager.ersatzSpecimen.put(new ItemStack((Block)Blocks.leaves, 1, 3), TreeDefinition.Jungle.getIndividual());
        AlleleManager.ersatzSpecimen.put(new ItemStack((Block)Blocks.leaves2, 1, 0), TreeDefinition.Acacia.getIndividual());
        AlleleManager.ersatzSpecimen.put(new ItemStack((Block)Blocks.leaves2, 1, 1), TreeDefinition.DarkOak.getIndividual());
        AlleleManager.ersatzSaplings.put(new ItemStack(Blocks.sapling, 1, 0), TreeDefinition.Oak.getIndividual());
        AlleleManager.ersatzSaplings.put(new ItemStack(Blocks.sapling, 1, 1), TreeDefinition.Spruce.getIndividual());
        AlleleManager.ersatzSaplings.put(new ItemStack(Blocks.sapling, 1, 2), TreeDefinition.Birch.getIndividual());
        AlleleManager.ersatzSaplings.put(new ItemStack(Blocks.sapling, 1, 3), TreeDefinition.Jungle.getIndividual());
        AlleleManager.ersatzSaplings.put(new ItemStack(Blocks.sapling, 1, 4), TreeDefinition.Acacia.getIndividual());
        AlleleManager.ersatzSaplings.put(new ItemStack(Blocks.sapling, 1, 5), TreeDefinition.DarkOak.getIndividual());
    }

    @Override
    public GuiHandlerBase getGuiHandler() {
        return new GuiHandlerArboriculture();
    }

    @Override
    public IFuelHandler getFuelHandler() {
        return new FuelHandler();
    }

    @Override
    public IPacketRegistry getPacketRegistry() {
        return new PacketRegistryArboriculture();
    }

    @Override
    public boolean processIMCMessage(FMLInterModComms.IMCMessage message) {
        if (message.key.equals("add-fence-block") && message.isStringMessage()) {
            Block block = (Block)GameData.getBlockRegistry().getRaw(message.getStringValue());
            if (block != null && block != Blocks.air) {
                validFences.add(block);
            } else {
                PluginArboriculture.logInvalidIMCMessage(message);
            }
            return true;
        }
        return super.processIMCMessage(message);
    }

    private static void registerDungeonLoot() {
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(PluginArboriculture.items.grafter.getItemStack(), 1, 1, 8));
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(TreeDefinition.Oak.getMemberStack(EnumGermlingType.SAPLING), 2, 3, 6));
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(TreeDefinition.Spruce.getMemberStack(EnumGermlingType.SAPLING), 2, 3, 6));
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(TreeDefinition.Birch.getMemberStack(EnumGermlingType.SAPLING), 2, 3, 6));
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(TreeDefinition.Larch.getMemberStack(EnumGermlingType.SAPLING), 1, 2, 4));
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(TreeDefinition.Lime.getMemberStack(EnumGermlingType.SAPLING), 1, 2, 4));
        if (PluginManager.Module.APICULTURE.isEnabled()) {
            ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(TreeDefinition.Oak.getMemberStack(EnumGermlingType.POLLEN), 2, 3, 4));
            ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(TreeDefinition.Spruce.getMemberStack(EnumGermlingType.POLLEN), 2, 3, 4));
            ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(TreeDefinition.Birch.getMemberStack(EnumGermlingType.POLLEN), 2, 3, 4));
            ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(TreeDefinition.Larch.getMemberStack(EnumGermlingType.POLLEN), 1, 2, 3));
            ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(TreeDefinition.Lime.getMemberStack(EnumGermlingType.POLLEN), 1, 2, 3));
        }
    }

    static {
        treekeepingMode = "NORMAL";
        validFences = new ArrayList<Block>();
    }

    private static class FuelHandler
    implements IFuelHandler {
        private FuelHandler() {
        }

        public int getBurnTime(ItemStack fuel) {
            Item item = fuel.getItem();
            if (PluginArboriculture.items.sapling == item) {
                return 100;
            }
            if (PluginArboriculture.blocks.slabs == Block.getBlockFromItem((Item)item)) {
                return 150;
            }
            return 0;
        }
    }
}

