/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.inventory;

import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.AlleleManager;
import forestry.core.fluids.FluidHelper;
import forestry.core.inventory.InventoryAdapterTile;
import forestry.core.tiles.TileAnalyzer;
import forestry.core.utils.GeneticsUtil;
import forestry.core.utils.SlotUtil;
import forestry.plugins.PluginManager;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;

public class InventoryAnalyzer
extends InventoryAdapterTile<TileAnalyzer> {
    public static final short SLOT_ANALYZE = 0;
    public static final short SLOT_CAN = 1;
    public static final short SLOT_INPUT_1 = 2;
    public static final short SLOT_INPUT_COUNT = 6;
    public static final short SLOT_OUTPUT_1 = 8;
    public static final short SLOT_OUTPUT_COUNT = 4;

    public InventoryAnalyzer(TileAnalyzer analyzer) {
        super(analyzer, 12, "Items");
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        if (SlotUtil.isSlotInRange(slotIndex, 2, 6)) {
            return AlleleManager.alleleRegistry.isIndividual(itemStack) || GeneticsUtil.getGeneticEquivalent(itemStack) != null;
        }
        if (slotIndex == 1) {
            Fluid fluid = FluidHelper.getFluidInContainer(itemStack);
            return ((TileAnalyzer)this.tile).getTankManager().accepts(fluid);
        }
        return false;
    }

    @Override
    public boolean canExtractItem(int slotIndex, ItemStack stack, int side) {
        return SlotUtil.isSlotInRange(slotIndex, 8, 4);
    }

    @Override
    public void setInventorySlotContents(int slotId, ItemStack itemStack) {
        ItemStack ersatz;
        if (PluginManager.Module.ARBORICULTURE.isEnabled() && !TreeManager.treeRoot.isMember(itemStack) && (ersatz = GeneticsUtil.convertSaplingToGeneticEquivalent(itemStack)) != null) {
            itemStack = ersatz;
        }
        super.setInventorySlotContents(slotId, itemStack);
    }
}

