/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import buildcraft.api.fuels.BuildcraftFuelRegistry;
import buildcraft.api.fuels.ICoolant;
import buildcraft.api.fuels.ICoolantManager;
import cpw.mods.fml.common.Optional;
import forestry.api.core.ForestryAPI;
import forestry.core.fluids.Fluids;
import forestry.core.utils.ModUtil;
import forestry.plugins.ForestryPlugin;
import forestry.plugins.Plugin;
import net.minecraftforge.fluids.Fluid;

@Plugin(pluginID="BC6|Fuels", name="BuildCraft 6 Fuels", author="mezz", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.buildcraft6.description")
public class PluginBuildCraftFuels
extends ForestryPlugin {
    @Override
    public boolean isAvailable() {
        return ModUtil.isAPILoaded("buildcraft.api.fuels", "[2.0, 3.0)");
    }

    @Override
    public String getFailMessage() {
        return "Compatible BuildCraftAPI|fuels version not found";
    }

    @Override
    @Optional.Method(modid="BuildCraftAPI|fuels")
    public void doInit() {
        ICoolantManager coolantManager = BuildcraftFuelRegistry.coolant;
        ICoolant waterCoolant = coolantManager.getCoolant(Fluids.WATER.getFluid());
        float waterCooling = waterCoolant.getDegreesCoolingPerMB(100.0f);
        coolantManager.addCoolant(Fluids.ICE.getFluid(), 6.0f * waterCooling);
        Fluid ethanol = Fluids.ETHANOL.getFluid();
        if (ethanol != null) {
            int ethanolPower = 40;
            int ethanolBurnTime = Math.round(15000.0f * ForestryAPI.activeMode.getFloatSetting("fuel.ethanol.combustion"));
            BuildcraftFuelRegistry.fuel.addFuel(ethanol, ethanolPower, ethanolBurnTime);
        }
    }
}

