/*
 * Decompiled with CFR 0.152.
 */
package forestry.food;

import forestry.api.food.IBeverageEffect;
import forestry.api.food.IInfuserManager;
import forestry.food.InfuserMixture;
import forestry.food.items.ItemBeverage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;

public class InfuserMixtureManager
implements IInfuserManager {
    private final List<InfuserMixture> mixtures = new ArrayList<InfuserMixture>();

    @Override
    public void addMixture(int meta, ItemStack ingredient, IBeverageEffect effect) {
        this.mixtures.add(new InfuserMixture(meta, ingredient, effect));
    }

    @Override
    public void addMixture(int meta, ItemStack[] ingredients, IBeverageEffect effect) {
        this.mixtures.add(new InfuserMixture(meta, ingredients, effect));
    }

    @Override
    public boolean isIngredient(ItemStack itemstack) {
        for (InfuserMixture ingredient : this.mixtures) {
            if (!ingredient.isIngredient(itemstack)) continue;
            return true;
        }
        return false;
    }

    private InfuserMixture[] getMatchingMixtures(ItemStack[] ingredients) {
        ArrayList<InfuserMixture> matches = new ArrayList<InfuserMixture>();
        for (InfuserMixture mixture : this.mixtures) {
            if (!mixture.matches(ingredients)) continue;
            matches.add(mixture);
        }
        return matches.toArray(new InfuserMixture[matches.size()]);
    }

    @Override
    public boolean hasMixtures(ItemStack[] ingredients) {
        return this.getMatchingMixtures(ingredients).length > 0;
    }

    @Override
    public ItemStack[] getRequired(ItemStack[] ingredients) {
        InfuserMixture[] mixtures = this.getMatchingMixtures(ingredients);
        ArrayList<ItemStack> required = new ArrayList<ItemStack>();
        for (InfuserMixture mixture : mixtures) {
            required.addAll(Arrays.asList(mixture.getIngredients()));
        }
        return required.toArray(new ItemStack[required.size()]);
    }

    @Override
    public ItemStack getSeasoned(ItemStack base, ItemStack[] ingredients) {
        InfuserMixture[] mixtures = this.getMatchingMixtures(ingredients);
        List<IBeverageEffect> effects = ItemBeverage.BeverageInfo.loadEffects(base);
        int weight = 0;
        int meta = 0;
        for (InfuserMixture mixture : mixtures) {
            effects.add(mixture.getEffect());
            if (mixture.getWeight() <= weight) continue;
            weight = mixture.getWeight();
            meta = mixture.getMeta();
        }
        ItemStack seasoned = base.copy();
        seasoned.setItemDamage(meta);
        ItemBeverage.BeverageInfo.saveEffects(seasoned, effects);
        return seasoned;
    }
}

