/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.farming.FarmDirection;
import forestry.api.farming.Farmables;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmable;
import forestry.core.blocks.BlockSoil;
import forestry.core.config.ForestryBlock;
import forestry.core.render.SpriteSheet;
import forestry.core.utils.vect.Vect;
import forestry.core.utils.vect.VectUtil;
import forestry.farming.logic.FarmLogicHomogeneous;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class FarmLogicArboreal
extends FarmLogicHomogeneous {
    private final HashMap<Vect, Integer> lastExtentsHarvest = new HashMap();

    public FarmLogicArboreal(IFarmHousing housing, ItemStack resource, ItemStack ground, Iterable<IFarmable> germlings) {
        super(housing, resource, ground, germlings);
    }

    public FarmLogicArboreal(IFarmHousing housing) {
        super(housing, new ItemStack(Blocks.dirt), ForestryBlock.soil.getItemStack(1, 0), (Iterable<IFarmable>)Farmables.farmables.get("farmArboreal"));
    }

    @Override
    public boolean isAcceptedSoil(ItemStack soil) {
        if (super.isAcceptedSoil(soil)) {
            return true;
        }
        Block block = BlockSoil.getBlockFromItem((Item)soil.getItem());
        if (!(block instanceof BlockSoil)) {
            return false;
        }
        BlockSoil blockSoil = (BlockSoil)block;
        return blockSoil.getTypeFromMeta(soil.getItemDamage()) == BlockSoil.SoilType.HUMUS;
    }

    @Override
    public String getName() {
        return "Managed Arboretum";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        return Blocks.sapling.getBlockTextureFromSide(0);
    }

    @Override
    public ResourceLocation getSpriteSheet() {
        return SpriteSheet.BLOCKS.getLocation();
    }

    @Override
    public int getFertilizerConsumption() {
        return 10;
    }

    @Override
    public int getWaterConsumption(float hydrationModifier) {
        return (int)(10.0f * hydrationModifier);
    }

    @Override
    public Collection<ItemStack> collect() {
        List products = this.produce;
        this.produce = this.collectEntityItems(true);
        return products;
    }

    @Override
    public Collection<ICrop> harvest(int x, int y, int z, FarmDirection direction, int extent) {
        int lastExtent;
        Vect start = new Vect(x, y, z);
        if (!this.lastExtentsHarvest.containsKey(start)) {
            this.lastExtentsHarvest.put(start, 0);
        }
        if ((lastExtent = this.lastExtentsHarvest.get(start).intValue()) > extent) {
            lastExtent = 0;
        }
        Vect position = this.translateWithOffset(x, y + 1, z, direction, lastExtent);
        Collection<ICrop> crops = this.getHarvestBlocks(position);
        this.lastExtentsHarvest.put(start, ++lastExtent);
        return crops;
    }

    private Collection<ICrop> getHarvestBlocks(Vect position) {
        World world = this.getWorld();
        HashSet<Vect> seen = new HashSet<Vect>();
        Stack<ICrop> crops = new Stack<ICrop>();
        IFarmable germling = null;
        for (IFarmable germl : this.germlings) {
            ICrop crop = germl.getCropAt(world, position.x, position.y, position.z);
            if (crop == null) continue;
            crops.push(crop);
            seen.add(position);
            germling = germl;
            break;
        }
        if (germling == null) {
            return crops;
        }
        ArrayList<Vect> candidates = this.processHarvestBlock(germling, crops, seen, position, position);
        ArrayList<Vect> temp = new ArrayList<Vect>();
        while (!candidates.isEmpty()) {
            for (Vect candidate : candidates) {
                temp.addAll(this.processHarvestBlock(germling, crops, seen, position, candidate));
            }
            candidates.clear();
            candidates.addAll(temp);
            temp.clear();
        }
        return crops;
    }

    private ArrayList<Vect> processHarvestBlock(IFarmable germling, Stack<ICrop> crops, Set<Vect> seen, Vect start, Vect position) {
        World world = this.getWorld();
        ArrayList<Vect> candidates = new ArrayList<Vect>();
        for (int x = -1; x < 2; ++x) {
            for (int y = -1; y < 2; ++y) {
                for (int z = -1; z < 2; ++z) {
                    ICrop crop;
                    Vect candidate = position.add(x, y, z);
                    if (candidate.equals(position) || Math.abs(candidate.x - start.x) > 10 || Math.abs(candidate.z - start.z) > 10 || seen.contains(candidate) || (crop = germling.getCropAt(world, candidate.x, candidate.y, candidate.z)) == null) continue;
                    crops.push(crop);
                    candidates.add(candidate);
                    seen.add(candidate);
                }
            }
        }
        return candidates;
    }

    @Override
    protected boolean maintainGermlings(int x, int ySaplings, int z, FarmDirection direction, int extent) {
        World world = this.getWorld();
        for (int i = 0; i < extent; ++i) {
            Vect soilBelowPosition;
            ItemStack soilBelow;
            Vect position = this.translateWithOffset(x, ySaplings, z, direction, i);
            if (!VectUtil.isAirBlock(world, position) || !this.isAcceptedSoil(soilBelow = VectUtil.getAsItemStack(world, soilBelowPosition = new Vect(position.x, position.y - 1, position.z)))) continue;
            return this.plantSapling(position);
        }
        return false;
    }

    private boolean plantSapling(Vect position) {
        World world = this.getWorld();
        Collections.shuffle(this.germlings);
        for (IFarmable candidate : this.germlings) {
            if (!this.housing.plantGermling(candidate, world, position.x, position.y, position.z)) continue;
            return true;
        }
        return false;
    }
}

