/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.BeeManager;
import forestry.apiculture.entities.EntityMinecartApiary;
import forestry.apiculture.entities.EntityMinecartBeehouse;
import forestry.apiculture.gui.ContainerAlveary;
import forestry.apiculture.gui.ContainerAlvearyHygroregulator;
import forestry.apiculture.gui.ContainerAlvearySieve;
import forestry.apiculture.gui.ContainerAlvearySwarmer;
import forestry.apiculture.gui.ContainerBeeHousing;
import forestry.apiculture.gui.ContainerHabitatLocator;
import forestry.apiculture.gui.ContainerImprinter;
import forestry.apiculture.gui.ContainerMinecartBeehouse;
import forestry.apiculture.gui.GuiAlveary;
import forestry.apiculture.gui.GuiAlvearyHygroregulator;
import forestry.apiculture.gui.GuiAlvearySieve;
import forestry.apiculture.gui.GuiAlvearySwarmer;
import forestry.apiculture.gui.GuiBeeHousing;
import forestry.apiculture.gui.GuiBeealyzer;
import forestry.apiculture.gui.GuiHabitatLocator;
import forestry.apiculture.gui.GuiImprinter;
import forestry.apiculture.inventory.ItemInventoryBeealyzer;
import forestry.apiculture.inventory.ItemInventoryHabitatLocator;
import forestry.apiculture.inventory.ItemInventoryImprinter;
import forestry.apiculture.multiblock.TileAlvearyHygroregulator;
import forestry.apiculture.multiblock.TileAlvearyPlain;
import forestry.apiculture.multiblock.TileAlvearySieve;
import forestry.apiculture.multiblock.TileAlvearySwarmer;
import forestry.apiculture.tiles.TileApiary;
import forestry.apiculture.tiles.TileBeehouse;
import forestry.core.GuiHandlerBase;
import forestry.core.gui.ContainerAlyzer;
import forestry.core.network.GuiId;
import forestry.core.tiles.TileUtil;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class GuiHandlerApiculture
extends GuiHandlerBase {
    @Override
    @SideOnly(value=Side.CLIENT)
    public Gui getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        int cleanId = GuiHandlerApiculture.decodeGuiID(id);
        int guiData = GuiHandlerApiculture.decodeGuiData(id);
        if (cleanId >= GuiId.values().length) {
            return null;
        }
        switch (GuiId.values()[cleanId]) {
            case AlvearyGUI: {
                return new GuiAlveary(player.inventory, TileUtil.getTile((IBlockAccess)world, x, y, z, TileAlvearyPlain.class));
            }
            case AlvearySieveGUI: {
                return new GuiAlvearySieve(player.inventory, TileUtil.getTile((IBlockAccess)world, x, y, z, TileAlvearySieve.class));
            }
            case AlvearySwarmerGUI: {
                return new GuiAlvearySwarmer(player.inventory, TileUtil.getTile((IBlockAccess)world, x, y, z, TileAlvearySwarmer.class));
            }
            case ApiaristChestGUI: {
                return this.getNaturalistChestGui(BeeManager.beeRoot, player, world, x, y, z, guiData);
            }
            case ApiaryGUI: {
                TileApiary tileApiary = TileUtil.getTile((IBlockAccess)world, x, y, z, TileApiary.class);
                ContainerBeeHousing container = new ContainerBeeHousing(player.inventory, tileApiary, true);
                return new GuiBeeHousing<ContainerBeeHousing>(tileApiary, container, GuiBeeHousing.Icon.APIARY);
            }
            case BeealyzerGUI: {
                ItemStack equipped = player.getCurrentEquippedItem();
                if (equipped == null) {
                    return null;
                }
                return new GuiBeealyzer(player, new ItemInventoryBeealyzer(player, equipped));
            }
            case BeehouseGUI: {
                TileBeehouse tileBeehouse = TileUtil.getTile((IBlockAccess)world, x, y, z, TileBeehouse.class);
                ContainerBeeHousing container = new ContainerBeeHousing(player.inventory, tileBeehouse, false);
                return new GuiBeeHousing<ContainerBeeHousing>(tileBeehouse, container, GuiBeeHousing.Icon.BEE_HOUSE);
            }
            case MinecartBeehouseGUI: {
                Entity entity = world.getEntityByID(x);
                if (!(entity instanceof EntityMinecartBeehouse)) {
                    return null;
                }
                EntityMinecartBeehouse beeCart = (EntityMinecartBeehouse)entity;
                ContainerMinecartBeehouse container = new ContainerMinecartBeehouse(player.inventory, beeCart, false);
                return new GuiBeeHousing<ContainerMinecartBeehouse>(beeCart, container, GuiBeeHousing.Icon.BEE_HOUSE);
            }
            case MinecartApiaryGUI: {
                Entity entity = world.getEntityByID(x);
                if (!(entity instanceof EntityMinecartApiary)) {
                    return null;
                }
                EntityMinecartApiary beeCart = (EntityMinecartApiary)entity;
                ContainerMinecartBeehouse container = new ContainerMinecartBeehouse(player.inventory, beeCart, true);
                return new GuiBeeHousing<ContainerMinecartBeehouse>(beeCart, container, GuiBeeHousing.Icon.APIARY);
            }
            case HabitatLocatorGUI: {
                ItemStack equipped = player.getCurrentEquippedItem();
                if (equipped == null) {
                    return null;
                }
                return new GuiHabitatLocator(player, new ItemInventoryHabitatLocator(player, equipped));
            }
            case HygroregulatorGUI: {
                return new GuiAlvearyHygroregulator(player.inventory, TileUtil.getTile((IBlockAccess)world, x, y, z, TileAlvearyHygroregulator.class));
            }
            case ImprinterGUI: {
                ItemStack equipped = player.getCurrentEquippedItem();
                if (equipped == null) {
                    return null;
                }
                return new GuiImprinter(player.inventory, new ItemInventoryImprinter(player, equipped));
            }
        }
        return null;
    }

    @Override
    public Container getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        int cleanId = GuiHandlerApiculture.decodeGuiID(id);
        int guiData = GuiHandlerApiculture.decodeGuiData(id);
        if (cleanId >= GuiId.values().length) {
            return null;
        }
        switch (GuiId.values()[cleanId]) {
            case AlvearyGUI: {
                GuiHandlerApiculture.synchApiaristTracker(world, player);
                return new ContainerAlveary(player.inventory, TileUtil.getTile((IBlockAccess)world, x, y, z, TileAlvearyPlain.class));
            }
            case AlvearySieveGUI: {
                return new ContainerAlvearySieve(player.inventory, TileUtil.getTile((IBlockAccess)world, x, y, z, TileAlvearySieve.class));
            }
            case AlvearySwarmerGUI: {
                return new ContainerAlvearySwarmer(player.inventory, TileUtil.getTile((IBlockAccess)world, x, y, z, TileAlvearySwarmer.class));
            }
            case ApiaristChestGUI: {
                return this.getNaturalistChestContainer(BeeManager.beeRoot, player, world, x, y, z, guiData);
            }
            case ApiaryGUI: {
                GuiHandlerApiculture.synchApiaristTracker(world, player);
                return new ContainerBeeHousing(player.inventory, TileUtil.getTile((IBlockAccess)world, x, y, z, TileApiary.class), true);
            }
            case BeealyzerGUI: {
                ItemStack equipped = player.getCurrentEquippedItem();
                if (equipped == null) {
                    return null;
                }
                GuiHandlerApiculture.synchApiaristTracker(world, player);
                return new ContainerAlyzer(new ItemInventoryBeealyzer(player, equipped), player);
            }
            case BeehouseGUI: {
                GuiHandlerApiculture.synchApiaristTracker(world, player);
                return new ContainerBeeHousing(player.inventory, TileUtil.getTile((IBlockAccess)world, x, y, z, TileBeehouse.class), false);
            }
            case MinecartBeehouseGUI: {
                Entity entity = world.getEntityByID(x);
                if (!(entity instanceof EntityMinecartBeehouse)) {
                    return null;
                }
                GuiHandlerApiculture.synchApiaristTracker(world, player);
                return new ContainerMinecartBeehouse(player.inventory, (EntityMinecartBeehouse)entity, false);
            }
            case MinecartApiaryGUI: {
                Entity entity = world.getEntityByID(x);
                if (!(entity instanceof EntityMinecartApiary)) {
                    return null;
                }
                GuiHandlerApiculture.synchApiaristTracker(world, player);
                return new ContainerMinecartBeehouse(player.inventory, (EntityMinecartApiary)entity, true);
            }
            case HabitatLocatorGUI: {
                ItemStack equipped = player.getCurrentEquippedItem();
                if (equipped == null) {
                    return null;
                }
                return new ContainerHabitatLocator(player, new ItemInventoryHabitatLocator(player, equipped));
            }
            case HygroregulatorGUI: {
                return new ContainerAlvearyHygroregulator(player.inventory, TileUtil.getTile((IBlockAccess)world, x, y, z, TileAlvearyHygroregulator.class));
            }
            case ImprinterGUI: {
                GuiHandlerApiculture.synchApiaristTracker(world, player);
                ItemStack equipped = player.getCurrentEquippedItem();
                if (equipped == null) {
                    return null;
                }
                return new ContainerImprinter(player.inventory, new ItemInventoryImprinter(player, equipped));
            }
        }
        return null;
    }

    private static void synchApiaristTracker(World world, EntityPlayer player) {
        BeeManager.beeRoot.getBreedingTracker(world, player.getGameProfile()).synchToPlayer(player);
    }
}

