/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.tiles;

import forestry.api.circuits.ICircuitSocketType;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorLogic;
import forestry.api.core.IErrorLogicSource;
import forestry.api.multiblock.IFarmComponent;
import forestry.api.multiblock.IMultiblockController;
import forestry.core.access.EnumAccess;
import forestry.core.access.IAccessHandler;
import forestry.core.access.IRestrictedAccess;
import forestry.core.circuits.ISocketable;
import forestry.core.config.Config;
import forestry.core.gui.IHintSource;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.multiblock.MultiblockTileEntityForestry;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.GuiId;
import forestry.core.network.IStreamableGui;
import forestry.core.tiles.ITitled;
import forestry.farming.multiblock.MultiblockLogicFarm;
import forestry.farming.render.EnumFarmBlockTexture;
import java.io.IOException;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;

public abstract class TileFarm
extends MultiblockTileEntityForestry<MultiblockLogicFarm>
implements IFarmComponent,
IHintSource,
ISocketable,
IStreamableGui,
IErrorLogicSource,
IRestrictedAccess,
ITitled {
    public static final int TYPE_PLAIN = 0;
    public static final int TYPE_REVERSE = 1;
    public static final int TYPE_TOP = 2;
    public static final int TYPE_BAND = 3;
    public static final int TYPE_GEARS = 4;
    public static final int TYPE_HATCH = 5;
    public static final int TYPE_VALVE = 6;
    public static final int TYPE_CONTROL = 7;
    private EnumFarmBlockTexture farmBlockTexture = EnumFarmBlockTexture.BRICK_STONE;

    protected TileFarm() {
        super(new MultiblockLogicFarm());
    }

    @Override
    public void openGui(EntityPlayer player) {
        player.openGui(ForestryAPI.instance, GuiId.MultiFarmGUI.ordinal(), this.worldObj, this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public void onMachineAssembled(IMultiblockController multiblockController, ChunkCoordinates minCoord, ChunkCoordinates maxCoord) {
        this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord, this.zCoord, this.getBlockType());
        this.markDirty();
    }

    @Override
    public void onMachineBroken() {
        this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord, this.zCoord, this.getBlockType());
        this.markDirty();
    }

    @Override
    public IInventoryAdapter getInternalInventory() {
        return ((MultiblockLogicFarm)this.getMultiblockLogic()).getController().getInternalInventory();
    }

    @Override
    public boolean allowsAutomation() {
        return false;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.farmBlockTexture = EnumFarmBlockTexture.getFromCompound(nbttagcompound);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this.farmBlockTexture.saveToCompound(nbttagcompound);
    }

    public void setFarmBlockTexture(EnumFarmBlockTexture farmBlockTexture) {
        if (this.farmBlockTexture != farmBlockTexture) {
            this.farmBlockTexture = farmBlockTexture;
            this.worldObj.func_147479_m(this.xCoord, this.yCoord, this.zCoord);
        }
    }

    public EnumFarmBlockTexture getFarmBlockTexture() {
        return this.farmBlockTexture;
    }

    @Override
    protected void encodeDescriptionPacket(NBTTagCompound packetData) {
        super.encodeDescriptionPacket(packetData);
        this.farmBlockTexture.saveToCompound(packetData);
    }

    @Override
    protected void decodeDescriptionPacket(NBTTagCompound packetData) {
        super.decodeDescriptionPacket(packetData);
        EnumFarmBlockTexture farmBlockTexture = EnumFarmBlockTexture.getFromCompound(packetData);
        this.setFarmBlockTexture(farmBlockTexture);
    }

    @Override
    public List<String> getHints() {
        return Config.hints.get((Object)"farm");
    }

    @Override
    public int getSocketCount() {
        return ((MultiblockLogicFarm)this.getMultiblockLogic()).getController().getSocketCount();
    }

    @Override
    public ItemStack getSocket(int slot) {
        return ((MultiblockLogicFarm)this.getMultiblockLogic()).getController().getSocket(slot);
    }

    @Override
    public void setSocket(int slot, ItemStack stack) {
        ((MultiblockLogicFarm)this.getMultiblockLogic()).getController().setSocket(slot, stack);
    }

    @Override
    public ICircuitSocketType getSocketType() {
        return ((MultiblockLogicFarm)this.getMultiblockLogic()).getController().getSocketType();
    }

    @Override
    public void writeGuiData(DataOutputStreamForestry data) throws IOException {
        ((MultiblockLogicFarm)this.getMultiblockLogic()).getController().writeGuiData(data);
    }

    @Override
    public void readGuiData(DataInputStreamForestry data) throws IOException {
        ((MultiblockLogicFarm)this.getMultiblockLogic()).getController().readGuiData(data);
    }

    @Override
    public IErrorLogic getErrorLogic() {
        return ((MultiblockLogicFarm)this.getMultiblockLogic()).getController().getErrorLogic();
    }

    @Override
    public IAccessHandler getAccessHandler() {
        return ((MultiblockLogicFarm)this.getMultiblockLogic()).getController().getAccessHandler();
    }

    @Override
    public void onSwitchAccess(EnumAccess oldAccess, EnumAccess newAccess) {
        ((MultiblockLogicFarm)this.getMultiblockLogic()).getController().onSwitchAccess(oldAccess, newAccess);
    }

    @Override
    public String getUnlocalizedTitle() {
        return "for.gui.farm.title";
    }
}

