/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network;

import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.ForestryPacket;
import forestry.core.network.ILocatedPacket;
import forestry.core.network.IPacketId;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;

public abstract class PacketEntityUpdate
extends ForestryPacket
implements ILocatedPacket {
    private Entity entity;
    private int entityId;

    public PacketEntityUpdate() {
    }

    public PacketEntityUpdate(IPacketId id, Entity entity) {
        super(id);
        this.entity = entity;
    }

    @Override
    protected void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        data.writeVarInt(this.entity.getEntityId());
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.entityId = data.readVarInt();
    }

    public Entity getTarget(World world) {
        return world.getEntityByID(this.entityId);
    }

    @Override
    public int getPosX() {
        return (int)this.entity.posX;
    }

    @Override
    public int getPosY() {
        return (int)this.entity.posY;
    }

    @Override
    public int getPosZ() {
        return (int)this.entity.posZ;
    }
}

