/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.event.FMLInterModComms;
import forestry.api.core.ForestryAPI;
import forestry.core.fluids.Fluids;
import forestry.core.utils.ModUtil;
import forestry.plugins.ForestryPlugin;
import forestry.plugins.Plugin;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;

@Plugin(pluginID="EnderIO", name="EnderIO", author="mezz", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.enderIO.description")
public class PluginEnderIO
extends ForestryPlugin {
    private static final String EnderIO = "EnderIO";
    private static final String FLUID_FUEL_ADD = "fluidFuel:add";
    private static final String FLUID_COOLANT_ADD = "fluidCoolant:add";
    private static final String KEY_FLUID_NAME = "fluidName";
    private static final String KEY_POWER_PER_CYCLE = "powerPerCycle";
    private static final String KEY_TOTAL_BURN_TIME = "totalBurnTime";
    private static final String KEY_COOLING_PER_MB = "coolingPerMb";
    private static final float WATER_COOLING_PER_MB = 0.0023f;

    @Override
    public boolean isAvailable() {
        return ModUtil.isModLoaded(EnderIO);
    }

    @Override
    public String getFailMessage() {
        return "EnderIO not found";
    }

    @Override
    public void doInit() {
        Fluid crushedIce;
        Fluid ethanol = Fluids.ETHANOL.getFluid();
        if (ethanol != null) {
            int ethanolBurnTime = Math.round(15000.0f * ForestryAPI.activeMode.getFloatSetting("fuel.ethanol.combustion"));
            PluginEnderIO.addFuel(ethanol, 40, ethanolBurnTime);
        }
        if ((crushedIce = Fluids.ICE.getFluid()) != null) {
            PluginEnderIO.addCoolant(crushedIce, 6.0f);
        }
    }

    private static void addFuel(Fluid fluid, int powerPerCycle, int totalBurnTime) {
        NBTTagCompound fuelTag = new NBTTagCompound();
        fuelTag.setString(KEY_FLUID_NAME, fluid.getName());
        fuelTag.setInteger(KEY_POWER_PER_CYCLE, powerPerCycle);
        fuelTag.setInteger(KEY_TOTAL_BURN_TIME, totalBurnTime);
        FMLInterModComms.sendMessage((String)EnderIO, (String)FLUID_FUEL_ADD, (NBTTagCompound)fuelTag);
    }

    private static void addCoolant(Fluid fluid, float coolingMultiplier) {
        float coolingPerMb = coolingMultiplier * 0.0023f;
        NBTTagCompound coolantTag = new NBTTagCompound();
        coolantTag.setString(KEY_FLUID_NAME, fluid.getName());
        coolantTag.setFloat(KEY_COOLING_PER_MB, coolingPerMb);
        FMLInterModComms.sendMessage((String)EnderIO, (String)FLUID_COOLANT_ADD, (NBTTagCompound)coolantTag);
    }
}

