/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.tiles;

import forestry.core.tiles.TemperatureState;
import forestry.core.tiles.TileEngine;
import forestry.core.utils.DamageSourceForestry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.util.FakePlayer;

public class TileEngineClockwork
extends TileEngine {
    private static final float WIND_EXHAUSTION = 0.05f;
    private static final float WIND_TENSION_BASE = 0.5f;
    private static final int WIND_DELAY = 10;
    private static final int ENGINE_CLOCKWORK_HEAT_MAX = 300000;
    private static final int ENGINE_CLOCKWORK_ENERGY_PER_CYCLE = 2;
    private static final float ENGINE_CLOCKWORK_WIND_MAX = 8.0f;
    private static final DamageSourceForestry damageSourceEngineClockwork = new DamageSourceForestry("engine.clockwork");
    private float tension = 0.0f;
    private short delay = 0;

    public TileEngineClockwork() {
        super(null, null, 300000, 10000);
    }

    @Override
    public void openGui(EntityPlayer player) {
        if (!(player instanceof EntityPlayerMP)) {
            return;
        }
        if (player instanceof FakePlayer) {
            return;
        }
        if (this.tension <= 0.0f) {
            this.tension = 0.5f;
        } else if (this.tension < 8.5f) {
            this.tension += (8.5f - this.tension) / 8.5f * 0.5f;
        } else {
            return;
        }
        player.addExhaustion(0.05f);
        if ((double)this.tension > 8.05) {
            player.attackEntityFrom((DamageSource)damageSourceEngineClockwork, 6.0f);
        }
        this.tension = this.tension > 8.5f ? 8.5f : this.tension;
        this.delay = (short)10;
        this.setNeedsNetworkUpdate();
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.tension = nbttagcompound.getFloat("Wound");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.setFloat("Wound", this.tension);
    }

    @Override
    public boolean isRedstoneActivated() {
        return true;
    }

    @Override
    public int dissipateHeat() {
        return 0;
    }

    @Override
    public int generateHeat() {
        return 0;
    }

    @Override
    public boolean mayBurn() {
        return true;
    }

    @Override
    public void burn() {
        this.heat = (int)(this.tension * 10000.0f);
        if (this.delay > 0) {
            this.delay = (short)(this.delay - 1);
            return;
        }
        if (!this.isBurning()) {
            return;
        }
        this.tension = this.tension > 0.01f ? (this.tension *= 0.9995f) : 0.0f;
        this.energyManager.generateEnergy(2 * (int)this.tension);
    }

    @Override
    protected boolean isBurning() {
        return this.tension > 0.0f;
    }

    @Override
    public TemperatureState getTemperatureState() {
        TemperatureState state = TemperatureState.getState(this.heat / 10000, 8.0);
        if (state == TemperatureState.MELTING) {
            state = TemperatureState.OVERHEATING;
        }
        return state;
    }

    @Override
    public float getPistonSpeed() {
        if (this.delay > 0) {
            return 0.0f;
        }
        float fromClockwork = this.tension / 8.0f * 0.08f;
        fromClockwork = (float)Math.round(fromClockwork * 100.0f) / 100.0f;
        return fromClockwork;
    }

    @Override
    public void getGUINetworkData(int i, int j) {
    }

    @Override
    public void sendGUINetworkData(Container containerEngine, ICrafting iCrafting) {
    }
}

