/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.inventory;

import com.google.common.collect.ImmutableSet;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBee;
import forestry.api.core.IErrorSource;
import forestry.api.core.IErrorState;
import forestry.apiculture.items.HabitatLocatorLogic;
import forestry.apiculture.items.ItemHabitatLocator;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.errors.EnumErrorCode;
import forestry.core.gui.IHintSource;
import forestry.core.inventory.ItemInventory;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.BiomeGenBase;

public class ItemInventoryHabitatLocator
extends ItemInventory
implements IErrorSource,
IHintSource {
    private static final short SLOT_ENERGY = 2;
    private static final short SLOT_SPECIMEN = 0;
    private static final short SLOT_ANALYZED = 1;
    private final HabitatLocatorLogic locatorLogic;

    public ItemInventoryHabitatLocator(EntityPlayer player, ItemStack itemstack) {
        super(player, 3, itemstack);
        ItemHabitatLocator habitatLocator = (ItemHabitatLocator)itemstack.getItem();
        this.locatorLogic = habitatLocator.getLocatorLogic();
    }

    private static boolean isEnergy(ItemStack itemstack) {
        if (itemstack == null || itemstack.stackSize <= 0) {
            return false;
        }
        return ForestryItem.honeyDrop.isItemEqual(itemstack) || ForestryItem.honeydew.isItemEqual(itemstack);
    }

    @Override
    public void onSlotClick(EntityPlayer player) {
        IBee bee;
        if (this.getStackInSlot(1) != null) {
            if (this.locatorLogic.isBiomeFound()) {
                return;
            }
        } else if (this.getStackInSlot(0) != null) {
            if (!ItemInventoryHabitatLocator.isEnergy(this.getStackInSlot(2))) {
                return;
            }
            this.decrStackSize(2, 1);
            this.setInventorySlotContents(1, this.getStackInSlot(0));
            this.setInventorySlotContents(0, null);
        }
        if ((bee = BeeManager.beeRoot.getMember(this.getStackInSlot(1))) == null) {
            return;
        }
        this.locatorLogic.startBiomeSearch(bee, player);
    }

    public Set<BiomeGenBase> getBiomesToSearch() {
        return this.locatorLogic.getTargetBiomes();
    }

    @Override
    public List<String> getHints() {
        return Config.hints.get((Object)"habitat.locator");
    }

    @Override
    public ImmutableSet<IErrorState> getErrorStates() {
        if (this.getStackInSlot(1) != null) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder errorStates = ImmutableSet.builder();
        ItemStack specimen = this.getStackInSlot(0);
        if (!BeeManager.beeRoot.isMember(specimen)) {
            errorStates.add((Object)EnumErrorCode.NO_SPECIMEN);
        }
        if (!ItemInventoryHabitatLocator.isEnergy(this.getStackInSlot(2))) {
            errorStates.add((Object)EnumErrorCode.NO_HONEY);
        }
        return errorStates.build();
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        if (slotIndex == 2) {
            Item item = itemStack.getItem();
            return item == ForestryItem.honeydew.item() || item == ForestryItem.honeyDrop.item();
        }
        if (slotIndex == 0) {
            return BeeManager.beeRoot.isMember(itemStack);
        }
        return false;
    }
}

