/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.CircuitSocketType;
import forestry.api.circuits.ICircuitBoard;
import forestry.api.circuits.ICircuitSocketType;
import forestry.api.core.IErrorLogic;
import forestry.api.recipes.ISqueezerRecipe;
import forestry.core.circuits.ISocketable;
import forestry.core.circuits.ISpeedUpgradable;
import forestry.core.errors.EnumErrorCode;
import forestry.core.fluids.TankManager;
import forestry.core.fluids.tanks.StandardTank;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.GuiId;
import forestry.core.render.TankRenderInfo;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.TilePowered;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.PlayerUtil;
import forestry.factory.inventory.InventorySqueezer;
import forestry.factory.recipes.SqueezerRecipeManager;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileSqueezer
extends TilePowered
implements ISocketable,
ISidedInventory,
ILiquidTankTile,
IFluidHandler,
ISpeedUpgradable {
    private static final int TICKS_PER_RECIPE_TIME = 1;
    private static final int ENERGY_PER_WORK_CYCLE = 2000;
    private static final int ENERGY_PER_RECIPE_TIME = 200;
    private final InventoryAdapter sockets = new InventoryAdapter(1, "sockets");
    private final TankManager tankManager;
    private final StandardTank productTank;
    private final InventorySqueezer inventory = new InventorySqueezer(this);
    private ISqueezerRecipe currentRecipe;

    public TileSqueezer() {
        super(GuiId.SqueezerGUI, "squeezer", 1100, 5000);
        this.setInternalInventory(this.inventory);
        this.productTank = new StandardTank(10000);
        this.productTank.tankMode = StandardTank.TankMode.OUTPUT;
        this.tankManager = new TankManager(this, this.productTank);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this.tankManager.writeToNBT(nbttagcompound);
        this.sockets.writeToNBT(nbttagcompound);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        ICircuitBoard chipset;
        super.readFromNBT(nbttagcompound);
        this.tankManager.readFromNBT(nbttagcompound);
        this.sockets.readFromNBT(nbttagcompound);
        ItemStack chip = this.sockets.getStackInSlot(0);
        if (chip != null && (chipset = ChipsetManager.circuitRegistry.getCircuitboard(chip)) != null) {
            chipset.onLoad(this);
        }
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        this.tankManager.writeData(data);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.tankManager.readData(data);
    }

    @Override
    public void writeGuiData(DataOutputStreamForestry data) throws IOException {
        super.writeGuiData(data);
        this.sockets.writeData(data);
    }

    @Override
    public void readGuiData(DataInputStreamForestry data) throws IOException {
        super.readGuiData(data);
        this.sockets.readData(data);
    }

    @Override
    public void updateServerSide() {
        super.updateServerSide();
        if (this.updateOnInterval(20)) {
            this.inventory.fillContainers(this.productTank.getFluid(), this.tankManager);
        }
    }

    @Override
    public boolean workCycle() {
        EntityPlayer player = PlayerUtil.getPlayer(this.worldObj, this.getAccessHandler().getOwner());
        if (!this.inventory.removeResources(this.currentRecipe.getResources(), player)) {
            return false;
        }
        FluidStack resultFluid = this.currentRecipe.getFluidOutput();
        this.productTank.fill(resultFluid, true);
        if (this.currentRecipe.getRemnants() != null && this.worldObj.rand.nextFloat() < this.currentRecipe.getRemnantsChance()) {
            ItemStack remnant = this.currentRecipe.getRemnants().copy();
            this.inventory.addRemnant(remnant, true);
        }
        return true;
    }

    private boolean checkRecipe() {
        ISqueezerRecipe matchingRecipe = null;
        if (this.inventory.hasResources()) {
            ItemStack[] resources = this.inventory.getResources();
            matchingRecipe = this.currentRecipe != null && ItemStackUtil.containsSets(this.currentRecipe.getResources(), resources, true, false) > 0 ? this.currentRecipe : SqueezerRecipeManager.findMatchingRecipe(resources);
        }
        if (this.currentRecipe != matchingRecipe) {
            this.currentRecipe = matchingRecipe;
            if (this.currentRecipe != null) {
                int recipeTime = this.currentRecipe.getProcessingTime();
                this.setTicksPerWorkCycle(recipeTime * 1);
                this.setEnergyPerWorkCycle(recipeTime * 200);
            }
        }
        this.getErrorLogic().setCondition(this.currentRecipe == null, EnumErrorCode.NO_RECIPE);
        return this.currentRecipe != null;
    }

    @Override
    public boolean hasWork() {
        this.checkRecipe();
        boolean hasResources = this.inventory.hasResources();
        boolean hasRecipe = true;
        boolean canFill = true;
        boolean canAdd = true;
        if (hasResources) {
            boolean bl = hasRecipe = this.currentRecipe != null;
            if (hasRecipe) {
                FluidStack resultFluid = this.currentRecipe.getFluidOutput();
                canFill = this.productTank.canFill(resultFluid);
                if (this.currentRecipe.getRemnants() != null) {
                    canAdd = this.inventory.addRemnant(this.currentRecipe.getRemnants(), false);
                }
            }
        }
        IErrorLogic errorLogic = this.getErrorLogic();
        errorLogic.setCondition(!hasResources, EnumErrorCode.NO_RESOURCE);
        errorLogic.setCondition(!hasRecipe, EnumErrorCode.NO_RECIPE);
        errorLogic.setCondition(!canFill, EnumErrorCode.NO_SPACE_TANK);
        errorLogic.setCondition(!canAdd, EnumErrorCode.NO_SPACE_INVENTORY);
        return hasResources && hasRecipe && canFill && canAdd;
    }

    @Override
    public TankRenderInfo getProductTankInfo() {
        return new TankRenderInfo((IFluidTank)this.productTank);
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tankManager.fill(from, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.tankManager.drain(from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tankManager.drain(from, maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canFill(from, fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canDrain(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.tankManager.getTankInfo(from);
    }

    @Override
    public int getSocketCount() {
        return this.sockets.getSizeInventory();
    }

    @Override
    public ItemStack getSocket(int slot) {
        return this.sockets.getStackInSlot(slot);
    }

    @Override
    public void setSocket(int slot, ItemStack stack) {
        ICircuitBoard chipset;
        if (stack != null && !ChipsetManager.circuitRegistry.isChipset(stack)) {
            return;
        }
        if (this.sockets.getStackInSlot(slot) != null && ChipsetManager.circuitRegistry.isChipset(this.sockets.getStackInSlot(slot)) && (chipset = ChipsetManager.circuitRegistry.getCircuitboard(this.sockets.getStackInSlot(slot))) != null) {
            chipset.onRemoval(this);
        }
        this.sockets.setInventorySlotContents(slot, stack);
        if (stack == null) {
            return;
        }
        chipset = ChipsetManager.circuitRegistry.getCircuitboard(stack);
        if (chipset != null) {
            chipset.onInsertion(this);
        }
    }

    @Override
    public ICircuitSocketType getSocketType() {
        return CircuitSocketType.MACHINE;
    }
}

