/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.core.GuiHandlerBase;
import forestry.core.network.GuiId;
import forestry.core.network.PacketSocketUpdate;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.TileUtil;
import forestry.energy.gui.ContainerEngineBiogas;
import forestry.energy.gui.ContainerEngineElectric;
import forestry.energy.gui.ContainerEnginePeat;
import forestry.energy.gui.ContainerGenerator;
import forestry.energy.gui.GuiEngineBiogas;
import forestry.energy.gui.GuiEngineElectric;
import forestry.energy.gui.GuiEnginePeat;
import forestry.energy.gui.GuiGenerator;
import forestry.energy.tiles.TileEngineBiogas;
import forestry.energy.tiles.TileEngineElectric;
import forestry.energy.tiles.TileEnginePeat;
import forestry.energy.tiles.TileGenerator;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class GuiHandlerEnergy
extends GuiHandlerBase {
    @Override
    @SideOnly(value=Side.CLIENT)
    public Gui getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        if (id >= GuiId.values().length) {
            return null;
        }
        switch (GuiId.values()[id]) {
            case EngineBiogasGUI: {
                return new GuiEngineBiogas(player.inventory, TileUtil.getTile((IBlockAccess)world, x, y, z, TileEngineBiogas.class));
            }
            case EnginePeatGUI: {
                return new GuiEnginePeat(player.inventory, TileUtil.getTile((IBlockAccess)world, x, y, z, TileEnginePeat.class));
            }
            case EngineElectricGUI: {
                return new GuiEngineElectric(player.inventory, TileUtil.getTile((IBlockAccess)world, x, y, z, TileEngineElectric.class));
            }
            case GeneratorGUI: {
                return new GuiGenerator(player.inventory, TileUtil.getTile((IBlockAccess)world, x, y, z, TileGenerator.class));
            }
        }
        return null;
    }

    @Override
    public Container getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        if (id >= GuiId.values().length) {
            return null;
        }
        switch (GuiId.values()[id]) {
            case EngineBiogasGUI: {
                return new ContainerEngineBiogas(player.inventory, TileUtil.getTile((IBlockAccess)world, x, y, z, TileEngineBiogas.class));
            }
            case EnginePeatGUI: {
                return new ContainerEnginePeat(player.inventory, TileUtil.getTile((IBlockAccess)world, x, y, z, TileEnginePeat.class));
            }
            case EngineElectricGUI: {
                TileEngineElectric tile = TileUtil.getTile((IBlockAccess)world, x, y, z, TileEngineElectric.class);
                Proxies.net.sendToPlayer(new PacketSocketUpdate(tile), player);
                return new ContainerEngineElectric(player.inventory, tile);
            }
            case GeneratorGUI: {
                return new ContainerGenerator(player.inventory, TileUtil.getTile((IBlockAccess)world, x, y, z, TileGenerator.class));
            }
        }
        return null;
    }
}

