/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import codechicken.nei.VisiblityData;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.TaggedInventoryArea;
import cpw.mods.fml.common.Optional;
import forestry.api.core.IErrorLogicSource;
import forestry.api.core.IErrorSource;
import forestry.core.access.IRestrictedAccess;
import forestry.core.config.Config;
import forestry.core.gui.GuiUtil;
import forestry.core.gui.IHintSource;
import forestry.core.gui.TextLayoutHelper;
import forestry.core.gui.ledgers.ClimateLedger;
import forestry.core.gui.ledgers.HintLedger;
import forestry.core.gui.ledgers.LedgerManager;
import forestry.core.gui.ledgers.OwnerLedger;
import forestry.core.gui.ledgers.PowerLedger;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.proxy.Proxies;
import forestry.core.render.FontColour;
import forestry.core.tiles.IClimatised;
import forestry.core.tiles.IPowerHandler;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@Optional.Interface(iface="codechicken.nei.api.INEIGuiHandler", modid="NotEnoughItems")
public abstract class GuiForestry<C extends Container, I extends IInventory>
extends GuiContainer
implements INEIGuiHandler {
    protected final I inventory;
    protected final C container;
    public final ResourceLocation textureFile;
    protected final WidgetManager widgetManager = new WidgetManager(this);
    protected LedgerManager ledgerManager;
    protected TextLayoutHelper textLayout;
    protected FontColour fontColor;

    protected GuiForestry(String texture, C container, I inventory) {
        this(new ResourceLocation("forestry", texture), container, inventory);
    }

    protected GuiForestry(ResourceLocation texture, C container, I inventory) {
        super(container);
        this.textureFile = texture;
        this.inventory = inventory;
        this.container = container;
        this.fontColor = new FontColour(Proxies.render.getSelectedTexturePack());
        this.textLayout = new TextLayoutHelper(this, this.fontColor);
    }

    public void setWorldAndResolution(Minecraft minecraft, int width, int height) {
        super.setWorldAndResolution(minecraft, width, height);
        this.textLayout.setFontRendererObj(this.fontRendererObj);
    }

    public void initGui() {
        IHintSource hintSource;
        List<String> hints;
        super.initGui();
        int maxLedgerWidth = (this.width - this.xSize) / 2;
        this.ledgerManager = new LedgerManager(this, maxLedgerWidth);
        if (this.inventory instanceof IErrorSource) {
            this.ledgerManager.add((IErrorSource)this.inventory);
        }
        if (this.inventory instanceof IErrorLogicSource) {
            IErrorLogicSource errorLogicSource = (IErrorLogicSource)this.inventory;
            this.ledgerManager.add(errorLogicSource.getErrorLogic());
        }
        if (this.inventory instanceof IClimatised) {
            this.ledgerManager.add(new ClimateLedger(this.ledgerManager, (IClimatised)this.inventory));
        }
        if (Config.enableEnergyStat && this.inventory instanceof IPowerHandler && ((IPowerHandler)this.inventory).getEnergyManager().getMaxEnergyStored() > 0) {
            this.ledgerManager.add(new PowerLedger(this.ledgerManager, (IPowerHandler)this.inventory));
        }
        if (Config.enableHints && this.inventory instanceof IHintSource && (hints = (hintSource = (IHintSource)this.inventory).getHints()) != null && hints.size() > 0) {
            this.ledgerManager.add(new HintLedger(this.ledgerManager, hintSource));
        }
        if (this.inventory instanceof IRestrictedAccess) {
            this.ledgerManager.add(new OwnerLedger(this.ledgerManager, (IRestrictedAccess)this.inventory));
        }
    }

    public void onGuiClosed() {
        super.onGuiClosed();
        this.ledgerManager.onGuiClosed();
    }

    public FontColour getFontColor() {
        return this.fontColor;
    }

    public FontRenderer getFontRenderer() {
        return this.fontRendererObj;
    }

    protected void mouseClicked(int xPos, int yPos, int mouseButton) {
        super.mouseClicked(xPos, yPos, mouseButton);
        this.ledgerManager.handleMouseClicked(xPos, yPos, mouseButton);
        this.widgetManager.handleMouseClicked(xPos, yPos, mouseButton);
    }

    protected void mouseMovedOrUp(int mouseX, int mouseY, int eventType) {
        super.mouseMovedOrUp(mouseX, mouseY, eventType);
        this.widgetManager.handleMouseRelease(mouseX, mouseY, eventType);
    }

    protected void mouseClickMove(int mouseX, int mouseY, int mouseButton, long time) {
        this.widgetManager.handleMouseMove(mouseX, mouseY, mouseButton, time);
        super.mouseClickMove(mouseX, mouseY, mouseButton, time);
    }

    protected Slot getSlotAtPosition(int par1, int par2) {
        for (int k = 0; k < this.inventorySlots.inventorySlots.size(); ++k) {
            Slot slot = (Slot)this.inventorySlots.inventorySlots.get(k);
            if (!this.isMouseOverSlot(slot, par1, par2)) continue;
            return slot;
        }
        return null;
    }

    private boolean isMouseOverSlot(Slot par1Slot, int par2, int par3) {
        return this.func_146978_c(par1Slot.xDisplayPosition, par1Slot.yDisplayPosition, 16, 16, par2, par3);
    }

    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        GL11.glPushAttrib((int)8192);
        RenderHelper.enableGUIStandardItemLighting();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)240.0f, (float)240.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.ledgerManager.drawTooltips(mouseX, mouseY);
        InventoryPlayer playerInv = this.mc.thePlayer.inventory;
        if (playerInv.getItemStack() == null) {
            GuiUtil.drawToolTips(this, this.widgetManager.getWidgets(), mouseX, mouseY);
            GuiUtil.drawToolTips(this, this.buttonList, mouseX, mouseY);
            GuiUtil.drawToolTips(this, this.inventorySlots.inventorySlots, mouseX, mouseY);
        }
        GL11.glPopAttrib();
    }

    protected void drawGuiContainerBackgroundLayer(float f, int mouseX, int mouseY) {
        this.bindTexture(this.textureFile);
        int x = (this.width - this.xSize) / 2;
        int y = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(x, y, 0, 0, this.xSize, this.ySize);
        GL11.glPushAttrib((int)8192);
        RenderHelper.enableGUIStandardItemLighting();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.guiLeft, (float)this.guiTop, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)240.0f, (float)240.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawWidgets();
        GL11.glPopMatrix();
        GL11.glPopAttrib();
        this.bindTexture(this.textureFile);
    }

    protected void drawWidgets() {
        this.ledgerManager.drawLedgers();
        this.widgetManager.drawWidgets();
    }

    protected void bindTexture(ResourceLocation texturePath) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Proxies.render.bindTexture(texturePath);
    }

    public void setZLevel(float level) {
        this.zLevel = level;
    }

    public static RenderItem getItemRenderer() {
        return itemRender;
    }

    public int getSizeX() {
        return this.xSize;
    }

    public int getSizeY() {
        return this.ySize;
    }

    public int getGuiLeft() {
        return this.guiLeft;
    }

    public int getGuiTop() {
        return this.guiTop;
    }

    public void drawGradientRect(int par1, int par2, int par3, int par4, int par5, int par6) {
        super.drawGradientRect(par1, par2, par3, par4, par5, par6);
    }

    @Optional.Method(modid="NotEnoughItems")
    public VisiblityData modifyVisiblity(GuiContainer gui, VisiblityData currentVisibility) {
        return null;
    }

    @Optional.Method(modid="NotEnoughItems")
    public Iterable<Integer> getItemSpawnSlots(GuiContainer gui, ItemStack item) {
        return Collections.emptyList();
    }

    @Optional.Method(modid="NotEnoughItems")
    public List<TaggedInventoryArea> getInventoryAreas(GuiContainer gui) {
        return Collections.emptyList();
    }

    @Optional.Method(modid="NotEnoughItems")
    public boolean handleDragNDrop(GuiContainer gui, int mousex, int mousey, ItemStack draggedStack, int button) {
        return false;
    }

    @Optional.Method(modid="NotEnoughItems")
    public boolean hideItemPanelSlot(GuiContainer gui, int x, int y, int w, int h) {
        if (gui instanceof GuiForestry) {
            return ((GuiForestry)gui).ledgerManager.ledgerOverlaps(x, y, w, h);
        }
        return false;
    }
}

