/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.gui;

import forestry.api.farming.FarmDirection;
import forestry.core.gui.GuiForestryTitled;
import forestry.core.gui.ledgers.ClimateLedger;
import forestry.core.gui.ledgers.OwnerLedger;
import forestry.core.gui.widgets.SocketWidget;
import forestry.core.gui.widgets.TankWidget;
import forestry.farming.gui.ContainerFarm;
import forestry.farming.gui.FarmLedger;
import forestry.farming.gui.widgets.FarmLogicSlot;
import forestry.farming.multiblock.IFarmControllerInternal;
import forestry.farming.multiblock.MultiblockLogicFarm;
import forestry.farming.tiles.TileFarm;
import net.minecraft.entity.player.EntityPlayer;

public class GuiFarm
extends GuiForestryTitled<ContainerFarm, TileFarm> {
    public GuiFarm(EntityPlayer player, TileFarm tile) {
        super("textures/gui/mfarm.png", new ContainerFarm(player.inventory, tile), tile);
        this.widgetManager.add(new TankWidget(this.widgetManager, 15, 19, 0).setOverlayOrigin(216, 18));
        this.widgetManager.add(new SocketWidget(this.widgetManager, 69, 40, tile, 0));
        IFarmControllerInternal farmController = ((MultiblockLogicFarm)((TileFarm)this.inventory).getMultiblockLogic()).getController();
        this.widgetManager.add(new FarmLogicSlot(farmController, this.widgetManager, 69, 22, FarmDirection.NORTH));
        this.widgetManager.add(new FarmLogicSlot(farmController, this.widgetManager, 69, 58, FarmDirection.SOUTH));
        this.widgetManager.add(new FarmLogicSlot(farmController, this.widgetManager, 51, 40, FarmDirection.WEST));
        this.widgetManager.add(new FarmLogicSlot(farmController, this.widgetManager, 87, 40, FarmDirection.EAST));
        this.xSize = 216;
        this.ySize = 220;
    }

    @Override
    public void initGui() {
        super.initGui();
        IFarmControllerInternal farmController = ((MultiblockLogicFarm)((TileFarm)this.inventory).getMultiblockLogic()).getController();
        this.ledgerManager.add(new ClimateLedger(this.ledgerManager, farmController));
        this.ledgerManager.add(new FarmLedger(this.ledgerManager, farmController.getFarmLedgerDelegate()));
        this.ledgerManager.add(new OwnerLedger(this.ledgerManager, farmController));
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float var1, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(var1, mouseX, mouseY);
        int fertilizerRemain = ((MultiblockLogicFarm)((TileFarm)this.inventory).getMultiblockLogic()).getController().getStoredFertilizerScaled(16);
        if (fertilizerRemain > 0) {
            this.drawTexturedModalRect(this.guiLeft + 81, this.guiTop + 94 + 17 - fertilizerRemain, this.xSize, 17 - fertilizerRemain, 4, fertilizerRemain);
        }
    }
}

